/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.util;

import javax.annotation.Nonnull;
import mcjty.deepresonance.api.fluid.ILiquidCrystalData;
import mcjty.deepresonance.modules.core.CoreModule;
import mcjty.deepresonance.modules.core.data.LCD;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class LiquidCrystalData
implements ILiquidCrystalData {
    private final FluidStack referenceStack;
    public static final LiquidCrystalData EMPTY = LiquidCrystalData.fromStack(FluidStack.EMPTY);

    private LiquidCrystalData(FluidStack referenceStack) {
        this.referenceStack = referenceStack.copy();
    }

    public static FluidStack makeLiquidCrystalStack(int amount, float quality, float purity, float strength, float efficiency) {
        FluidStack fluidStack = new FluidStack(CoreModule.LIQUID_CRYSTAL.get(), amount);
        LiquidCrystalData.setStats(fluidStack, quality, purity, strength, efficiency);
        return fluidStack;
    }

    public static FluidStack makeLiquidCrystalStack(int amount, LCD lcd) {
        FluidStack fluidStack = new FluidStack(CoreModule.LIQUID_CRYSTAL.get(), amount);
        fluidStack.set(CoreModule.ITEM_LCD_DATA, (Object)lcd);
        return fluidStack;
    }

    public static FluidStack makeLiquidCrystalStack(int amount) {
        return LiquidCrystalData.makeLiquidCrystalStack(amount, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    @Nonnull
    public static LiquidCrystalData fromStack(FluidStack stack) {
        return new LiquidCrystalData(stack);
    }

    public static boolean isLiquidCrystal(Fluid fluid) {
        return fluid == CoreModule.LIQUID_CRYSTAL.get();
    }

    public static boolean isValidLiquidCrystalStack(@Nonnull FluidStack stack) {
        return !stack.isEmpty() && LiquidCrystalData.isLiquidCrystal(stack.getFluid());
    }

    public boolean isEmpty() {
        return this.referenceStack.isEmpty();
    }

    @Override
    public void merge(ILiquidCrystalData other) {
        FluidStack otherFluid = other.getFluidStack();
        this.merge(otherFluid);
    }

    @Override
    public void merge(FluidStack otherFluid) {
        if (this.referenceStack.getFluid() != otherFluid.getFluid()) {
            return;
        }
        if (this.referenceStack.getFluid() == CoreModule.LIQUID_CRYSTAL.get() && otherFluid.getFluid() == CoreModule.LIQUID_CRYSTAL.get()) {
            double quality = this.mixQuality(otherFluid);
            double purity = this.mixPurity(otherFluid);
            double strength = this.mixStrength(otherFluid);
            double efficiency = this.mixEfficiency(otherFluid);
            this.referenceStack.setAmount(this.referenceStack.getAmount() + otherFluid.getAmount());
            this.setStats(quality, purity, strength, efficiency);
        } else {
            this.referenceStack.setAmount(this.referenceStack.getAmount() + otherFluid.getAmount());
        }
    }

    private void setStats(double quality, double purity, double strength, double efficiency) {
        LiquidCrystalData.setStats(this.referenceStack, quality, purity, strength, efficiency);
    }

    private static void setStats(FluidStack fluidStack, double quality, double purity, double strength, double efficiency) {
        LCD lcd = new LCD(quality, purity, strength, efficiency);
        fluidStack.set(CoreModule.ITEM_LCD_DATA, (Object)lcd);
    }

    private double mixQuality(FluidStack other) {
        double f = (float)other.getAmount() / ((float)this.getAmount() + (float)other.getAmount());
        double thisValue = ((LCD)this.referenceStack.getOrDefault(CoreModule.ITEM_LCD_DATA, (Object)LCD.ZERO)).quality();
        double otherValue = ((LCD)other.getOrDefault(CoreModule.ITEM_LCD_DATA, (Object)LCD.ZERO)).quality();
        return (1.0 - f) * thisValue + f * otherValue;
    }

    private double mixPurity(FluidStack other) {
        double f = (float)other.getAmount() / ((float)this.getAmount() + (float)other.getAmount());
        double thisValue = ((LCD)this.referenceStack.getOrDefault(CoreModule.ITEM_LCD_DATA, (Object)LCD.ZERO)).purity();
        double otherValue = ((LCD)other.getOrDefault(CoreModule.ITEM_LCD_DATA, (Object)LCD.ZERO)).purity();
        return (1.0 - f) * thisValue + f * otherValue;
    }

    private double mixStrength(FluidStack other) {
        double f = (float)other.getAmount() / ((float)this.getAmount() + (float)other.getAmount());
        double thisValue = ((LCD)this.referenceStack.getOrDefault(CoreModule.ITEM_LCD_DATA, (Object)LCD.ZERO)).strength();
        double otherValue = ((LCD)other.getOrDefault(CoreModule.ITEM_LCD_DATA, (Object)LCD.ZERO)).strength();
        return (1.0 - f) * thisValue + f * otherValue;
    }

    private double mixEfficiency(FluidStack other) {
        double f = (float)other.getAmount() / ((float)this.getAmount() + (float)other.getAmount());
        double thisValue = ((LCD)this.referenceStack.getOrDefault(CoreModule.ITEM_LCD_DATA, (Object)LCD.ZERO)).efficiency();
        double otherValue = ((LCD)other.getOrDefault(CoreModule.ITEM_LCD_DATA, (Object)LCD.ZERO)).efficiency();
        return (1.0 - f) * thisValue + f * otherValue;
    }

    @Override
    public double getQuality() {
        return ((LCD)this.referenceStack.getOrDefault(CoreModule.ITEM_LCD_DATA, (Object)LCD.ZERO)).quality();
    }

    @Override
    public void setQuality(double quality) {
        LCD lcd = (LCD)this.referenceStack.getOrDefault(CoreModule.ITEM_LCD_DATA, (Object)LCD.ZERO);
        this.referenceStack.set(CoreModule.ITEM_LCD_DATA, (Object)lcd.withQuality(quality));
    }

    @Override
    public double getPurity() {
        return ((LCD)this.referenceStack.getOrDefault(CoreModule.ITEM_LCD_DATA, (Object)LCD.ZERO)).purity();
    }

    @Override
    public void setPurity(double purity) {
        LCD lcd = (LCD)this.referenceStack.getOrDefault(CoreModule.ITEM_LCD_DATA, (Object)LCD.ZERO);
        this.referenceStack.set(CoreModule.ITEM_LCD_DATA, (Object)lcd.withPurity(purity));
    }

    @Override
    public double getStrength() {
        return ((LCD)this.referenceStack.getOrDefault(CoreModule.ITEM_LCD_DATA, (Object)LCD.ZERO)).strength();
    }

    @Override
    public void setStrength(double strength) {
        LCD lcd = (LCD)this.referenceStack.getOrDefault(CoreModule.ITEM_LCD_DATA, (Object)LCD.ZERO);
        this.referenceStack.set(CoreModule.ITEM_LCD_DATA, (Object)lcd.withStrength(strength));
    }

    @Override
    public double getEfficiency() {
        return ((LCD)this.referenceStack.getOrDefault(CoreModule.ITEM_LCD_DATA, (Object)LCD.ZERO)).efficiency();
    }

    @Override
    public void setEfficiency(double efficiency) {
        LCD lcd = (LCD)this.referenceStack.getOrDefault(CoreModule.ITEM_LCD_DATA, (Object)LCD.ZERO);
        this.referenceStack.set(CoreModule.ITEM_LCD_DATA, (Object)lcd.withEfficiency(efficiency));
    }

    @Override
    public int getAmount() {
        return this.referenceStack.getAmount();
    }

    public LCD getLCD() {
        return (LCD)this.referenceStack.getOrDefault(CoreModule.ITEM_LCD_DATA, (Object)LCD.ZERO);
    }

    @Override
    public void setAmount(int i) {
        if (!this.referenceStack.isEmpty()) {
            this.referenceStack.setAmount(i);
        }
    }

    @Override
    public FluidStack getFluidStack() {
        return this.referenceStack;
    }

    public String toString() {
        return "Amount: " + this.referenceStack.getAmount() + " ,Quality: " + this.getQuality() + " ,Purity: " + this.getPurity() + " ,Strength: " + this.getStrength() + " ,Efficiency: " + this.getEfficiency();
    }
}

