/*
 * Decompiled with CFR 0.152.
 */
package fr.democraft.rcs.pterodactyl.utils;

import fr.democraft.rcs.pterodactyl.PterodactylServerProvider;
import fr.democraft.rcs.pterodactyl.configs.MainConfig;
import fr.democraft.rcs.pterodactyl.utils.PterodactylAPI;
import group.aelysium.rustyconnector.proxy.family.Family;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public class MetadataHelper {
    public static int readAndComputeMetadata(String serverName, Family family) {
        try {
            Optional metaMemory = family.fetchMetadata("smart.memory");
            Optional metaDisk = family.fetchMetadata("smart.pterodactyl.disk");
            Optional metaCpu = family.fetchMetadata("smart.pterodactyl.cpu");
            Optional metaSwap = family.fetchMetadata("smart.pterodactyl.swap");
            Optional metaIo = family.fetchMetadata("smart.pterodactyl.io");
            Optional metaDatabases = family.fetchMetadata("smart.pterodactyl.databases");
            Optional metaAllocations = family.fetchMetadata("smart.pterodactyl.allocations");
            Optional metaBackups = family.fetchMetadata("smart.pterodactyl.backups");
            Optional metaEgg = family.fetchMetadata("smart.pterodactyl.egg");
            Optional metaOwner = family.fetchMetadata("smart.pterodactyl.user");
            Optional metaDefaultAlloc = family.fetchMetadata("smart.pterodactyl.allocation_default");
            int memory = MetadataHelper.unwrap(metaMemory, 1024);
            int disk = MetadataHelper.unwrap(metaDisk, 10240);
            int cpu = MetadataHelper.unwrap(metaCpu, 0);
            int swap = MetadataHelper.unwrap(metaSwap, 0);
            int io = MetadataHelper.unwrap(metaIo, 500);
            int databases = MetadataHelper.unwrap(metaDatabases, 0);
            int allocations = MetadataHelper.unwrap(metaAllocations, 1);
            int backups = MetadataHelper.unwrap(metaBackups, 0);
            int egg = MetadataHelper.unwrap(metaEgg, 1);
            int owner = MetadataHelper.unwrap(metaOwner, 1);
            int defaultAllocation = MetadataHelper.unwrap(metaDefaultAlloc, 1);
            PterodactylAPI.Limits limits = new PterodactylAPI.Limits(memory, swap, disk, io, cpu);
            limits.threads = MainConfig.DEFAULT_THREADS;
            limits.oom_disabled = false;
            PterodactylAPI.FeatureLimits featureLimits = new PterodactylAPI.FeatureLimits(databases, allocations, backups);
            PterodactylAPI.Allocation allocation = new PterodactylAPI.Allocation(defaultAllocation, new int[0]);
            Optional environment = family.fetchMetadata("smart.pterodactyl.env");
            Map envMap = environment.orElse(new HashMap());
            envMap.put("RUSTYCONNECTOR_SERVERID", "");
            String dockerImage = "quay.io/pterodactyl/core:java-17";
            String startup = "java -Xms128M -Xmx${SERVER_MEMORY}M -jar server.jar";
            Optional metaDocker = family.fetchMetadata("smart.pterodactyl.docker_image");
            dockerImage = metaDocker.orElse("quay.io/pterodactyl/core:java-17");
            Optional metaStartup = family.fetchMetadata("smart.pterodactyl.startup");
            startup = metaStartup.orElse("java -Xms128M -Xmx${SERVER_MEMORY}M -jar server.jar");
            return PterodactylAPI.createPterodactylServer(serverName, owner, egg, limits, featureLimits, allocation, dockerImage, startup, envMap, null);
        }
        catch (IOException | InterruptedException ex) {
            System.err.println("Error creating pterodactyl server: " + ex.getMessage());
            ex.printStackTrace();
            return 0;
        }
        catch (Exception ex) {
            System.err.println("Unexpected error while preparing server creation: " + ex.getMessage());
            ex.printStackTrace();
            return 0;
        }
    }

    public static String getIDFromFamily(Family family) {
        if (Objects.equals(PterodactylServerProvider.config.ID_PREFIX, "NANOID")) {
            return family.id() + (family.size() + 1);
        }
        if (Objects.equals(PterodactylServerProvider.config.ID_PREFIX, "UUID")) {
            return UUID.randomUUID().toString();
        }
        return family.id() + UUID.randomUUID().toString();
    }

    private static int unwrap(Optional<Integer> opt, int fallback) {
        return opt != null && opt.isPresent() ? opt.get() : fallback;
    }
}

