/*
 * Decompiled with CFR 0.152.
 */
package fr.democraft.rcs.pterodactyl;

import fr.democraft.rcm.smart.events.CreatePhysicalServer;
import fr.democraft.rcm.smart.events.DeletePhysicalServer;
import fr.democraft.rcs.pterodactyl.utils.MetadataHelper;
import fr.democraft.rcs.pterodactyl.utils.PterodactylAPI;
import group.aelysium.rustyconnector.common.events.EventListener;
import group.aelysium.rustyconnector.proxy.events.ServerLeaveEvent;
import group.aelysium.rustyconnector.proxy.family.Family;
import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;

public class Events {
    private static final HashMap<String, Integer> serverCache = new HashMap();
    private static final HashMap<String, Integer> serverDeletitionWaitlist = new HashMap();

    @EventListener
    public static void createHandler(CreatePhysicalServer e) {
        if (e.providerId != "pterodactyl") {
            return;
        }
        System.out.println(e.family.displayName() + " needs a new server, Pterodactyl will create it.");
        String serverId = MetadataHelper.getIDFromFamily(e.family);
        int pterodactylId = MetadataHelper.readAndComputeMetadata(serverId, e.family);
        serverCache.put(serverId, pterodactylId);
    }

    @EventListener
    public static void deleteHandler(DeletePhysicalServer e) {
        if (!Objects.equals(e.providerId, "pterodactyl")) {
            return;
        }
        serverDeletitionWaitlist.compute(e.family.id(), (k, waitlist) -> waitlist == null ? 1 : waitlist + 1);
    }

    @EventListener
    public static void playerLeaveHandler(ServerLeaveEvent e) throws IOException, InterruptedException {
        String serverId;
        if (serverDeletitionWaitlist.getOrDefault(((Family)e.server.family().get()).id(), 0) > 0 && e.server.players() == 0L && serverCache.containsKey(serverId = e.server.id())) {
            int pterodactylId = serverCache.get(serverId);
            System.out.println(e.server.id() + " server is no longer used, Pterodactyl will delete it.");
            PterodactylAPI.deletePterodactylServer(pterodactylId);
            serverCache.remove(serverId);
            serverDeletitionWaitlist.computeIfPresent(((Family)e.server.family().get()).id(), (k, waitlist) -> waitlist - 1);
        }
    }
}

