/*
 * Decompiled with CFR 0.152.
 */
package com.tiestoettoet.create_train_parts.content.decoration.slidingWindow;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.IHaveBigOutline;
import com.tiestoettoet.create_train_parts.AllBlockEntityTypes;
import com.tiestoettoet.create_train_parts.AllBlocks;
import com.tiestoettoet.create_train_parts.content.decoration.slidingWindow.SlidingWindowBlockEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SlidingWindowBlock
extends HorizontalDirectionalBlock
implements IBE<SlidingWindowBlockEntity>,
IHaveBigOutline,
IWrenchable {
    public static final BooleanProperty OPEN = BooleanProperty.create((String)"open");
    public static final BooleanProperty POWERED = BooleanProperty.create((String)"powered");
    public static final BooleanProperty VISIBLE = BooleanProperty.create((String)"visible");
    public static final EnumProperty<SlidingWindowBlockEntity.SelectionMode> MODE = EnumProperty.create((String)"mode", SlidingWindowBlockEntity.SelectionMode.class);
    protected static final VoxelShape NORTH_OPEN_UP = Block.box((double)0.0, (double)15.0, (double)15.9, (double)16.0, (double)31.0, (double)18.9);
    protected static final VoxelShape NORTH_OPEN_DOWN = Block.box((double)0.0, (double)-15.0, (double)15.9, (double)16.0, (double)1.0, (double)18.9);
    protected static final VoxelShape NORTH_OPEN_LEFT = Block.box((double)15.0, (double)0.0, (double)15.9, (double)31.0, (double)16.0, (double)18.9);
    protected static final VoxelShape NORTH_OPEN_RIGHT = Block.box((double)-15.0, (double)0.0, (double)15.9, (double)1.0, (double)16.0, (double)18.9);
    protected static final VoxelShape NORTH_CLOSED = Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_OPEN_UP = Block.box((double)0.0, (double)15.0, (double)-2.9, (double)16.0, (double)31.0, (double)0.1);
    protected static final VoxelShape SOUTH_OPEN_DOWN = Block.box((double)0.0, (double)-15.0, (double)-2.9, (double)16.0, (double)1.0, (double)0.1);
    protected static final VoxelShape SOUTH_OPEN_LEFT = Block.box((double)-15.0, (double)0.0, (double)-2.9, (double)1.0, (double)16.0, (double)0.1);
    protected static final VoxelShape SOUTH_OPEN_RIGHT = Block.box((double)15.0, (double)0.0, (double)-2.9, (double)31.0, (double)16.0, (double)0.1);
    protected static final VoxelShape SOUTH_CLOSED = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape EAST_OPEN_UP = Block.box((double)-2.9, (double)15.0, (double)0.0, (double)0.1, (double)31.0, (double)16.0);
    protected static final VoxelShape EAST_OPEN_DOWN = Block.box((double)-2.9, (double)-15.0, (double)0.0, (double)0.1, (double)1.0, (double)16.0);
    protected static final VoxelShape EAST_OPEN_LEFT = Block.box((double)-2.9, (double)0.0, (double)15.0, (double)0.1, (double)16.0, (double)31.0);
    protected static final VoxelShape EAST_OPEN_RIGHT = Block.box((double)-2.9, (double)0.0, (double)-15.0, (double)0.1, (double)16.0, (double)1.0);
    protected static final VoxelShape EAST_CLOSED = Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_OPEN_UP = Block.box((double)15.9, (double)15.0, (double)0.0, (double)18.9, (double)31.0, (double)16.0);
    protected static final VoxelShape WEST_OPEN_DOWN = Block.box((double)15.9, (double)-15.0, (double)0.0, (double)18.9, (double)1.0, (double)16.0);
    protected static final VoxelShape WEST_OPEN_LEFT = Block.box((double)15.9, (double)0.0, (double)-15.0, (double)18.9, (double)16.0, (double)1.0);
    protected static final VoxelShape WEST_OPEN_RIGHT = Block.box((double)15.9, (double)0.0, (double)15.0, (double)18.9, (double)16.0, (double)31.0);
    protected static final VoxelShape WEST_CLOSED = Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private final BlockSetType type = BlockSetType.OAK;

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }

    public SlidingWindowBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        SlidingWindowBlockEntity slidingWindowBlockEntity = (SlidingWindowBlockEntity)level.getBlockEntity(pos);
        SlidingWindowBlockEntity.SelectionMode mode = slidingWindowBlockEntity != null ? slidingWindowBlockEntity.getMode() : SlidingWindowBlockEntity.SelectionMode.UP;
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
                    switch (mode) {
                        case UP: {
                            return NORTH_OPEN_UP;
                        }
                        case DOWN: {
                            return NORTH_OPEN_DOWN;
                        }
                        case LEFT: {
                            return NORTH_OPEN_LEFT;
                        }
                        case RIGHT: {
                            return NORTH_OPEN_RIGHT;
                        }
                    }
                    break;
                }
                return NORTH_CLOSED;
            }
            case EAST: {
                if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
                    switch (mode) {
                        case UP: {
                            return EAST_OPEN_UP;
                        }
                        case DOWN: {
                            return EAST_OPEN_DOWN;
                        }
                        case LEFT: {
                            return EAST_OPEN_LEFT;
                        }
                        case RIGHT: {
                            return EAST_OPEN_RIGHT;
                        }
                    }
                    break;
                }
                return EAST_CLOSED;
            }
            case SOUTH: {
                if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
                    switch (mode) {
                        case UP: {
                            return SOUTH_OPEN_UP;
                        }
                        case DOWN: {
                            return SOUTH_OPEN_DOWN;
                        }
                        case LEFT: {
                            return SOUTH_OPEN_LEFT;
                        }
                        case RIGHT: {
                            return SOUTH_OPEN_RIGHT;
                        }
                    }
                    break;
                }
                return SOUTH_CLOSED;
            }
            case WEST: {
                if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
                    switch (mode) {
                        case UP: {
                            return WEST_OPEN_UP;
                        }
                        case DOWN: {
                            return WEST_OPEN_DOWN;
                        }
                        case LEFT: {
                            return WEST_OPEN_LEFT;
                        }
                        case RIGHT: {
                            return WEST_OPEN_RIGHT;
                        }
                    }
                    break;
                }
                return WEST_CLOSED;
            }
        }
        return NORTH_CLOSED;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getShape(state, level, pos, CollisionContext.empty());
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockPos pos = pContext.getClickedPos();
        BlockState state = pContext.getLevel().getBlockState(pos);
        Direction facing = pContext.getHorizontalDirection().getOpposite();
        Level level = pContext.getLevel();
        BlockState stateForPlacement = super.getStateForPlacement(pContext);
        boolean open = false;
        BlockState leftState = level.getBlockState(pos.relative(facing.getCounterClockWise()));
        BlockState rightState = level.getBlockState(pos.relative(facing.getClockWise()));
        if (leftState.getBlock() instanceof SlidingWindowBlock && leftState.hasProperty((Property)OPEN) && ((Boolean)leftState.getValue((Property)OPEN)).booleanValue()) {
            open = true;
        }
        if (rightState.getBlock() instanceof SlidingWindowBlock && rightState.hasProperty((Property)OPEN) && ((Boolean)rightState.getValue((Property)OPEN)).booleanValue()) {
            open = true;
        }
        if (stateForPlacement != null && ((Boolean)stateForPlacement.getValue((Property)OPEN)).booleanValue()) {
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)stateForPlacement.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open))).setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(!open))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(open))).setValue((Property)FACING, (Comparable)facing)).setValue(MODE, (Comparable)((Object)SlidingWindowBlockEntity.SelectionMode.UP));
        }
        return stateForPlacement;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return switch (pathComputationType) {
            case PathComputationType.LAND, PathComputationType.AIR -> (Boolean)state.getValue((Property)OPEN);
            default -> false;
        };
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        this.toggle(state, level, pos, player, null);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected void onExplosionHit(BlockState state, Level level, BlockPos pos, Explosion explosion, BiConsumer<ItemStack, BlockPos> dropConsumer) {
        if (explosion.canTriggerBlocks() && this.type.canOpenByWindCharge() && !((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            this.toggle(state, level, pos, null, null);
        }
        super.onExplosionHit(state, level, pos, explosion, dropConsumer);
    }

    public void toggle(BlockState state, Level level, BlockPos pos, @Nullable Player player, Boolean open) {
        this.toggle(state, level, pos, player, open, 10);
    }

    public void toggle(BlockState state, Level level, BlockPos pos, @Nullable Player player, Boolean open, int flags) {
        if (open == null) {
            open = (Boolean)state.getValue((Property)OPEN) == false;
        }
        state = (BlockState)((BlockState)state.setValue((Property)OPEN, (Comparable)open)).setValue((Property)POWERED, (Comparable)open);
        if (open.booleanValue()) {
            state = (BlockState)state.setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(false));
        }
        level.setBlock(pos, state, flags);
        level.gameEvent((Entity)player, (Holder)(open != false ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
        List<Map<String, Object>> windows = this.getConnectedWindows(state, level, pos, player);
        for (Map<String, Object> window : windows) {
            BlockState windowState = (BlockState)window.get("state");
            BlockPos windowPos = (BlockPos)window.get("pos");
            windowState = (BlockState)((BlockState)windowState.setValue((Property)OPEN, (Comparable)open)).setValue((Property)POWERED, (Comparable)open);
            if (open.booleanValue()) {
                windowState = (BlockState)windowState.setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(false));
            }
            level.setBlock(windowPos, windowState, flags);
            level.gameEvent((Entity)player, (Holder)(open != false ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), windowPos);
        }
    }

    public void setOpen(@Nullable Entity entity, Level level, BlockState state, BlockPos pos, boolean open) {
        if (!state.is((Block)this)) {
            return;
        }
        if ((Boolean)state.getValue((Property)OPEN) == open) {
            return;
        }
        BlockState changedState = (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(open));
        if (open) {
            changedState = (BlockState)changedState.setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(false));
        }
        level.setBlock(pos, changedState, 10);
        level.gameEvent(entity, (Holder)(open ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), pos);
    }

    private List<Map<String, Object>> getConnectedWindows(BlockState state, Level level, BlockPos pos, @Nullable Player player) {
        LinkedList<BlockPos> frontier = new LinkedList<BlockPos>();
        ArrayList<Map<String, Object>> connectedWindows = new ArrayList<Map<String, Object>>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        frontier.add(pos);
        Direction.Axis axis = ((Direction)state.getValue((Property)FACING)).getAxis();
        SlidingWindowBlockEntity.SelectionMode mode = (SlidingWindowBlockEntity.SelectionMode)((Object)state.getValue(MODE));
        while (!frontier.isEmpty()) {
            BlockPos currentPos = (BlockPos)frontier.poll();
            if (visited.contains(currentPos)) continue;
            visited.add(currentPos);
            BlockState currentState = level.getBlockState(currentPos);
            if (!(currentState.getBlock() instanceof SlidingWindowBlock) || !SlidingWindowBlock.sameKind(state, currentState) || ((Direction)currentState.getValue((Property)FACING)).getAxis() != axis || currentState.getValue(MODE) != mode) continue;
            HashMap<String, Object> windowData = new HashMap<String, Object>();
            windowData.put("state", currentState);
            windowData.put("pos", currentPos);
            windowData.put("player", player);
            connectedWindows.add(windowData);
            for (Direction direction : Iterate.directions) {
                BlockState neighborState;
                BlockPos neighborPos = currentPos.relative(direction);
                if (visited.contains(neighborPos) || !level.isLoaded(neighborPos) || !AllBlocks.GLASS_SLIDING_WINDOW.has(neighborState = level.getBlockState(neighborPos)) && !AllBlocks.ANDESITE_SLIDING_WINDOW.has(neighborState) && !AllBlocks.BRASS_SLIDING_WINDOW.has(neighborState) && !AllBlocks.COPPER_SLIDING_WINDOW.has(neighborState) && !AllBlocks.TRAIN_SLIDING_WINDOW.has(neighborState)) continue;
                frontier.add(neighborPos);
            }
        }
        return connectedWindows;
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean manuallyClosed;
        if (!(state.getBlock() instanceof SlidingWindowBlock)) {
            return;
        }
        SlidingWindowBlockEntity blockEntity = (SlidingWindowBlockEntity)level.getBlockEntity(pos);
        boolean isPowered = level.hasNeighborSignal(pos);
        boolean bl = manuallyClosed = blockEntity != null && blockEntity.isManuallyClosed();
        boolean shouldOpen = isPowered ? !manuallyClosed : false;
        this.toggle(state, level, pos, null, shouldOpen, 2);
        List<Map<String, Object>> windows = this.getConnectedWindows(state, level, pos, null);
        for (Map<String, Object> window : windows) {
            BlockState windowState = (BlockState)window.get("state");
            BlockPos windowPos = (BlockPos)window.get("pos");
            if (windowState.getValue((Property)FACING) != state.getValue((Property)FACING) || !SlidingWindowBlock.sameKind(state, windowState)) continue;
            boolean windowPowered = SlidingWindowBlock.isWindowPowered(level, windowPos, windowState);
            if (windowPowered != (Boolean)windowState.getValue((Property)POWERED)) {
                windowState = (BlockState)windowState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(windowPowered));
                windowState = (BlockState)windowState.setValue((Property)OPEN, (Comparable)Boolean.valueOf(!windowPowered));
                level.setBlock(windowPos, windowState, 2);
                level.gameEvent(null, (Holder)(!windowPowered ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE), windowPos);
                continue;
            }
            level.setBlock(windowPos, windowState, 2);
        }
    }

    public static Map<String, Map<String, Object>> getNeighbors(Level level, BlockPos pos) {
        BlockState rightState;
        BlockState leftState;
        BlockPos right;
        BlockPos left;
        HashMap<String, Map<String, Object>> neighbors = new HashMap<String, Map<String, Object>>();
        HashMap<String, Object> leftData = new HashMap<String, Object>();
        HashMap<String, Object> rightData = new HashMap<String, Object>();
        HashMap<String, Object> upData = new HashMap<String, Object>();
        HashMap<String, Object> downData = new HashMap<String, Object>();
        Direction facing = (Direction)level.getBlockState(pos).getValue((Property)FACING);
        if (facing == Direction.NORTH || facing == Direction.SOUTH) {
            int x = pos.getX();
            left = new BlockPos(facing == Direction.NORTH ? x + 1 : x - 1, pos.getY(), pos.getZ());
            right = new BlockPos(facing == Direction.NORTH ? x - 1 : x + 1, pos.getY(), pos.getZ());
            leftState = level.getBlockState(left);
            rightState = level.getBlockState(right);
        } else {
            int z = pos.getZ();
            left = new BlockPos(pos.getX(), pos.getY(), facing == Direction.EAST ? z + 1 : z - 1);
            right = new BlockPos(pos.getX(), pos.getY(), facing == Direction.EAST ? z - 1 : z + 1);
            leftState = level.getBlockState(left);
            rightState = level.getBlockState(right);
        }
        BlockState upState = level.getBlockState(pos.above());
        BlockState downState = level.getBlockState(pos.below());
        BlockPos up = pos.above();
        BlockPos down = pos.below();
        leftData.put("state", leftState);
        leftData.put("pos", left);
        rightData.put("state", rightState);
        rightData.put("pos", right);
        upData.put("state", upState);
        upData.put("pos", up);
        downData.put("state", downState);
        downData.put("pos", down);
        neighbors.put("left", leftData);
        neighbors.put("right", rightData);
        neighbors.put("up", upData);
        neighbors.put("down", downData);
        return neighbors;
    }

    public static BlockState getState(BlockState state, BlockPos pos, Level level, Direction facing, String function) {
        BlockState finalState = state.getBlock() instanceof SlidingWindowBlock ? (BlockState)((BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)facing)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(true)) : state;
        if (((Boolean)finalState.getValue((Property)OPEN)).booleanValue()) {
            finalState = (BlockState)finalState.setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(false));
        }
        return finalState;
    }

    public boolean skipRendering(BlockState state, BlockState other, Direction side) {
        return SlidingWindowBlock.isConnected(state, other, side);
    }

    public static boolean isConnected(BlockState state, BlockState other, Direction direction) {
        if (state.getBlock() instanceof SlidingWindowBlock && other.getBlock() instanceof SlidingWindowBlock) {
            Direction otherFacing;
            SlidingWindowBlockEntity.SelectionMode mode = (SlidingWindowBlockEntity.SelectionMode)((Object)state.getValue(MODE));
            SlidingWindowBlockEntity.SelectionMode otherMode = (SlidingWindowBlockEntity.SelectionMode)((Object)other.getValue(MODE));
            Direction facing = (Direction)state.getValue((Property)FACING);
            return facing == (otherFacing = (Direction)other.getValue((Property)FACING)) && mode == otherMode;
        }
        return false;
    }

    public static boolean sameKind(BlockState state1, BlockState state2) {
        return state1.getBlock() == state2.getBlock();
    }

    public static boolean isWindowPowered(Level level, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        BlockPos leftPos = pos.relative(facing.getCounterClockWise());
        BlockPos rightPos = pos.relative(facing.getClockWise());
        return level.hasNeighborSignal(pos) || level.hasNeighborSignal(leftPos) || level.hasNeighborSignal(rightPos);
    }

    public static boolean isSlideOpen(BlockState state) {
        return (Boolean)state.getValue((Property)OPEN);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, OPEN, POWERED, VISIBLE, MODE});
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public RenderShape getRenderShape(BlockState state) {
        return (Boolean)state.getValue((Property)VISIBLE) != false ? RenderShape.MODEL : RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return super.newBlockEntity(pos, state);
    }

    public Class<SlidingWindowBlockEntity> getBlockEntityClass() {
        return SlidingWindowBlockEntity.class;
    }

    public BlockEntityType<? extends SlidingWindowBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.SLIDING_WINDOW.get();
    }
}

