/*
 * Decompiled with CFR 0.152.
 */
package com.tiestoettoet.create_train_parts.content.decoration.slidingWindow;

import com.mojang.datafixers.util.Pair;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.AllSpecialTextures;
import com.tiestoettoet.create_train_parts.content.decoration.slidingWindow.SlidingWindowBlockEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.render.BindableTexture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class SlidingWindowRangeDisplay {
    private static final int DISPLAY_TIME = 200;
    private static GroupEntry lastHoveredGroup = null;
    static Map<BlockPos, Entry> entries = new HashMap<BlockPos, Entry>();
    static List<GroupEntry> groupEntries = new ArrayList<GroupEntry>();

    public static void tick() {
        GroupEntry existingGroupForPos;
        LocalPlayer player = Minecraft.getInstance().player;
        ClientLevel world = Minecraft.getInstance().level;
        boolean hasWrench = AllItems.WRENCH.isIn(player.getMainHandItem());
        Iterator<Object> iterator = entries.keySet().iterator();
        while (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            Entry entry = entries.get(pos);
            if (SlidingWindowRangeDisplay.tickEntry(entry, hasWrench)) {
                iterator.remove();
            }
            Outliner.getInstance().keep(entry.getOutlineKey());
        }
        iterator = groupEntries.iterator();
        while (iterator.hasNext()) {
            GroupEntry group = (GroupEntry)iterator.next();
            if (SlidingWindowRangeDisplay.tickEntry(group, hasWrench)) {
                iterator.remove();
                if (group == lastHoveredGroup) {
                    lastHoveredGroup = null;
                }
            }
            Outliner.getInstance().keep(group.getOutlineKey());
        }
        if (!hasWrench) {
            return;
        }
        HitResult over = Minecraft.getInstance().hitResult;
        if (!(over instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult ray = (BlockHitResult)over;
        BlockPos pos = ray.getBlockPos();
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity == null || blockEntity.isRemoved()) {
            return;
        }
        if (!(blockEntity instanceof SlidingWindowBlockEntity)) {
            return;
        }
        SlidingWindowBlockEntity slidingWindowBlockEntity = (SlidingWindowBlockEntity)blockEntity;
        boolean ctrl = AllKeys.ctrlDown();
        if (ctrl && (existingGroupForPos = SlidingWindowRangeDisplay.getExistingGroupForPos(pos)) != null) {
            for (SlidingWindowBlockEntity included : existingGroupForPos.includedBEs) {
                entries.remove(included.getBlockPos());
            }
            existingGroupForPos.timer = 200;
            return;
        }
        if (!entries.containsKey(pos) || ctrl) {
            SlidingWindowRangeDisplay.display(slidingWindowBlockEntity);
        } else if (!ctrl) {
            SlidingWindowRangeDisplay.entries.get((Object)pos).timer = 200;
        }
    }

    private static boolean tickEntry(Entry entry, boolean hasWrench) {
        SlidingWindowBlockEntity slidingWindowBlockEntity = entry.be;
        Level beWorld = slidingWindowBlockEntity.getLevel();
        ClientLevel world = Minecraft.getInstance().level;
        if (slidingWindowBlockEntity.isRemoved() || beWorld == null || beWorld != world || !world.isLoaded(slidingWindowBlockEntity.getBlockPos())) {
            return true;
        }
        if (!hasWrench && entry.timer > 20) {
            entry.timer = 20;
            return false;
        }
        --entry.timer;
        return entry.timer == 0;
    }

    public static void display(SlidingWindowBlockEntity slidingWindow) {
        if (AllKeys.ctrlDown()) {
            GroupEntry hoveredGroup = new GroupEntry(slidingWindow);
            for (SlidingWindowBlockEntity included : hoveredGroup.includedBEs) {
                Outliner.getInstance().remove((Object)Pair.of((Object)included.getBlockPos(), (Object)1));
            }
            groupEntries.forEach(entry -> Outliner.getInstance().remove(entry.getOutlineKey()));
            groupEntries.clear();
            entries.clear();
            groupEntries.add(hoveredGroup);
            for (GroupEntry groupEntry : groupEntries) {
                for (SlidingWindowBlockEntity slidingWindowBlockEntity : groupEntry.includedBEs) {
                }
            }
            return;
        }
        BlockPos pos = slidingWindow.getBlockPos();
        GroupEntry entry2 = SlidingWindowRangeDisplay.getExistingGroupForPos(pos);
        if (entry2 != null) {
            Outliner.getInstance().remove(entry2.getOutlineKey());
        }
        groupEntries.clear();
        entries.clear();
        entries.put(pos, new Entry(slidingWindow));
    }

    private static GroupEntry getExistingGroupForPos(BlockPos pos) {
        for (GroupEntry groupEntry : groupEntries) {
            for (SlidingWindowBlockEntity slidingWindow : groupEntry.includedBEs) {
                if (!pos.equals((Object)slidingWindow.getBlockPos())) continue;
                return groupEntry;
            }
        }
        return null;
    }

    private static class Entry {
        SlidingWindowBlockEntity be;
        int timer;

        public Entry(SlidingWindowBlockEntity be) {
            this.be = be;
            this.timer = 200;
            Outliner.getInstance().showCluster(this.getOutlineKey(), this.createSelection(be)).colored(0xFFFFFF).disableLineNormals().lineWidth(0.0625f).withFaceTexture((BindableTexture)AllSpecialTextures.HIGHLIGHT_CHECKERED);
        }

        protected Object getOutlineKey() {
            return Pair.of((Object)this.be.getBlockPos(), (Object)1);
        }

        protected Set<BlockPos> createSelection(SlidingWindowBlockEntity slidingWindow) {
            HashSet<BlockPos> positions = new HashSet<BlockPos>();
            List<BlockPos> includedBlockPositions = slidingWindow.getIncludedBlockPositions(null, true);
            if (includedBlockPositions == null) {
                return Collections.emptySet();
            }
            positions.addAll(includedBlockPositions);
            return positions;
        }
    }

    private static class GroupEntry
    extends Entry {
        List<SlidingWindowBlockEntity> includedBEs;

        public GroupEntry(SlidingWindowBlockEntity be) {
            super(be);
        }

        @Override
        protected Object getOutlineKey() {
            return this;
        }

        @Override
        protected Set<BlockPos> createSelection(SlidingWindowBlockEntity slidingWindow) {
            HashSet<BlockPos> list = new HashSet<BlockPos>();
            this.includedBEs = this.be.collectSlidingWindowGroup();
            if (this.includedBEs == null) {
                return list;
            }
            for (SlidingWindowBlockEntity slidingWindowBlockEntity : this.includedBEs) {
                list.addAll(super.createSelection(slidingWindowBlockEntity));
            }
            return list;
        }
    }
}

