/*
 * Decompiled with CFR 0.152.
 */
package com.tiestoettoet.create_train_parts.content.decoration.trainStep;

import com.simibubi.create.AllKeys;
import com.simibubi.create.api.contraption.BlockMovementChecks;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueSettingsBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.tiestoettoet.create_train_parts.AllBlocks;
import com.tiestoettoet.create_train_parts.content.decoration.trainStep.TrainStepBlock;
import com.tiestoettoet.create_train_parts.content.decoration.trainStep.TrainStepModeSlot;
import com.tiestoettoet.create_train_parts.content.decoration.trainStep.TrainStepRangeDisplay;
import com.tiestoettoet.create_train_parts.content.decoration.trainStep.TrainStepType;
import com.tiestoettoet.create_train_parts.content.foundation.blockEntity.behaviour.scrollValue.BulkScrollOptionBehaviour;
import com.tiestoettoet.create_train_parts.content.foundation.gui.AllIcons;
import com.tiestoettoet.create_train_parts.content.foundation.utility.CreateTrainPartsLang;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TrainStepBlockEntity
extends SmartBlockEntity {
    LerpedFloat animation;
    int bridgeTicks;
    boolean deferUpdate;
    Map<String, BlockState> neighborStates = new HashMap<String, BlockState>();
    TrainStepType trainStepType;
    public ScrollOptionBehaviour<SlideMode> slideMode;
    public int currentlySelectedRange;
    ScrollValueBehaviour range;
    protected AssemblyException lastException;
    Object openObj = null;

    public TrainStepBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.animation = LerpedFloat.linear().startWithValue(TrainStepBlockEntity.isOpen(this.getBlockState()) ? 1.0 : 0.0);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.slideMode = new TrainStepOptionBehaviour<SlideMode>(SlideMode.class, (Component)CreateTrainPartsLang.translateDirect("train_step.mode", new Object[0]), this, (ValueBoxTransform)new TrainStepModeSlot(), be -> ((TrainStepBlockEntity)((Object)be)).collectTrainStepGroup());
        behaviours.add((BlockEntityBehaviour)this.slideMode);
        this.slideMode.onlyActiveWhen(this::isVisible);
        this.slideMode.requiresWrench();
        this.slideMode.withCallback(settings -> CatnipServices.PLATFORM.executeOnClientOnly(() -> () -> TrainStepRangeDisplay.display(this)));
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        this.lastException = AssemblyException.read((CompoundTag)tag, (HolderLookup.Provider)registries);
        super.read(tag, registries, clientPacket);
        this.invalidateRenderBoundingBox();
        if (tag.contains("ForceOpen")) {
            this.openObj = tag.getBoolean("ForceOpen");
        }
    }

    public SlideMode getMode() {
        return (SlideMode)this.slideMode.get();
    }

    public int getRange() {
        return this.range.getValue();
    }

    public List<BlockPos> getIncludedBlockPositions(Direction forcedMovement, boolean visualize) {
        if (!(this.getBlockState().getBlock() instanceof TrainStepBlock)) {
            return Collections.emptyList();
        }
        return this.getIncludedBlockPositionsLinear(forcedMovement, visualize);
    }

    public List<TrainStepBlockEntity> collectTrainStepGroup() {
        LinkedList<BlockPos> frontier = new LinkedList<BlockPos>();
        ArrayList<TrainStepBlockEntity> collected = new ArrayList<TrainStepBlockEntity>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        frontier.add(this.worldPosition);
        while (!frontier.isEmpty()) {
            BlockPos current = (BlockPos)frontier.poll();
            if (visited.contains(current)) continue;
            visited.add(current);
            BlockEntity blockEntity = this.level.getBlockEntity(current);
            if (!(blockEntity instanceof TrainStepBlockEntity)) continue;
            TrainStepBlockEntity trainStep = (TrainStepBlockEntity)blockEntity;
            collected.add(trainStep);
            visited.add(current);
            trainStep.addAttachedTrainSteps(frontier, visited);
        }
        return collected;
    }

    public void setSlideMode(SlideMode mode) {
        if (this.slideMode != null) {
            this.slideMode.setValue(mode.ordinal());
        }
    }

    public boolean addAttachedTrainSteps(Queue<BlockPos> frontier, Set<BlockPos> visited) {
        BlockState state = this.getBlockState();
        Direction.Axis axis = ((Direction)state.getValue((Property)TrainStepBlock.FACING)).getAxis();
        for (Direction direction : Iterate.directions) {
            BlockState neighbourState;
            BlockPos currentPos = this.worldPosition.relative(direction);
            if (visited.contains(currentPos) || !this.level.isLoaded(currentPos) || !AllBlocks.TRAIN_STEP_ANDESITE.has(neighbourState = this.level.getBlockState(currentPos)) && !AllBlocks.TRAIN_STEP_BRASS.has(neighbourState) && !AllBlocks.TRAIN_STEP_COPPER.has(neighbourState) && !AllBlocks.TRAIN_STEP_TRAIN.has(neighbourState) || !TrainStepBlock.sameKind(state, neighbourState)) continue;
            if (!visited.contains(currentPos)) {
                frontier.add(currentPos);
            }
            if (((Direction)neighbourState.getValue((Property)TrainStepBlock.FACING)).getAxis() != axis) continue;
            frontier.add(currentPos);
        }
        return true;
    }

    public boolean isVisible() {
        return (Boolean)this.getBlockState().getValue((Property)TrainStepBlock.VISIBLE);
    }

    public void tick() {
        boolean open;
        if (this.deferUpdate && !this.level.isClientSide()) {
            this.deferUpdate = false;
            BlockState blockState = this.getBlockState();
            blockState.handleNeighborChanged(this.level, this.worldPosition, Blocks.AIR, this.worldPosition, false);
        }
        super.tick();
        BlockState block = this.getBlockState();
        TrainStepBlock trainStepBlock = (TrainStepBlock)block.getBlock();
        boolean bl = open = this.openObj instanceof Boolean ? (Boolean)this.openObj : TrainStepBlockEntity.isOpen(this.getBlockState());
        if (open != TrainStepBlockEntity.isOpen(this.getBlockState())) {
            trainStepBlock.toggle(block, this.level, this.worldPosition, null, null, open);
        }
        boolean wasSettled = this.animation.settled();
        this.animation.chase(open ? 1.0 : 0.0, (double)0.15f, LerpedFloat.Chaser.LINEAR);
        this.animation.tickChaser();
        if (this.level.isClientSide()) {
            if (this.bridgeTicks < 2 && open) {
                ++this.bridgeTicks;
            } else if (this.bridgeTicks > 0 && !open && this.isVisible(this.getBlockState())) {
                --this.bridgeTicks;
            }
            return;
        }
        if (!open && !wasSettled && this.animation.settled() && !this.isVisible(this.getBlockState())) {
            this.showBlockModel();
        }
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().inflate(1.0);
    }

    protected boolean isVisible(BlockState state) {
        return state.getOptionalValue((Property)TrainStepBlock.VISIBLE).orElse(true);
    }

    public void setNeighborState(BlockState state) {
        if (this.level == null) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)TrainStepBlock.FACING);
        BlockPos leftPos = this.worldPosition.relative(facing.getCounterClockWise());
        BlockPos rightPos = this.worldPosition.relative(facing.getClockWise());
        BlockState leftState = this.level.getBlockState(leftPos);
        BlockState rightState = this.level.getBlockState(rightPos);
        this.neighborStates.put("left", leftState);
        this.neighborStates.put("right", rightState);
    }

    public Map<String, BlockState> getNeighborStates() {
        return this.neighborStates;
    }

    public void setTrainStepType(TrainStepType trainStepType) {
        this.trainStepType = trainStepType;
    }

    public TrainStepType getTrainStepType() {
        return this.trainStepType;
    }

    protected boolean shouldRenderSpecial(BlockState state) {
        return !this.isVisible(state) || this.bridgeTicks != 0;
    }

    protected void showBlockModel() {
        this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)TrainStepBlock.VISIBLE, (Comparable)Boolean.valueOf(true)), 3);
        this.level.playSound(null, this.worldPosition, SoundEvents.IRON_DOOR_CLOSE, SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    private List<BlockPos> getIncludedBlockPositionsLinear(Direction forcedMovement, boolean visualize) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        BlockState state = this.getBlockState();
        TrainStepBlock block = (TrainStepBlock)state.getBlock();
        Direction.Axis axis = ((Direction)state.getValue((Property)TrainStepBlock.FACING)).getAxis();
        Direction facing = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
        int chassisRange = visualize ? this.currentlySelectedRange : this.getRange();
        block0: for (int offset : new int[]{1, -1}) {
            BlockPos current;
            BlockState currentState;
            if (offset == -1) {
                facing = facing.getOpposite();
            }
            boolean sticky = true;
            for (int i = 1; i <= chassisRange && BlockMovementChecks.isMovementNecessary((BlockState)(currentState = this.level.getBlockState(current = this.worldPosition.relative(facing, i))), (Level)this.level, (BlockPos)current) && !BlockMovementChecks.isBrittle((BlockState)currentState); ++i) {
                positions.add(current);
                if (BlockMovementChecks.isNotSupportive((BlockState)currentState, (Direction)facing)) continue block0;
            }
        }
        return positions;
    }

    public static boolean isOpen(BlockState state) {
        return state.getOptionalValue((Property)TrainStepBlock.OPEN).orElse(false);
    }

    public class TrainStepOptionBehaviour<E extends Enum<E>>
    extends BulkScrollOptionBehaviour<E> {
        Function<SmartBlockEntity, List<? extends SmartBlockEntity>> groupGetter;
        private E[] options;

        public TrainStepOptionBehaviour(Class<E> enum_, Component label, SmartBlockEntity be, ValueBoxTransform slot, Function<SmartBlockEntity, List<? extends SmartBlockEntity>> groupGetter) {
            super(enum_, label, be, slot, groupGetter);
            this.groupGetter = groupGetter;
        }

        @Override
        public void setValueSettings(Player player, ValueSettingsBehaviour.ValueSettings valueSetting, boolean ctrlDown) {
            if (!ctrlDown) {
                super.setValueSettings(player, valueSetting, ctrlDown);
                return;
            }
            if (!valueSetting.equals((Object)this.getValueSettings())) {
                this.playFeedbackSound((BlockEntityBehaviour)this);
            }
            for (SmartBlockEntity be : this.getBulk()) {
                if (!(be instanceof TrainStepBlockEntity)) continue;
                TrainStepBlockEntity cbe = (TrainStepBlockEntity)be;
                if (cbe.slideMode == null) continue;
                cbe.slideMode.setValue(valueSetting.value());
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public void newSettingHovered(ValueSettingsBehaviour.ValueSettings valueSetting) {
            if (!((TrainStepBlockEntity)TrainStepBlockEntity.this).level.isClientSide) {
                return;
            }
            if (!AllKeys.ctrlDown()) {
                TrainStepBlockEntity.this.currentlySelectedRange = valueSetting.value() + 1;
            } else {
                for (SmartBlockEntity be : this.getBulk()) {
                    if (!(be instanceof TrainStepBlockEntity)) continue;
                    TrainStepBlockEntity cbe = (TrainStepBlockEntity)be;
                    cbe.currentlySelectedRange = valueSetting.value() + 1;
                }
            }
            TrainStepRangeDisplay.display(TrainStepBlockEntity.this);
        }

        @Override
        public List<? extends SmartBlockEntity> getBulk() {
            return this.groupGetter.apply(this.blockEntity);
        }
    }

    public static enum SlideMode implements INamedIconOptions,
    StringRepresentable
    {
        SLIDE(AllIcons.I_OPEN_SLIDE),
        NO_SLIDE(AllIcons.I_CLOSE_SLIDE);

        private final String translationKey;
        private final AllIcons icon;

        private SlideMode(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "step.mode." + Lang.asId((String)this.name());
        }

        public AllIcons getIcon() {
            return this.icon;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public String getSerializedName() {
            return this.name().toLowerCase();
        }
    }
}

