/*
 * Decompiled with CFR 0.152.
 */
package com.tiestoettoet.create_train_parts.content.foundation.mixin;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.api.contraption.ContraptionType;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.simibubi.create.content.decoration.slidingDoor.SlidingDoorBlock;
import com.simibubi.create.content.kinetics.steamEngine.PoweredShaftBlockEntity;
import com.simibubi.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.simibubi.create.content.redstone.contact.RedstoneContactBlock;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.tiestoettoet.create_train_parts.content.decoration.slidingWindow.SlidingWindowBlock;
import com.tiestoettoet.create_train_parts.content.decoration.trainSlide.TrainSlideBlock;
import com.tiestoettoet.create_train_parts.content.decoration.trainStep.TrainStepBlock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={Contraption.class})
public abstract class ContraptionMixin {
    @Shadow
    public abstract ContraptionType getType();

    @Shadow
    @Nullable
    protected CompoundTag getBlockEntityNBT(Level world, BlockPos pos) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity == null) {
            return null;
        }
        CompoundTag nbt = blockEntity.saveWithFullMetadata((HolderLookup.Provider)world.registryAccess());
        nbt.remove("x");
        nbt.remove("y");
        nbt.remove("z");
        return nbt;
    }

    @Overwrite
    protected Pair<StructureTemplate.StructureBlockInfo, BlockEntity> capture(Level world, BlockPos pos) {
        BlockState blockstate = world.getBlockState(pos);
        if (AllBlocks.REDSTONE_CONTACT.has(blockstate)) {
            blockstate = (BlockState)blockstate.setValue((Property)RedstoneContactBlock.POWERED, (Comparable)Boolean.valueOf(true));
        }
        if (AllBlocks.POWERED_SHAFT.has(blockstate)) {
            blockstate = BlockHelper.copyProperties((BlockState)blockstate, (BlockState)AllBlocks.SHAFT.getDefaultState());
        }
        if (blockstate.getBlock() instanceof ControlsBlock && AllTags.AllContraptionTypeTags.OPENS_CONTROLS.matches(this.getType())) {
            blockstate = (BlockState)blockstate.setValue((Property)ControlsBlock.OPEN, (Comparable)Boolean.valueOf(true));
        }
        if (blockstate.hasProperty((Property)SlidingDoorBlock.VISIBLE)) {
            blockstate = (BlockState)blockstate.setValue((Property)SlidingDoorBlock.VISIBLE, (Comparable)Boolean.valueOf(false));
        }
        if (blockstate.getBlock() instanceof ButtonBlock) {
            blockstate = (BlockState)blockstate.setValue((Property)ButtonBlock.POWERED, (Comparable)Boolean.valueOf(false));
            world.scheduleTick(pos, blockstate.getBlock(), -1);
        }
        if (blockstate.getBlock() instanceof PressurePlateBlock) {
            blockstate = (BlockState)blockstate.setValue((Property)PressurePlateBlock.POWERED, (Comparable)Boolean.valueOf(false));
            world.scheduleTick(pos, blockstate.getBlock(), -1);
        }
        if (blockstate.hasProperty((Property)TrainStepBlock.VISIBLE)) {
            blockstate = (BlockState)blockstate.setValue((Property)TrainStepBlock.VISIBLE, (Comparable)Boolean.valueOf(false));
        }
        if (blockstate.hasProperty((Property)TrainSlideBlock.VISIBLE)) {
            blockstate = (BlockState)blockstate.setValue((Property)TrainSlideBlock.VISIBLE, (Comparable)Boolean.valueOf(false));
        }
        if (blockstate.hasProperty((Property)SlidingWindowBlock.VISIBLE)) {
            blockstate = (BlockState)blockstate.setValue((Property)SlidingWindowBlock.VISIBLE, (Comparable)Boolean.valueOf(false));
        }
        CompoundTag compoundnbt = this.getBlockEntityNBT(world, pos);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof PoweredShaftBlockEntity) {
            blockEntity = AllBlockEntityTypes.BRACKETED_KINETIC.create(pos, blockstate);
        }
        if (blockEntity instanceof FactoryPanelBlockEntity) {
            FactoryPanelBlockEntity fpbe = (FactoryPanelBlockEntity)blockEntity;
            fpbe.writeSafe(compoundnbt, (HolderLookup.Provider)world.registryAccess());
        }
        return Pair.of((Object)new StructureTemplate.StructureBlockInfo(pos, blockstate, compoundnbt), (Object)blockEntity);
    }
}

