/*
 * Decompiled with CFR 0.152.
 */
package com.tiestoettoet.create_train_parts.content.trains.crossing;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.gantry.GantryShaftBlock;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.IHaveBigOutline;
import com.tiestoettoet.create_train_parts.AllBlockEntityTypes;
import com.tiestoettoet.create_train_parts.AllBlocks;
import com.tiestoettoet.create_train_parts.content.trains.crossing.ArmExtenderBlock;
import com.tiestoettoet.create_train_parts.content.trains.crossing.CrossingBlockEntity;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CrossingBlock
extends HorizontalKineticBlock
implements IBE<CrossingBlockEntity>,
IWrenchable,
IHaveBigOutline {
    public static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new GantryShaftBlock.PlacementHelper());
    public static final BooleanProperty FLIPPED = BooleanProperty.create((String)"flipped");
    public static final BooleanProperty OPEN = BooleanProperty.create((String)"open");
    protected static final VoxelShape NORTH_OPEN = Stream.of(Stream.of(Block.box((double)4.0, (double)0.0, (double)11.0, (double)12.0, (double)1.0, (double)12.0), Block.box((double)4.0, (double)0.0, (double)5.0, (double)5.0, (double)1.0, (double)11.0), Block.box((double)11.0, (double)0.0, (double)5.0, (double)12.0, (double)1.0, (double)11.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)5.0), Block.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0), Block.box((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)23.0, (double)11.0), Block.box((double)4.0, (double)12.0, (double)7.0, (double)5.0, (double)16.0, (double)9.0), Block.box((double)0.0, (double)17.0, (double)7.0, (double)4.0, (double)21.0, (double)9.0), Block.box((double)0.0, (double)12.0, (double)7.0, (double)4.0, (double)16.0, (double)9.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)4.0, (double)17.0, (double)7.0, (double)5.0, (double)21.0, (double)9.0), Shapes.join((VoxelShape)Block.box((double)6.0, (double)0.0, (double)11.0, (double)10.0, (double)16.0, (double)13.0), (VoxelShape)Block.box((double)2.0, (double)0.0, (double)11.0, (double)6.0, (double)4.0, (double)13.0), (BooleanOp)BooleanOp.OR)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    protected static final VoxelShape NORTH_OPEN_FLIPPED = Stream.of(Stream.of(Block.box((double)4.0, (double)0.0, (double)11.0, (double)12.0, (double)1.0, (double)12.0), Block.box((double)4.0, (double)0.0, (double)5.0, (double)5.0, (double)1.0, (double)11.0), Block.box((double)11.0, (double)0.0, (double)5.0, (double)12.0, (double)1.0, (double)11.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)5.0), Block.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0), Block.box((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)23.0, (double)11.0), Block.box((double)4.0, (double)12.0, (double)7.0, (double)5.0, (double)16.0, (double)9.0), Block.box((double)0.0, (double)17.0, (double)7.0, (double)4.0, (double)21.0, (double)9.0), Block.box((double)0.0, (double)12.0, (double)7.0, (double)4.0, (double)16.0, (double)9.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)4.0, (double)17.0, (double)7.0, (double)5.0, (double)21.0, (double)9.0), Shapes.join((VoxelShape)Block.box((double)6.0, (double)0.0, (double)3.0, (double)10.0, (double)16.0, (double)5.0), (VoxelShape)Block.box((double)2.0, (double)0.0, (double)3.0, (double)6.0, (double)4.0, (double)5.0), (BooleanOp)BooleanOp.OR)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    protected static final VoxelShape NORTH_CLOSED = Stream.of(Stream.of(Block.box((double)4.0, (double)0.0, (double)11.0, (double)12.0, (double)1.0, (double)12.0), Block.box((double)4.0, (double)0.0, (double)5.0, (double)5.0, (double)1.0, (double)11.0), Block.box((double)11.0, (double)0.0, (double)5.0, (double)12.0, (double)1.0, (double)11.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)5.0), Block.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0), Block.box((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)23.0, (double)11.0), Block.box((double)4.0, (double)12.0, (double)7.0, (double)5.0, (double)16.0, (double)9.0), Block.box((double)0.0, (double)17.0, (double)7.0, (double)4.0, (double)21.0, (double)9.0), Block.box((double)0.0, (double)12.0, (double)7.0, (double)4.0, (double)16.0, (double)9.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)4.0, (double)17.0, (double)7.0, (double)5.0, (double)21.0, (double)9.0), Shapes.join((VoxelShape)Block.box((double)0.0, (double)6.0, (double)11.0, (double)16.0, (double)10.0, (double)13.0), (VoxelShape)Block.box((double)0.0, (double)10.0, (double)11.0, (double)4.0, (double)14.0, (double)13.0), (BooleanOp)BooleanOp.OR)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    protected static final VoxelShape NORTH_CLOSED_FLIPPED = Stream.of(Stream.of(Block.box((double)4.0, (double)0.0, (double)11.0, (double)12.0, (double)1.0, (double)12.0), Block.box((double)4.0, (double)0.0, (double)5.0, (double)5.0, (double)1.0, (double)11.0), Block.box((double)11.0, (double)0.0, (double)5.0, (double)12.0, (double)1.0, (double)11.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)5.0), Block.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0), Block.box((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)23.0, (double)11.0), Block.box((double)4.0, (double)12.0, (double)7.0, (double)5.0, (double)16.0, (double)9.0), Block.box((double)0.0, (double)17.0, (double)7.0, (double)4.0, (double)21.0, (double)9.0), Block.box((double)0.0, (double)12.0, (double)7.0, (double)4.0, (double)16.0, (double)9.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)4.0, (double)17.0, (double)7.0, (double)5.0, (double)21.0, (double)9.0), Shapes.join((VoxelShape)Block.box((double)0.0, (double)6.0, (double)3.0, (double)16.0, (double)10.0, (double)5.0), (VoxelShape)Block.box((double)0.0, (double)10.0, (double)3.0, (double)4.0, (double)14.0, (double)5.0), (BooleanOp)BooleanOp.OR)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    protected static final VoxelShape SOUTH_OPEN;
    protected static final VoxelShape SOUTH_OPEN_FLIPPED;
    protected static final VoxelShape SOUTH_CLOSED;
    protected static final VoxelShape SOUTH_CLOSED_FLIPPED;
    protected static final VoxelShape WEST_OPEN;
    protected static final VoxelShape WEST_OPEN_FLIPPED;
    protected static final VoxelShape WEST_CLOSED;
    protected static final VoxelShape WEST_CLOSED_FLIPPED;
    protected static final VoxelShape EAST_OPEN;
    protected static final VoxelShape EAST_OPEN_FLIPPED;
    protected static final VoxelShape EAST_CLOSED;
    protected static final VoxelShape EAST_CLOSED_FLIPPED;

    public CrossingBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FLIPPED, (Comparable)Boolean.valueOf(false))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        Boolean flipped = (Boolean)state.getValue((Property)FLIPPED);
        Boolean open = (Boolean)state.getValue((Property)OPEN);
        Direction direction = (Direction)state.getValue(HORIZONTAL_FACING);
        switch (direction) {
            case NORTH: {
                if (open.booleanValue()) {
                    return flipped != false ? NORTH_OPEN_FLIPPED : NORTH_OPEN;
                }
                return flipped != false ? NORTH_CLOSED_FLIPPED : NORTH_CLOSED;
            }
            case SOUTH: {
                if (open.booleanValue()) {
                    return flipped != false ? SOUTH_OPEN_FLIPPED : SOUTH_OPEN;
                }
                return flipped != false ? SOUTH_CLOSED_FLIPPED : SOUTH_CLOSED;
            }
            case WEST: {
                if (open.booleanValue()) {
                    return flipped != false ? WEST_OPEN_FLIPPED : WEST_OPEN;
                }
                return flipped != false ? WEST_CLOSED_FLIPPED : WEST_CLOSED;
            }
            case EAST: {
                if (open.booleanValue()) {
                    return flipped != false ? EAST_OPEN_FLIPPED : EAST_OPEN;
                }
                return flipped != false ? EAST_CLOSED_FLIPPED : EAST_CLOSED;
            }
        }
        return Shapes.block();
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{FLIPPED}).add(new Property[]{OPEN}));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        Direction facing = context.getHorizontalDirection();
        boolean flipped = false;
        return (BlockState)((BlockState)((BlockState)state.setValue(HORIZONTAL_FACING, (Comparable)facing)).setValue((Property)FLIPPED, (Comparable)Boolean.valueOf(flipped))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false));
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == Direction.DOWN;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
            return InteractionResult.PASS;
        }
        BlockState rotated = context.getClickedFace().getAxis() == Direction.Axis.Y ? this.getRotatedBlockState(state, context.getClickedFace()) : (context.getClickedFace().getAxis() == ((Direction)state.getValue(HORIZONTAL_FACING)).getAxis() ? (BlockState)state.cycle((Property)FLIPPED) : (BlockState)state.setValue(HORIZONTAL_FACING, (Comparable)context.getClickedFace()));
        if (!rotated.canSurvive((LevelReader)world, pos)) {
            return InteractionResult.PASS;
        }
        this.updateConnectedArmExtenders(world, pos, state, rotated);
        KineticBlockEntity.switchToBlockState((Level)world, (BlockPos)pos, (BlockState)this.updateAfterWrenched(rotated, context));
        return InteractionResult.SUCCESS;
    }

    private void updateConnectedArmExtenders(Level world, BlockPos crossingPos, BlockState oldState, BlockState newState) {
        boolean onlyFlipped;
        Direction oldFacing = (Direction)oldState.getValue(HORIZONTAL_FACING);
        boolean oldFlipped = (Boolean)oldState.getValue((Property)FLIPPED);
        Direction newFacing = (Direction)newState.getValue(HORIZONTAL_FACING);
        boolean newFlipped = (Boolean)newState.getValue((Property)FLIPPED);
        boolean bl = onlyFlipped = oldFacing == newFacing && oldFlipped != newFlipped;
        if (onlyFlipped) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos armPos = crossingPos.relative(direction);
                while (world.getBlockState(armPos).getBlock() instanceof ArmExtenderBlock) {
                    BlockState currentArmState = world.getBlockState(armPos);
                    BlockState newArmState = (BlockState)currentArmState.setValue((Property)ArmExtenderBlock.FLIPPED, (Comparable)Boolean.valueOf(newFlipped));
                    world.setBlock(armPos, newArmState, 3);
                    armPos = armPos.relative(direction);
                }
            }
        } else {
            Direction newArmDirection = newFacing.getClockWise();
            ArrayList<BlockPos> allArmPositions = new ArrayList<BlockPos>();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos armPos = crossingPos.relative(direction);
                while (world.getBlockState(armPos).getBlock() instanceof ArmExtenderBlock) {
                    allArmPositions.add(armPos);
                    armPos = armPos.relative(direction);
                }
            }
            for (BlockPos pos : allArmPositions) {
                world.removeBlock(pos, false);
            }
            for (int i = 0; i < allArmPositions.size(); ++i) {
                BlockPos newPos = crossingPos.relative(newArmDirection, i + 1);
                BlockState existingState = world.getBlockState(newPos);
                if (!existingState.isAir() && !AllBlocks.ARM_EXTENDER.has(existingState)) {
                    world.destroyBlock(newPos, true);
                }
                BlockState newArmState = (BlockState)((BlockState)((BlockState)AllBlocks.ARM_EXTENDER.getDefaultState().setValue(HORIZONTAL_FACING, (Comparable)newFacing)).setValue((Property)ArmExtenderBlock.FLIPPED, (Comparable)Boolean.valueOf(newFlipped))).setValue((Property)ArmExtenderBlock.OPEN, (Comparable)Boolean.valueOf(true));
                world.setBlock(newPos, newArmState, 3);
            }
        }
    }

    public static boolean isCrossing(BlockState state) {
        return AllBlocks.CROSSING.has(state);
    }

    public BlockState playerWillDestroy(Level worldIn, BlockPos pos, BlockState state, Player player) {
        boolean dropBlocks = player == null || !player.isCreative();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos armPos = pos.relative(direction);
            while (worldIn.getBlockState(armPos).getBlock() instanceof ArmExtenderBlock) {
                worldIn.destroyBlock(armPos, dropBlocks);
                armPos = armPos.relative(direction);
            }
        }
        return super.playerWillDestroy(worldIn, pos, state, player);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            ArrayList<ItemStack> armExtenderItems = new ArrayList<ItemStack>();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos armPos = pos.relative(direction);
                while (world.getBlockState(armPos).getBlock() instanceof ArmExtenderBlock) {
                    armExtenderItems.add(new ItemStack((ItemLike)AllBlocks.ARM_EXTENDER.get()));
                    world.removeBlock(armPos, false);
                    armPos = armPos.relative(direction);
                }
            }
            if (!armExtenderItems.isEmpty() && !world.isClientSide) {
                Player nearestPlayer = world.getNearestPlayer((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 10.0, false);
                if (nearestPlayer != null) {
                    for (ItemStack item : armExtenderItems) {
                        if (nearestPlayer.addItem(item)) continue;
                        Block.popResource((Level)world, (BlockPos)pos, (ItemStack)item);
                    }
                } else {
                    for (ItemStack item : armExtenderItems) {
                        Block.popResource((Level)world, (BlockPos)pos, (ItemStack)item);
                    }
                }
            }
        }
        super.onRemove(state, world, pos, newState, isMoving);
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockState blockState;
        int i;
        super.onPlace(state, world, pos, oldState, isMoving);
        BlockPos currentPos = pos.below();
        for (i = 0; i < 16; ++i) {
            blockState = world.getBlockState(currentPos);
            if (AllBlocks.CROSSING.has(blockState)) {
                KineticBlockEntity.switchToBlockState((Level)world, (BlockPos)currentPos, (BlockState)Block.updateFromNeighbourShapes((BlockState)blockState, (LevelAccessor)world, (BlockPos)currentPos));
            }
            currentPos = currentPos.below();
        }
        currentPos = pos.above();
        for (i = 0; i < 16; ++i) {
            blockState = world.getBlockState(currentPos);
            if (AllBlocks.CROSSING.has(blockState)) {
                KineticBlockEntity.switchToBlockState((Level)world, (BlockPos)currentPos, (BlockState)Block.updateFromNeighbourShapes((BlockState)blockState, (LevelAccessor)world, (BlockPos)currentPos));
            }
            currentPos = currentPos.above();
        }
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getShape(state, level, pos, CollisionContext.empty());
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue(HORIZONTAL_FACING)).getAxis();
    }

    public Class<CrossingBlockEntity> getBlockEntityClass() {
        return CrossingBlockEntity.class;
    }

    public BlockEntityType<? extends CrossingBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.CROSSING.get();
    }

    public static boolean isArmExtender(BlockState state) {
        return AllBlocks.ARM_EXTENDER.has(state);
    }

    static {
        EAST_OPEN = Stream.of(Stream.of(Block.box((double)4.0, (double)0.0, (double)4.0, (double)5.0, (double)1.0, (double)12.0), Block.box((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)1.0, (double)5.0), Block.box((double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)1.0, (double)12.0), Block.box((double)11.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), Block.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0), Block.box((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)23.0, (double)11.0), Block.box((double)7.0, (double)12.0, (double)4.0, (double)9.0, (double)16.0, (double)5.0), Block.box((double)7.0, (double)17.0, (double)0.0, (double)9.0, (double)21.0, (double)4.0), Block.box((double)7.0, (double)12.0, (double)0.0, (double)9.0, (double)16.0, (double)4.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)7.0, (double)17.0, (double)4.0, (double)9.0, (double)21.0, (double)5.0), Shapes.join((VoxelShape)Block.box((double)3.0, (double)0.0, (double)6.0, (double)5.0, (double)16.0, (double)10.0), (VoxelShape)Block.box((double)3.0, (double)0.0, (double)2.0, (double)5.0, (double)4.0, (double)6.0), (BooleanOp)BooleanOp.OR)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        EAST_OPEN_FLIPPED = Stream.of(Stream.of(Block.box((double)4.0, (double)0.0, (double)4.0, (double)5.0, (double)1.0, (double)12.0), Block.box((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)1.0, (double)5.0), Block.box((double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)1.0, (double)12.0), Block.box((double)11.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), Block.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0), Block.box((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)23.0, (double)11.0), Block.box((double)7.0, (double)12.0, (double)4.0, (double)9.0, (double)16.0, (double)5.0), Block.box((double)7.0, (double)17.0, (double)0.0, (double)9.0, (double)21.0, (double)4.0), Block.box((double)7.0, (double)12.0, (double)0.0, (double)9.0, (double)16.0, (double)4.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)7.0, (double)17.0, (double)4.0, (double)9.0, (double)21.0, (double)5.0), Shapes.join((VoxelShape)Block.box((double)11.0, (double)0.0, (double)6.0, (double)13.0, (double)16.0, (double)10.0), (VoxelShape)Block.box((double)11.0, (double)0.0, (double)2.0, (double)13.0, (double)4.0, (double)6.0), (BooleanOp)BooleanOp.OR)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        EAST_CLOSED = Stream.of(Stream.of(Block.box((double)4.0, (double)0.0, (double)4.0, (double)5.0, (double)1.0, (double)12.0), Block.box((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)1.0, (double)5.0), Block.box((double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)1.0, (double)12.0), Block.box((double)11.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), Block.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0), Block.box((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)23.0, (double)11.0), Block.box((double)7.0, (double)12.0, (double)4.0, (double)9.0, (double)16.0, (double)5.0), Block.box((double)7.0, (double)17.0, (double)0.0, (double)9.0, (double)21.0, (double)4.0), Block.box((double)7.0, (double)12.0, (double)0.0, (double)9.0, (double)16.0, (double)4.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)7.0, (double)17.0, (double)4.0, (double)9.0, (double)21.0, (double)5.0), Shapes.join((VoxelShape)Block.box((double)3.0, (double)6.0, (double)0.0, (double)5.0, (double)10.0, (double)16.0), (VoxelShape)Block.box((double)3.0, (double)10.0, (double)0.0, (double)5.0, (double)14.0, (double)4.0), (BooleanOp)BooleanOp.OR)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        EAST_CLOSED_FLIPPED = Stream.of(Stream.of(Block.box((double)4.0, (double)0.0, (double)4.0, (double)5.0, (double)1.0, (double)12.0), Block.box((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)1.0, (double)5.0), Block.box((double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)1.0, (double)12.0), Block.box((double)11.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), Block.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0), Block.box((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)23.0, (double)11.0), Block.box((double)7.0, (double)12.0, (double)4.0, (double)9.0, (double)16.0, (double)5.0), Block.box((double)7.0, (double)17.0, (double)0.0, (double)9.0, (double)21.0, (double)4.0), Block.box((double)7.0, (double)12.0, (double)0.0, (double)9.0, (double)16.0, (double)4.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)7.0, (double)17.0, (double)4.0, (double)9.0, (double)21.0, (double)5.0), Shapes.join((VoxelShape)Block.box((double)11.0, (double)6.0, (double)0.0, (double)13.0, (double)10.0, (double)16.0), (VoxelShape)Block.box((double)11.0, (double)10.0, (double)0.0, (double)13.0, (double)14.0, (double)4.0), (BooleanOp)BooleanOp.OR)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        SOUTH_OPEN = Stream.of(Stream.of(Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)5.0), Block.box((double)11.0, (double)0.0, (double)5.0, (double)12.0, (double)1.0, (double)11.0), Block.box((double)4.0, (double)0.0, (double)5.0, (double)5.0, (double)1.0, (double)11.0), Block.box((double)4.0, (double)0.0, (double)11.0, (double)12.0, (double)1.0, (double)12.0), Block.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0), Block.box((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)23.0, (double)11.0), Block.box((double)11.0, (double)12.0, (double)7.0, (double)12.0, (double)16.0, (double)9.0), Block.box((double)12.0, (double)17.0, (double)7.0, (double)16.0, (double)21.0, (double)9.0), Block.box((double)12.0, (double)12.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)11.0, (double)17.0, (double)7.0, (double)12.0, (double)21.0, (double)9.0), Shapes.join((VoxelShape)Block.box((double)6.0, (double)0.0, (double)3.0, (double)10.0, (double)16.0, (double)5.0), (VoxelShape)Block.box((double)10.0, (double)0.0, (double)3.0, (double)14.0, (double)4.0, (double)5.0), (BooleanOp)BooleanOp.OR)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        SOUTH_OPEN_FLIPPED = Stream.of(Stream.of(Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)5.0), Block.box((double)11.0, (double)0.0, (double)5.0, (double)12.0, (double)1.0, (double)11.0), Block.box((double)4.0, (double)0.0, (double)5.0, (double)5.0, (double)1.0, (double)11.0), Block.box((double)4.0, (double)0.0, (double)11.0, (double)12.0, (double)1.0, (double)12.0), Block.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0), Block.box((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)23.0, (double)11.0), Block.box((double)11.0, (double)12.0, (double)7.0, (double)12.0, (double)16.0, (double)9.0), Block.box((double)12.0, (double)17.0, (double)7.0, (double)16.0, (double)21.0, (double)9.0), Block.box((double)12.0, (double)12.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)11.0, (double)17.0, (double)7.0, (double)12.0, (double)21.0, (double)9.0), Shapes.join((VoxelShape)Block.box((double)6.0, (double)0.0, (double)11.0, (double)10.0, (double)16.0, (double)13.0), (VoxelShape)Block.box((double)10.0, (double)0.0, (double)11.0, (double)14.0, (double)4.0, (double)13.0), (BooleanOp)BooleanOp.OR)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        SOUTH_CLOSED = Stream.of(Stream.of(Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)5.0), Block.box((double)11.0, (double)0.0, (double)5.0, (double)12.0, (double)1.0, (double)11.0), Block.box((double)4.0, (double)0.0, (double)5.0, (double)5.0, (double)1.0, (double)11.0), Block.box((double)4.0, (double)0.0, (double)11.0, (double)12.0, (double)1.0, (double)12.0), Block.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0), Block.box((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)23.0, (double)11.0), Block.box((double)11.0, (double)12.0, (double)7.0, (double)12.0, (double)16.0, (double)9.0), Block.box((double)12.0, (double)17.0, (double)7.0, (double)16.0, (double)21.0, (double)9.0), Block.box((double)12.0, (double)12.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)11.0, (double)17.0, (double)7.0, (double)12.0, (double)21.0, (double)9.0), Shapes.join((VoxelShape)Block.box((double)0.0, (double)6.0, (double)3.0, (double)16.0, (double)10.0, (double)5.0), (VoxelShape)Block.box((double)12.0, (double)10.0, (double)3.0, (double)16.0, (double)14.0, (double)5.0), (BooleanOp)BooleanOp.OR)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        SOUTH_CLOSED_FLIPPED = Stream.of(Stream.of(Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)5.0), Block.box((double)11.0, (double)0.0, (double)5.0, (double)12.0, (double)1.0, (double)11.0), Block.box((double)4.0, (double)0.0, (double)5.0, (double)5.0, (double)1.0, (double)11.0), Block.box((double)4.0, (double)0.0, (double)11.0, (double)12.0, (double)1.0, (double)12.0), Block.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0), Block.box((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)23.0, (double)11.0), Block.box((double)11.0, (double)12.0, (double)7.0, (double)12.0, (double)16.0, (double)9.0), Block.box((double)12.0, (double)17.0, (double)7.0, (double)16.0, (double)21.0, (double)9.0), Block.box((double)12.0, (double)12.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)11.0, (double)17.0, (double)7.0, (double)12.0, (double)21.0, (double)9.0), Shapes.join((VoxelShape)Block.box((double)0.0, (double)6.0, (double)11.0, (double)16.0, (double)10.0, (double)13.0), (VoxelShape)Block.box((double)12.0, (double)10.0, (double)11.0, (double)16.0, (double)14.0, (double)13.0), (BooleanOp)BooleanOp.OR)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        WEST_OPEN = Stream.of(Stream.of(Block.box((double)11.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), Block.box((double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)1.0, (double)12.0), Block.box((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)1.0, (double)5.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)5.0, (double)1.0, (double)12.0), Block.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0), Block.box((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)23.0, (double)11.0), Block.box((double)7.0, (double)12.0, (double)11.0, (double)9.0, (double)16.0, (double)12.0), Block.box((double)7.0, (double)17.0, (double)12.0, (double)9.0, (double)21.0, (double)16.0), Block.box((double)7.0, (double)12.0, (double)12.0, (double)9.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)7.0, (double)17.0, (double)11.0, (double)9.0, (double)21.0, (double)12.0), Shapes.join((VoxelShape)Block.box((double)11.0, (double)0.0, (double)6.0, (double)13.0, (double)16.0, (double)10.0), (VoxelShape)Block.box((double)11.0, (double)0.0, (double)10.0, (double)13.0, (double)4.0, (double)14.0), (BooleanOp)BooleanOp.OR)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        WEST_OPEN_FLIPPED = Stream.of(Stream.of(Block.box((double)11.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), Block.box((double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)1.0, (double)12.0), Block.box((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)1.0, (double)5.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)5.0, (double)1.0, (double)12.0), Block.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0), Block.box((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)23.0, (double)11.0), Block.box((double)7.0, (double)12.0, (double)11.0, (double)9.0, (double)16.0, (double)12.0), Block.box((double)7.0, (double)17.0, (double)12.0, (double)9.0, (double)21.0, (double)16.0), Block.box((double)7.0, (double)12.0, (double)12.0, (double)9.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)7.0, (double)17.0, (double)11.0, (double)9.0, (double)21.0, (double)12.0), Shapes.join((VoxelShape)Block.box((double)3.0, (double)0.0, (double)6.0, (double)5.0, (double)16.0, (double)10.0), (VoxelShape)Block.box((double)3.0, (double)0.0, (double)10.0, (double)5.0, (double)4.0, (double)14.0), (BooleanOp)BooleanOp.OR)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        WEST_CLOSED = Stream.of(Stream.of(Block.box((double)11.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), Block.box((double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)1.0, (double)12.0), Block.box((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)1.0, (double)5.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)5.0, (double)1.0, (double)12.0), Block.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0), Block.box((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)23.0, (double)11.0), Block.box((double)7.0, (double)12.0, (double)11.0, (double)9.0, (double)16.0, (double)12.0), Block.box((double)7.0, (double)17.0, (double)12.0, (double)9.0, (double)21.0, (double)16.0), Block.box((double)7.0, (double)12.0, (double)12.0, (double)9.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)7.0, (double)17.0, (double)11.0, (double)9.0, (double)21.0, (double)12.0), Shapes.join((VoxelShape)Block.box((double)11.0, (double)6.0, (double)0.0, (double)13.0, (double)10.0, (double)16.0), (VoxelShape)Block.box((double)11.0, (double)10.0, (double)12.0, (double)13.0, (double)14.0, (double)16.0), (BooleanOp)BooleanOp.OR)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
        WEST_CLOSED_FLIPPED = Stream.of(Stream.of(Block.box((double)11.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), Block.box((double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)1.0, (double)12.0), Block.box((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)1.0, (double)5.0), Block.box((double)4.0, (double)0.0, (double)4.0, (double)5.0, (double)1.0, (double)12.0), Block.box((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)12.0, (double)11.0), Block.box((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)23.0, (double)11.0), Block.box((double)7.0, (double)12.0, (double)11.0, (double)9.0, (double)16.0, (double)12.0), Block.box((double)7.0, (double)17.0, (double)12.0, (double)9.0, (double)21.0, (double)16.0), Block.box((double)7.0, (double)12.0, (double)12.0, (double)9.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get(), Block.box((double)7.0, (double)17.0, (double)11.0, (double)9.0, (double)21.0, (double)12.0), Shapes.join((VoxelShape)Block.box((double)3.0, (double)6.0, (double)0.0, (double)5.0, (double)10.0, (double)16.0), (VoxelShape)Block.box((double)3.0, (double)10.0, (double)12.0, (double)5.0, (double)14.0, (double)16.0), (BooleanOp)BooleanOp.OR)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    }

    public static class PlacementHelper
    implements IPlacementHelper {
        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> AllBlocks.CROSSING.isIn(arg_0);
        }

        public Predicate<BlockState> getStatePredicate() {
            return arg_0 -> AllBlocks.CROSSING.has(arg_0);
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction offsetDirection = ray.getLocation().subtract((Vec3)Vec3.atCenterOf((Vec3i)pos)).y < 0.0 ? Direction.DOWN : Direction.UP;
            BlockPos newPos = pos.relative(offsetDirection);
            BlockState newState = world.getBlockState(newPos);
            if (!newState.canBeReplaced()) {
                newPos = pos.relative(offsetDirection.getOpposite());
                newState = world.getBlockState(newPos);
            }
            if (newState.canBeReplaced()) {
                Direction facing = ray.getDirection();
                if (facing.getAxis() == Direction.Axis.Y) {
                    return PlacementOffset.fail();
                }
                Vec3 look = player.getLookAngle();
                Vec3 cross = look.cross(new Vec3(facing.step()));
                boolean flipped = cross.y < 0.0;
                return PlacementOffset.success((Vec3i)newPos, x -> (BlockState)((BlockState)x.setValue((Property)FLIPPED, (Comparable)Boolean.valueOf(flipped))).setValue(HorizontalKineticBlock.HORIZONTAL_FACING, (Comparable)facing));
            }
            return PlacementOffset.fail();
        }
    }
}

