/*
 * Decompiled with CFR 0.152.
 */
package com.tiestoettoet.create_train_parts;

import com.tiestoettoet.create_train_parts.CreateTrainParts;
import com.tiestoettoet.create_train_parts.content.decoration.trainStep.TrainStepBlock;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.HashMap;
import java.util.Map;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class AllPartialModels {
    public static final Map<ResourceLocation, PartialModel> TRAIN_STEP = new HashMap<ResourceLocation, PartialModel>();
    public static final Map<ResourceLocation, PartialModel> TRAIN_STEP_SLIDE = new HashMap<ResourceLocation, PartialModel>();
    public static final Map<ResourceLocation, PartialModel> TRAIN_STEP_PIVOT = new HashMap<ResourceLocation, PartialModel>();
    public static final Map<ResourceLocation, PartialModel> TRAIN_STEP_MOVE = new HashMap<ResourceLocation, PartialModel>();
    public static final Map<ResourceLocation, PartialModel> TRAIN_STEP_FLAP = new HashMap<ResourceLocation, PartialModel>();
    public static final Map<ResourceLocation, PartialModel> TRAIN_SLIDE = new HashMap<ResourceLocation, PartialModel>();
    public static final Map<ResourceLocation, PartialModel> TRAIN_SLIDE_BOTTOM = new HashMap<ResourceLocation, PartialModel>();
    public static final Map<ResourceLocation, PartialModel> TRAIN_SLIDE_CENTRE = new HashMap<ResourceLocation, PartialModel>();
    public static final Map<ResourceLocation, PartialModel> TRAIN_SLIDE_TOP = new HashMap<ResourceLocation, PartialModel>();
    public static final Map<ResourceLocation, PartialModel> SLIDING_WINDOW = new HashMap<ResourceLocation, PartialModel>();
    public static final Map<ResourceLocation, PartialModel> SLIDING_WINDOW_UP = new HashMap<ResourceLocation, PartialModel>();
    public static final Map<ResourceLocation, PartialModel> SLIDING_WINDOW_RIGHT = new HashMap<ResourceLocation, PartialModel>();
    public static final Map<ResourceLocation, PartialModel> SLIDING_WINDOW_DOWN = new HashMap<ResourceLocation, PartialModel>();
    public static final Map<ResourceLocation, PartialModel> SLIDING_WINDOW_LEFT = new HashMap<ResourceLocation, PartialModel>();
    public static final Map<ResourceLocation, PartialModel> SLIDING_WINDOW_BACK = new HashMap<ResourceLocation, PartialModel>();
    public static final PartialModel ARM = AllPartialModels.block("crossing/arm");
    public static final PartialModel ARM_FLIPPED = AllPartialModels.block("crossing/arm_flipped");
    public static final PartialModel ARM_EXTENDER = AllPartialModels.block("crossing/arm_extender");
    public static final PartialModel ARM_EXTENDER_FLIPPED = AllPartialModels.block("crossing/arm_extender_flipped");
    public static final PartialModel CROSSING_LAMP = AllPartialModels.block("crossing/lamp");
    public static final PartialModel LIGHTS = AllPartialModels.block("crossing/lights");
    public static final PartialModel LIGHTS_FLIPPED = AllPartialModels.block("crossing/lights_flipped");

    private static void putTrainStep(String path) {
        for (Direction facing : Iterate.directions) {
            if (facing == Direction.UP || facing == Direction.DOWN) continue;
            for (Direction face : Iterate.directions) {
                for (TrainStepBlock.ConnectedState state : TrainStepBlock.ConnectedState.values()) {
                    TRAIN_STEP.put(CreateTrainParts.asResource(path + "/" + facing.getSerializedName() + "_" + state.getSerializedName() + "_" + face.getSerializedName()), AllPartialModels.block(path + "/steps_" + facing.getSerializedName() + "_" + state.getSerializedName() + "_" + face.getSerializedName()));
                    TRAIN_STEP_SLIDE.put(CreateTrainParts.asResource(path + "/" + facing.getSerializedName() + "_" + state.getSerializedName() + "_" + face.getSerializedName()), AllPartialModels.block(path + "/slide_" + facing.getSerializedName() + "_" + state.getSerializedName() + "_" + face.getSerializedName()));
                    TRAIN_STEP_PIVOT.put(CreateTrainParts.asResource(path + "/" + facing.getSerializedName() + "_" + state.getSerializedName() + "_" + face.getSerializedName()), AllPartialModels.block(path + "/pivot_" + facing.getSerializedName() + "_" + state.getSerializedName() + "_" + face.getSerializedName()));
                    TRAIN_STEP_MOVE.put(CreateTrainParts.asResource(path + "/" + facing.getSerializedName() + "_" + state.getSerializedName() + "_" + face.getSerializedName()), AllPartialModels.block(path + "/move_" + facing.getSerializedName() + "_" + state.getSerializedName() + "_" + face.getSerializedName()));
                    TRAIN_STEP_FLAP.put(CreateTrainParts.asResource(path + "/" + facing.getSerializedName() + "_" + state.getSerializedName() + "_" + face.getSerializedName()), AllPartialModels.block(path + "/flap_" + facing.getSerializedName() + "_" + state.getSerializedName() + "_" + face.getSerializedName()));
                }
            }
        }
    }

    private static void putTrainSlide(String path) {
        for (Direction facing : Iterate.directions) {
            if (facing == Direction.UP || facing == Direction.DOWN) continue;
            for (Direction face : Iterate.directions) {
                for (TrainStepBlock.ConnectedState state : TrainStepBlock.ConnectedState.values()) {
                    TRAIN_SLIDE.put(CreateTrainParts.asResource(path + "/" + facing.getSerializedName() + "_" + state.getSerializedName() + "_" + face.getSerializedName()), AllPartialModels.block(path + "/slide_" + facing.getSerializedName() + "_" + state.getSerializedName() + "_" + face.getSerializedName()));
                    TRAIN_SLIDE_TOP.put(CreateTrainParts.asResource(path + "/" + facing.getSerializedName() + "_" + state.getSerializedName() + "_" + face.getSerializedName()), AllPartialModels.block(path + "/top_" + facing.getSerializedName() + "_" + state.getSerializedName() + "_" + face.getSerializedName()));
                    TRAIN_SLIDE_CENTRE.put(CreateTrainParts.asResource(path + "/" + facing.getSerializedName() + "_" + state.getSerializedName() + "_" + face.getSerializedName()), AllPartialModels.block(path + "/centre_" + facing.getSerializedName() + "_" + state.getSerializedName() + "_" + face.getSerializedName()));
                    TRAIN_SLIDE_BOTTOM.put(CreateTrainParts.asResource(path + "/" + facing.getSerializedName() + "_" + state.getSerializedName() + "_" + face.getSerializedName()), AllPartialModels.block(path + "/bottom_" + facing.getSerializedName() + "_" + state.getSerializedName() + "_" + face.getSerializedName()));
                }
            }
        }
    }

    private static void putSlidingWindow(String type) {
        SLIDING_WINDOW.put(CreateTrainParts.asResource("sliding_windows/" + type + "_main"), AllPartialModels.block("sliding_windows/" + type + "_main"));
        SLIDING_WINDOW_UP.put(CreateTrainParts.asResource("sliding_windows/" + type + "_up"), AllPartialModels.block("sliding_windows/" + type + "_up"));
        SLIDING_WINDOW_RIGHT.put(CreateTrainParts.asResource("sliding_windows/" + type + "_right"), AllPartialModels.block("sliding_windows/" + type + "_right"));
        SLIDING_WINDOW_DOWN.put(CreateTrainParts.asResource("sliding_windows/" + type + "_down"), AllPartialModels.block("sliding_windows/" + type + "_down"));
        SLIDING_WINDOW_LEFT.put(CreateTrainParts.asResource("sliding_windows/" + type + "_left"), AllPartialModels.block("sliding_windows/" + type + "_left"));
        SLIDING_WINDOW_BACK.put(CreateTrainParts.asResource("sliding_windows/" + type + "_back"), AllPartialModels.block("sliding_windows/" + type + "_back"));
    }

    private static PartialModel block(String path) {
        return PartialModel.of((ResourceLocation)CreateTrainParts.asResource("block/" + path));
    }

    public static void init() {
    }

    static {
        AllPartialModels.putTrainStep("train_step_andesite");
        AllPartialModels.putTrainStep("train_step_brass");
        AllPartialModels.putTrainStep("train_step_copper");
        AllPartialModels.putTrainStep("train_step_train");
        AllPartialModels.putTrainSlide("train_slide_andesite");
        AllPartialModels.putTrainSlide("train_slide_brass");
        AllPartialModels.putTrainSlide("train_slide_copper");
        AllPartialModels.putTrainSlide("train_slide_train");
        AllPartialModels.putSlidingWindow("glass");
        AllPartialModels.putSlidingWindow("andesite");
        AllPartialModels.putSlidingWindow("brass");
        AllPartialModels.putSlidingWindow("copper");
        AllPartialModels.putSlidingWindow("train");
    }
}

