/*
 * Decompiled with CFR 0.152.
 */
package com.tiestoettoet.create_train_parts.content.contraptions.behaviour;

import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.SimpleBlockMovingInteraction;
import com.tiestoettoet.create_train_parts.content.decoration.trainSlide.TrainSlideBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class SlideMovingInteraction
extends SimpleBlockMovingInteraction {
    protected BlockState handle(Player player, Contraption contraption, BlockPos pos, BlockState currentState) {
        boolean trainSlide = currentState.getBlock() instanceof TrainSlideBlock;
        SoundEvent sound = ((Boolean)currentState.getValue((Property)TrainSlideBlock.OPEN)).booleanValue() ? (trainSlide ? null : SoundEvents.WOODEN_DOOR_CLOSE) : (trainSlide ? SoundEvents.IRON_DOOR_OPEN : SoundEvents.WOODEN_DOOR_OPEN);
        currentState = (BlockState)currentState.cycle((Property)TrainSlideBlock.OPEN);
        if (player != null) {
            if (trainSlide) {
                Boolean open = (Boolean)currentState.getValue((Property)TrainSlideBlock.OPEN);
                this.toggleSlide(currentState, pos, null, open, contraption);
            }
            float pitch = player.level().random.nextFloat() * 0.1f + 0.9f;
            if (sound != null) {
                this.playSound(player, sound, pitch);
            }
        }
        return currentState;
    }

    private void toggleSlide(BlockState state, BlockPos pos, String ignore, Boolean open, Contraption contraption) {
        if (ignore == null) {
            ignore = "";
        }
        Direction facing = (Direction)state.getValue((Property)TrainSlideBlock.FACING);
        TrainSlideBlock.ConnectedState connected = (TrainSlideBlock.ConnectedState)((Object)state.getValue(TrainSlideBlock.CONNECTED));
        if (connected == TrainSlideBlock.ConnectedState.BOTH) {
            BlockState rightState;
            BlockState leftState;
            BlockPos leftPos = pos.relative(facing.getClockWise());
            BlockPos rightPos = pos.relative(facing.getCounterClockWise());
            StructureTemplate.StructureBlockInfo leftInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(leftPos);
            StructureTemplate.StructureBlockInfo rightInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(rightPos);
            try {
                leftState = leftInfo.state();
            }
            catch (NullPointerException e) {
                leftState = null;
            }
            try {
                rightState = rightInfo.state();
            }
            catch (NullPointerException e) {
                rightState = null;
            }
            if (leftInfo != null && leftInfo.state().getValue(TrainSlideBlock.CONNECTED) != TrainSlideBlock.ConnectedState.NONE && !ignore.equals("left")) {
                this.toggleSlide(leftState, leftPos, "right", open, contraption);
            }
            if (rightInfo != null && rightInfo.state().getValue(TrainSlideBlock.CONNECTED) != TrainSlideBlock.ConnectedState.NONE && !ignore.equals("right")) {
                this.toggleSlide(rightState, rightPos, "left", open, contraption);
            }
        } else if (connected == TrainSlideBlock.ConnectedState.LEFT) {
            BlockPos leftPos = pos.relative(facing.getClockWise());
            StructureTemplate.StructureBlockInfo leftInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(leftPos);
            if (leftInfo != null && leftInfo.state().getValue(TrainSlideBlock.CONNECTED) != TrainSlideBlock.ConnectedState.NONE && !ignore.equals("left")) {
                this.toggleSlide(leftInfo.state(), leftPos, "right", open, contraption);
            }
        } else if (connected == TrainSlideBlock.ConnectedState.RIGHT) {
            BlockPos rightPos = pos.relative(facing.getCounterClockWise());
            StructureTemplate.StructureBlockInfo rightInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(rightPos);
            if (rightInfo != null && rightInfo.state().getValue(TrainSlideBlock.CONNECTED) != TrainSlideBlock.ConnectedState.NONE && !ignore.equals("right")) {
                this.toggleSlide(rightInfo.state(), rightPos, "left", open, contraption);
            }
        }
        this.handlePlayerInteraction(null, InteractionHand.MAIN_HAND, pos, contraption.entity);
    }

    protected boolean updateColliders() {
        return true;
    }
}

