/*
 * Decompiled with CFR 0.152.
 */
package com.tiestoettoet.create_train_parts.content.contraptions.behaviour;

import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.SimpleBlockMovingInteraction;
import com.tiestoettoet.create_train_parts.content.decoration.trainStep.TrainStepBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class StepMovingInteraction
extends SimpleBlockMovingInteraction {
    protected BlockState handle(Player player, Contraption contraption, BlockPos pos, BlockState currentState) {
        boolean trainStep = currentState.getBlock() instanceof TrainStepBlock;
        SoundEvent sound = ((Boolean)currentState.getValue((Property)TrainStepBlock.OPEN)).booleanValue() ? (trainStep ? null : SoundEvents.WOODEN_DOOR_CLOSE) : (trainStep ? SoundEvents.IRON_DOOR_OPEN : SoundEvents.WOODEN_DOOR_OPEN);
        currentState = (BlockState)currentState.cycle((Property)TrainStepBlock.OPEN);
        if (player != null) {
            if (trainStep) {
                Boolean open = (Boolean)currentState.getValue((Property)TrainStepBlock.OPEN);
                this.toggleStep(currentState, pos, null, open, contraption);
            }
            float pitch = player.level().random.nextFloat() * 0.1f + 0.9f;
            if (sound != null) {
                this.playSound(player, sound, pitch);
            }
        }
        return currentState;
    }

    private void toggleStep(BlockState state, BlockPos pos, String ignore, Boolean open, Contraption contraption) {
        if (ignore == null) {
            ignore = "";
        }
        Direction facing = (Direction)state.getValue((Property)TrainStepBlock.FACING);
        TrainStepBlock.ConnectedState connected = (TrainStepBlock.ConnectedState)((Object)state.getValue(TrainStepBlock.CONNECTED));
        if (connected == TrainStepBlock.ConnectedState.BOTH) {
            BlockState rightState;
            BlockState leftState;
            BlockPos leftPos = pos.relative(facing.getClockWise());
            BlockPos rightPos = pos.relative(facing.getCounterClockWise());
            StructureTemplate.StructureBlockInfo leftInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(leftPos);
            StructureTemplate.StructureBlockInfo rightInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(rightPos);
            try {
                leftState = leftInfo.state();
            }
            catch (NullPointerException e) {
                leftState = null;
            }
            try {
                rightState = rightInfo.state();
            }
            catch (NullPointerException e) {
                rightState = null;
            }
            if (leftInfo != null && leftInfo.state().getValue(TrainStepBlock.CONNECTED) != TrainStepBlock.ConnectedState.NONE && !ignore.equals("left")) {
                this.toggleStep(leftState, leftPos, "right", open, contraption);
            }
            if (rightInfo != null && rightInfo.state().getValue(TrainStepBlock.CONNECTED) != TrainStepBlock.ConnectedState.NONE && !ignore.equals("right")) {
                this.toggleStep(rightState, rightPos, "left", open, contraption);
            }
        } else if (connected == TrainStepBlock.ConnectedState.LEFT) {
            BlockPos leftPos = pos.relative(facing.getClockWise());
            StructureTemplate.StructureBlockInfo leftInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(leftPos);
            if (leftInfo != null && leftInfo.state().getValue(TrainStepBlock.CONNECTED) != TrainStepBlock.ConnectedState.NONE && !ignore.equals("left")) {
                this.toggleStep(leftInfo.state(), leftPos, "right", open, contraption);
            }
        } else if (connected == TrainStepBlock.ConnectedState.RIGHT) {
            BlockPos rightPos = pos.relative(facing.getCounterClockWise());
            StructureTemplate.StructureBlockInfo rightInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(rightPos);
            if (rightInfo != null && rightInfo.state().getValue(TrainStepBlock.CONNECTED) != TrainStepBlock.ConnectedState.NONE && !ignore.equals("right")) {
                this.toggleStep(rightInfo.state(), rightPos, "left", open, contraption);
            }
        }
        this.handlePlayerInteraction(null, InteractionHand.MAIN_HAND, pos, contraption.entity);
    }

    protected boolean updateColliders() {
        return true;
    }
}

