/*
 * Decompiled with CFR 0.152.
 */
package com.tiestoettoet.create_train_parts.content.contraptions.behaviour;

import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.SimpleBlockMovingInteraction;
import com.tiestoettoet.create_train_parts.content.decoration.slidingWindow.SlidingWindowBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class WindowMovingInteraction
extends SimpleBlockMovingInteraction {
    protected BlockState handle(Player player, Contraption contraption, BlockPos pos, BlockState currentState) {
        boolean trainWindow = currentState.getBlock() instanceof SlidingWindowBlock;
        SoundEvent sound = ((Boolean)currentState.getValue((Property)SlidingWindowBlock.OPEN)).booleanValue() ? (trainWindow ? null : SoundEvents.WOODEN_DOOR_CLOSE) : (trainWindow ? SoundEvents.IRON_DOOR_OPEN : SoundEvents.WOODEN_DOOR_OPEN);
        currentState = (BlockState)currentState.cycle((Property)SlidingWindowBlock.OPEN);
        if (player != null) {
            if (trainWindow) {
                Boolean open = (Boolean)currentState.getValue((Property)SlidingWindowBlock.OPEN);
                this.toggleWindow(currentState, pos, null, open, contraption);
            }
            float pitch = player.level().random.nextFloat() * 0.1f + 0.9f;
            if (sound != null) {
                this.playSound(player, sound, pitch);
            }
        }
        return currentState;
    }

    private void toggleWindow(BlockState state, BlockPos pos, String ignore, Boolean open, Contraption contraption) {
        BlockState rightState;
        BlockState leftState;
        if (ignore == null) {
            ignore = "";
        }
        Direction facing = (Direction)state.getValue((Property)SlidingWindowBlock.FACING);
        BlockPos leftPos = pos.relative(facing.getClockWise());
        BlockPos rightPos = pos.relative(facing.getCounterClockWise());
        StructureTemplate.StructureBlockInfo leftInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(leftPos);
        StructureTemplate.StructureBlockInfo rightInfo = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(rightPos);
        try {
            leftState = leftInfo.state();
        }
        catch (NullPointerException e) {
            leftState = null;
        }
        try {
            rightState = rightInfo.state();
        }
        catch (NullPointerException e) {
            rightState = null;
        }
        if (leftInfo != null && !ignore.equals("left") && leftInfo.state().getBlock() instanceof SlidingWindowBlock) {
            this.toggleWindow(leftState, leftPos, "right", open, contraption);
        }
        if (rightInfo != null && !ignore.equals("right") && rightInfo.state().getBlock() instanceof SlidingWindowBlock) {
            this.toggleWindow(rightState, rightPos, "left", open, contraption);
        }
        this.handlePlayerInteraction(null, InteractionHand.MAIN_HAND, pos, contraption.entity);
    }

    protected boolean updateColliders() {
        return true;
    }
}

