/*
 * Decompiled with CFR 0.152.
 */
package com.tiestoettoet.create_train_parts.content.decoration.slidingWindow;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.CTType;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.tiestoettoet.create_train_parts.AllPartialModels;
import com.tiestoettoet.create_train_parts.CreateTrainParts;
import com.tiestoettoet.create_train_parts.content.decoration.SlidingWindowCTBehaviour;
import com.tiestoettoet.create_train_parts.content.decoration.slidingWindow.SlidingWindowBlock;
import com.tiestoettoet.create_train_parts.content.decoration.slidingWindow.SlidingWindowBlockEntity;
import com.tiestoettoet.create_train_parts.content.decoration.trainSlide.TrainSlideBlock;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.ArrayList;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class SlidingWindowRenderer
extends SafeBlockEntityRenderer<SlidingWindowBlockEntity> {
    public SlidingWindowRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(SlidingWindowBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockState = be.getBlockState();
        BlockState rightState = be.getLevel().getBlockState(be.getBlockPos().relative(((Direction)blockState.getValue((Property)SlidingWindowBlock.FACING)).getClockWise()));
        BlockState leftState = be.getLevel().getBlockState(be.getBlockPos().relative(((Direction)blockState.getValue((Property)SlidingWindowBlock.FACING)).getCounterClockWise()));
        BlockState upState = be.getLevel().getBlockState(be.getBlockPos().relative(Direction.UP));
        BlockState downState = be.getLevel().getBlockState(be.getBlockPos().relative(Direction.DOWN));
        SlidingWindowBlockEntity.SelectionMode mode = be.getMode();
        SlidingWindowBlockEntity.SelectionMode rightMode = null;
        if (rightState.getBlock() instanceof SlidingWindowBlock) {
            rightMode = (SlidingWindowBlockEntity.SelectionMode)((Object)rightState.getValue(SlidingWindowBlock.MODE));
        }
        SlidingWindowBlockEntity.SelectionMode leftMode = null;
        if (leftState.getBlock() instanceof SlidingWindowBlock) {
            leftMode = (SlidingWindowBlockEntity.SelectionMode)((Object)leftState.getValue(SlidingWindowBlock.MODE));
        }
        SlidingWindowBlockEntity.SelectionMode upMode = null;
        if (upState.getBlock() instanceof SlidingWindowBlock) {
            upMode = (SlidingWindowBlockEntity.SelectionMode)((Object)upState.getValue(SlidingWindowBlock.MODE));
        }
        SlidingWindowBlockEntity.SelectionMode downMode = null;
        if (downState.getBlock() instanceof SlidingWindowBlock) {
            downMode = (SlidingWindowBlockEntity.SelectionMode)((Object)downState.getValue(SlidingWindowBlock.MODE));
        }
        if (!be.shouldRenderSpecial(blockState)) {
            return;
        }
        Boolean right = !(rightState.getBlock() instanceof SlidingWindowBlock) || rightState.getValue((Property)SlidingWindowBlock.FACING) != blockState.getValue((Property)SlidingWindowBlock.FACING) || mode != rightMode;
        Boolean left = !(leftState.getBlock() instanceof SlidingWindowBlock) || leftState.getValue((Property)SlidingWindowBlock.FACING) != blockState.getValue((Property)SlidingWindowBlock.FACING) || mode != leftMode;
        Boolean up = !(upState.getBlock() instanceof SlidingWindowBlock) || upState.getValue((Property)SlidingWindowBlock.FACING) != blockState.getValue((Property)SlidingWindowBlock.FACING) || mode != upMode;
        Boolean down = !(downState.getBlock() instanceof SlidingWindowBlock) || downState.getValue((Property)SlidingWindowBlock.FACING) != blockState.getValue((Property)SlidingWindowBlock.FACING) || mode != downMode;
        BlockPos pos = be.getBlockPos();
        Level world = be.getLevel();
        Direction facing = (Direction)blockState.getValue((Property)TrainSlideBlock.FACING);
        float rotationAngle = switch (facing) {
            case Direction.NORTH -> 0.0f;
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            case Direction.EAST -> -90.0f;
            default -> 0.0f;
        };
        float value = be.animation.getValue(partialTicks);
        float exponentialValue = value * value;
        VertexConsumer vb = buffer.getBuffer(RenderType.cutoutMipped());
        if (blockState.getBlock() instanceof SlidingWindowBlock) {
            Vec3 upOffset;
            Vec3 moveOffset;
            ResourceLocation blockTexture = BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock());
            String blockTexturePath = blockTexture.getPath();
            CTSpriteShiftEntry spriteShift = null;
            String type = "";
            if (blockTexturePath == "glass_sliding_window") {
                spriteShift = AllSpriteShifts.FRAMED_GLASS;
                type = "glass";
            } else if (blockTexturePath.contains("andesite_sliding_window")) {
                spriteShift = AllSpriteShifts.ANDESITE_CASING;
                type = "andesite";
            } else if (blockTexturePath.contains("brass_sliding_window")) {
                spriteShift = AllSpriteShifts.BRASS_CASING;
                type = "brass";
            } else if (blockTexturePath.contains("copper_sliding_window")) {
                spriteShift = AllSpriteShifts.COPPER_CASING;
                type = "copper";
            } else if (blockTexturePath.contains("train_sliding_window")) {
                spriteShift = AllSpriteShifts.RAILWAY_CASING;
                type = "train";
            } else {
                spriteShift = AllSpriteShifts.FRAMED_GLASS;
                type = "glass";
            }
            SlidingWindowCTBehaviour behaviour = new SlidingWindowCTBehaviour(spriteShift);
            CTType dataType = behaviour.getDataType((BlockAndTintGetter)world, pos, blockState, facing);
            float f = (Boolean)blockState.getValue((Property)SlidingWindowBlock.OPEN) != false ? -1.0f : 1.0f;
            float animFirstQuarter = Mth.clamp((float)(exponentialValue / 0.25f), (float)0.0f, (float)1.0f);
            float animSecondQuarter = Mth.clamp((float)((exponentialValue - 0.25f) / 0.25f), (float)0.0f, (float)1.0f);
            float animThirdQuarter = Mth.clamp((float)((exponentialValue - 0.5f) / 0.25f), (float)0.0f, (float)1.0f);
            float animFourthQuarter = Mth.clamp((float)((exponentialValue - 0.75f) / 0.25f), (float)0.0f, (float)1.0f);
            float movementMain = 0.18125f * exponentialValue;
            float movementUp = 0.9375f * exponentialValue;
            if ((double)exponentialValue <= 0.25) {
                movementMain = (float)(0.0 + 0.18125 * (double)animFirstQuarter);
                movementUp = 0.0f + 0.1875f * animFirstQuarter;
            } else if ((double)exponentialValue > 0.25 && (double)exponentialValue <= 0.5) {
                movementMain = (float)(0.18125 + (double)(0.0f * animSecondQuarter));
                movementUp = 0.1875f + 0.25f * animSecondQuarter;
            } else if ((double)exponentialValue > 0.5 && (double)exponentialValue <= 0.75) {
                movementMain = (float)(0.18125 + (double)(0.0f * animThirdQuarter));
                movementUp = 0.4375f + 0.25f * animThirdQuarter;
            } else {
                movementMain = (float)(0.18125 + (double)(0.0f * animFourthQuarter));
                movementUp = 0.6875f + 0.25f * animFourthQuarter;
            }
            Direction movementDirection = facing.getOpposite();
            if (mode == SlidingWindowBlockEntity.SelectionMode.UP) {
                moveOffset = Vec3.atLowerCornerOf((Vec3i)movementDirection.getNormal()).scale((double)movementMain);
                upOffset = Vec3.atLowerCornerOf((Vec3i)Direction.UP.getNormal()).scale((double)movementUp);
            } else if (mode == SlidingWindowBlockEntity.SelectionMode.DOWN) {
                moveOffset = Vec3.atLowerCornerOf((Vec3i)movementDirection.getNormal()).scale((double)movementMain);
                upOffset = Vec3.atLowerCornerOf((Vec3i)Direction.DOWN.getNormal()).scale((double)movementUp);
            } else if (mode == SlidingWindowBlockEntity.SelectionMode.LEFT) {
                moveOffset = Vec3.atLowerCornerOf((Vec3i)facing.getOpposite().getNormal()).scale((double)movementMain).add(Vec3.atLowerCornerOf((Vec3i)movementDirection.getCounterClockWise().getNormal()).scale((double)movementUp));
                upOffset = Vec3.ZERO;
            } else if (mode == SlidingWindowBlockEntity.SelectionMode.RIGHT) {
                moveOffset = Vec3.atLowerCornerOf((Vec3i)facing.getOpposite().getNormal()).scale((double)movementMain).add(Vec3.atLowerCornerOf((Vec3i)movementDirection.getClockWise().getNormal()).scale((double)movementUp));
                upOffset = Vec3.ZERO;
            } else {
                moveOffset = Vec3.ZERO;
                upOffset = Vec3.ZERO;
            }
            ResourceLocation resourceLocationMain = CreateTrainParts.asResource("sliding_windows/" + type + "_main");
            ResourceLocation resourceLocationUp = CreateTrainParts.asResource("sliding_windows/" + type + "_up");
            ResourceLocation resourceLocationRight = CreateTrainParts.asResource("sliding_windows/" + type + "_right");
            ResourceLocation resourceLocationDown = CreateTrainParts.asResource("sliding_windows/" + type + "_down");
            ResourceLocation resourceLocationLeft = CreateTrainParts.asResource("sliding_windows/" + type + "_left");
            ResourceLocation resourceLocationBack = CreateTrainParts.asResource("sliding_windows/" + type + "_back");
            PartialModel main = AllPartialModels.SLIDING_WINDOW.get(resourceLocationMain);
            PartialModel upModel = AllPartialModels.SLIDING_WINDOW_UP.get(resourceLocationUp);
            PartialModel rightModel = AllPartialModels.SLIDING_WINDOW_RIGHT.get(resourceLocationRight);
            PartialModel downModel = AllPartialModels.SLIDING_WINDOW_DOWN.get(resourceLocationDown);
            PartialModel leftModel = AllPartialModels.SLIDING_WINDOW_LEFT.get(resourceLocationLeft);
            PartialModel back = AllPartialModels.SLIDING_WINDOW_BACK.get(resourceLocationBack);
            SuperByteBuffer partial_main = CachedBuffers.partial((PartialModel)main, (BlockState)blockState);
            SuperByteBuffer partial_up = CachedBuffers.partial((PartialModel)upModel, (BlockState)blockState);
            SuperByteBuffer partial_right = CachedBuffers.partial((PartialModel)rightModel, (BlockState)blockState);
            SuperByteBuffer partial_down = CachedBuffers.partial((PartialModel)downModel, (BlockState)blockState);
            SuperByteBuffer partial_left = CachedBuffers.partial((PartialModel)leftModel, (BlockState)blockState);
            SuperByteBuffer partial_back = CachedBuffers.partial((PartialModel)back, (BlockState)blockState);
            ArrayList<SuperByteBuffer> partialSides = new ArrayList<SuperByteBuffer>();
            if (up.booleanValue()) {
                partialSides.add(partial_up);
            }
            if (right.booleanValue()) {
                partialSides.add(partial_right);
            }
            if (down.booleanValue()) {
                partialSides.add(partial_down);
            }
            if (left.booleanValue()) {
                partialSides.add(partial_left);
            }
            for (SuperByteBuffer partial_side : partialSides) {
                ((SuperByteBuffer)((SuperByteBuffer)partial_side.translate(moveOffset.x, upOffset.y, moveOffset.z)).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).light(light).renderInto(ms, vb);
            }
            ConnectedTextureBehaviour.CTContext context = behaviour.buildContext((BlockAndTintGetter)world, pos, blockState, facing.getOpposite(), dataType.getContextRequirement());
            int textureIndex = dataType.getTextureIndex(context);
            float row = Math.floorDiv(textureIndex, 8);
            float column = textureIndex % 8;
            float u = column / 8.0f;
            float v = row / 8.0f;
            ((SuperByteBuffer)((SuperByteBuffer)partial_main.translate(moveOffset.x, upOffset.y, moveOffset.z)).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).shiftUVtoSheet((SpriteShiftEntry)spriteShift, u, v, 8).light(light).renderInto(ms, vb);
            context = behaviour.buildContext((BlockAndTintGetter)world, pos, blockState, facing, dataType.getContextRequirement());
            textureIndex = dataType.getTextureIndex(context);
            row = Math.floorDiv(textureIndex, 8);
            column = textureIndex % 8;
            u = column / 8.0f;
            v = row / 8.0f;
            ((SuperByteBuffer)((SuperByteBuffer)partial_back.translate(moveOffset.x, upOffset.y, moveOffset.z)).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).shiftUVtoSheet((SpriteShiftEntry)spriteShift, u, v, 8).light(light).renderInto(ms, vb);
        }
    }
}

