/*
 * Decompiled with CFR 0.152.
 */
package com.tiestoettoet.create_train_parts.content.decoration.trainSlide;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.CTType;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.tiestoettoet.create_train_parts.AllPartialModels;
import com.tiestoettoet.create_train_parts.AllSpriteShifts;
import com.tiestoettoet.create_train_parts.CreateTrainParts;
import com.tiestoettoet.create_train_parts.content.decoration.encasing.EncasedCTBehaviour;
import com.tiestoettoet.create_train_parts.content.decoration.trainSlide.TrainSlideBlock;
import com.tiestoettoet.create_train_parts.content.decoration.trainSlide.TrainSlideBlockEntity;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class TrainSlideRenderer
extends SafeBlockEntityRenderer<TrainSlideBlockEntity> {
    public TrainSlideRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(TrainSlideBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        float relativeValue;
        Direction facing;
        BlockState blockState = be.getBlockState();
        if (!be.shouldRenderSpecial(blockState)) {
            return;
        }
        BlockPos pos = be.getBlockPos();
        EncasedCTBehaviour behaviour = new EncasedCTBehaviour(com.simibubi.create.AllSpriteShifts.ANDESITE_CASING);
        Level world = be.getLevel();
        CTType dataType = behaviour.getDataType((BlockAndTintGetter)world, pos, blockState, facing = (Direction)blockState.getValue((Property)TrainSlideBlock.FACING));
        if (dataType == null) {
            return;
        }
        float rotationAngle = switch (facing) {
            case Direction.NORTH -> 0.0f;
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            case Direction.EAST -> -90.0f;
            default -> 0.0f;
        };
        float value = be.animation.getValue(partialTicks);
        float exponentialValue = value * value;
        float relativeAnimationValue = relativeValue = (Boolean)blockState.getValue((Property)TrainSlideBlock.OPEN) != false ? exponentialValue : 1.0f - exponentialValue;
        VertexConsumer vb = buffer.getBuffer(RenderType.cutoutMipped());
        if (blockState.getBlock() instanceof TrainSlideBlock) {
            ResourceLocation blockTexture = BuiltInRegistries.BLOCK.getKey((Object)blockState.getBlock());
            String blockTexturePath = blockTexture.getPath();
            TrainSlideBlock.ConnectedState connectedState = (TrainSlideBlock.ConnectedState)((Object)blockState.getValue(TrainSlideBlock.CONNECTED));
            float f = (Boolean)blockState.getValue((Property)TrainSlideBlock.OPEN) != false ? -1.0f : 1.0f;
            float movement = 0.3125f * exponentialValue * f;
            Direction movementDirection = (Boolean)blockState.getValue((Property)TrainSlideBlock.OPEN) != false ? facing.getOpposite() : facing;
            Vec3 moveOffset = Vec3.atLowerCornerOf((Vec3i)movementDirection.getNormal()).scale((double)movement);
            float movementP = 0.65625f;
            Vec3 moveOffsetP = Vec3.atLowerCornerOf((Vec3i)facing.getOpposite().getNormal()).scale((double)movementP);
            float rotationPivot = (Boolean)blockState.getValue((Property)TrainSlideBlock.OPEN) != false ? 90.0f * f * exponentialValue : 90.0f * f * (1.0f - exponentialValue) - 90.0f;
            float valueFromThirdTenth = Mth.clamp((float)((exponentialValue - 0.3f) / 0.7f), (float)0.0f, (float)1.0f);
            float valueFromSeventhTenth = Mth.clamp((float)((exponentialValue - 0.7f) / 0.3f), (float)0.0f, (float)1.0f);
            float movementB = 0.8125f * exponentialValue * f;
            float movementC = 0.5625f * valueFromThirdTenth * f;
            float movementT = 0.25f * valueFromSeventhTenth * f;
            Vec3 moveOffsetB = Vec3.atLowerCornerOf((Vec3i)movementDirection.getNormal()).scale((double)movementB);
            Vec3 moveOffsetC = Vec3.atLowerCornerOf((Vec3i)movementDirection.getNormal()).scale((double)movementC);
            Vec3 moveOffsetT = Vec3.atLowerCornerOf((Vec3i)movementDirection.getNormal()).scale((double)movementT);
            for (Direction face : Iterate.directions) {
                ConnectedTextureBehaviour.CTContext context = behaviour.buildContext((BlockAndTintGetter)world, pos, blockState, face, dataType.getContextRequirement());
                int textureIndex = dataType.getTextureIndex(context);
                if (facing == Direction.EAST && face != Direction.UP && face != Direction.DOWN) {
                    face = face.getCounterClockWise();
                }
                if (facing == Direction.SOUTH && face != Direction.UP && face != Direction.DOWN) {
                    face = face.getOpposite();
                }
                if (facing == Direction.WEST && face != Direction.UP && face != Direction.DOWN) {
                    face = face.getClockWise();
                }
                ResourceLocation resourceLocation = CreateTrainParts.asResource(blockTexturePath + "/" + facing.getSerializedName() + "_" + connectedState.getSerializedName() + "_" + face.getSerializedName());
                PartialModel top = AllPartialModels.TRAIN_SLIDE_TOP.get(resourceLocation);
                PartialModel centre = AllPartialModels.TRAIN_SLIDE_CENTRE.get(resourceLocation);
                PartialModel block = AllPartialModels.TRAIN_SLIDE.get(resourceLocation);
                PartialModel bottom = AllPartialModels.TRAIN_SLIDE_BOTTOM.get(resourceLocation);
                SuperByteBuffer partial_block = CachedBuffers.partial((PartialModel)block, (BlockState)blockState);
                CTSpriteShiftEntry spriteShift = null;
                if (blockTexturePath.equals("train_slide_andesite")) {
                    spriteShift = com.simibubi.create.AllSpriteShifts.ANDESITE_CASING;
                } else if (blockTexturePath.equals("train_slide_brass")) {
                    spriteShift = com.simibubi.create.AllSpriteShifts.BRASS_CASING;
                } else if (blockTexturePath.equals("train_slide_copper")) {
                    spriteShift = com.simibubi.create.AllSpriteShifts.COPPER_CASING;
                } else if (blockTexturePath.equals("train_slide_train")) {
                    spriteShift = face == Direction.UP || face == Direction.DOWN ? AllSpriteShifts.TRAIN_STEP_TRAIN : AllSpriteShifts.TRAIN_STEP_SIDE;
                } else {
                    return;
                }
                if (spriteShift == null) {
                    return;
                }
                SuperByteBuffer partial_bottom = CachedBuffers.partial((PartialModel)bottom, (BlockState)blockState);
                SuperByteBuffer partial_top = CachedBuffers.partial((PartialModel)top, (BlockState)blockState);
                SuperByteBuffer partial_centre = CachedBuffers.partial((PartialModel)centre, (BlockState)blockState);
                float row = Math.floorDiv(textureIndex, 8);
                float column = textureIndex % 8;
                float u = column / 8.0f;
                float v = row / 8.0f;
                int blockLight = this.getSafeLight((BlockAndTintGetter)world, pos, light);
                ((SuperByteBuffer)partial_block.rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).shiftUVtoSheet((SpriteShiftEntry)spriteShift, u, v, 8).light(blockLight).renderInto(ms, vb);
                BlockPos centrePos = pos.offset((int)Math.round(moveOffsetC.x), (int)Math.round(moveOffsetC.y), (int)Math.round(moveOffsetC.z));
                int centreLight = this.getSafeLight((BlockAndTintGetter)world, centrePos, light);
                ((SuperByteBuffer)((SuperByteBuffer)partial_centre.translate(moveOffsetC.x, moveOffsetC.y, moveOffsetC.z)).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).shiftUVtoSheet((SpriteShiftEntry)spriteShift, u, v, 8).light(centreLight).renderInto(ms, vb);
                BlockPos topPos = pos.offset((int)Math.round(moveOffsetT.x), (int)Math.round(moveOffsetT.y), (int)Math.round(moveOffsetT.z));
                int topLight = this.getSafeLight((BlockAndTintGetter)world, topPos, light);
                ((SuperByteBuffer)((SuperByteBuffer)partial_top.translate(moveOffsetT.x, moveOffsetT.y, moveOffsetT.z)).shiftUVtoSheet((SpriteShiftEntry)spriteShift, u, v, 8).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).light(topLight).renderInto(ms, vb);
                BlockPos bottomPos = pos.offset((int)Math.round(moveOffsetB.x), (int)Math.round(moveOffsetB.y), (int)Math.round(moveOffsetB.z));
                int bottomLight = this.getSafeLight((BlockAndTintGetter)world, bottomPos, light);
                ((SuperByteBuffer)((SuperByteBuffer)partial_bottom.translate(moveOffsetB.x, moveOffsetB.y, moveOffsetB.z)).rotateCentered((float)Math.PI / 180 * rotationAngle, Direction.Axis.Y)).shiftUVtoSheet((SpriteShiftEntry)spriteShift, u, v, 8).light(bottomLight).renderInto(ms, vb);
            }
        }
    }

    private int getSafeLight(BlockAndTintGetter world, BlockPos targetPos, int fallbackLight) {
        if (targetPos.getY() < world.getMinBuildHeight() || targetPos.getY() > world.getMaxBuildHeight()) {
            return fallbackLight;
        }
        int calculatedLight = LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)targetPos);
        if (calculatedLight == 0) {
            BlockPos abovePos = targetPos.above();
            int aboveLight = LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)abovePos);
            if (aboveLight > 0) {
                return aboveLight;
            }
            return fallbackLight;
        }
        return calculatedLight;
    }
}

