/*
 * Decompiled with CFR 0.152.
 */
package com.tiestoettoet.create_train_parts.content.trains.crossing;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.tiestoettoet.create_train_parts.AllBlocks;
import com.tiestoettoet.create_train_parts.content.foundation.placement.ArmHelper;
import java.util.function.Predicate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ArmExtenderBlock
extends HorizontalDirectionalBlock
implements IWrenchable {
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)PlacementHelper.get());
    public static final BooleanProperty FLIPPED = BooleanProperty.create((String)"flipped");
    public static final BooleanProperty OPEN = BooleanProperty.create((String)"open");

    public ArmExtenderBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FLIPPED, (Comparable)Boolean.valueOf(false))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return null;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        return state;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue(HorizontalKineticBlock.HORIZONTAL_FACING);
        boolean flipped = (Boolean)state.getValue((Property)FLIPPED);
        VoxelShape baseShape = flipped ? Block.box((double)3.0, (double)6.0, (double)0.0, (double)5.0, (double)10.0, (double)16.0) : Block.box((double)11.0, (double)6.0, (double)0.0, (double)13.0, (double)10.0, (double)16.0);
        return switch (facing) {
            case Direction.NORTH -> {
                if (flipped) {
                    yield Block.box((double)0.0, (double)6.0, (double)3.0, (double)16.0, (double)10.0, (double)5.0);
                }
                yield Block.box((double)0.0, (double)6.0, (double)11.0, (double)16.0, (double)10.0, (double)13.0);
            }
            case Direction.SOUTH -> {
                if (flipped) {
                    yield Block.box((double)0.0, (double)6.0, (double)11.0, (double)16.0, (double)10.0, (double)13.0);
                }
                yield Block.box((double)0.0, (double)6.0, (double)3.0, (double)16.0, (double)10.0, (double)5.0);
            }
            case Direction.EAST -> {
                if (flipped) {
                    yield Block.box((double)11.0, (double)6.0, (double)0.0, (double)13.0, (double)10.0, (double)16.0);
                }
                yield Block.box((double)3.0, (double)6.0, (double)0.0, (double)5.0, (double)10.0, (double)16.0);
            }
            case Direction.WEST -> {
                if (flipped) {
                    yield Block.box((double)3.0, (double)6.0, (double)0.0, (double)5.0, (double)10.0, (double)16.0);
                }
                yield Block.box((double)11.0, (double)6.0, (double)0.0, (double)13.0, (double)10.0, (double)16.0);
            }
            default -> baseShape;
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        if (state == null) {
            return null;
        }
        Direction facing = context.getHorizontalDirection();
        boolean flipped = false;
        return (BlockState)((BlockState)((BlockState)state.setValue(HorizontalKineticBlock.HORIZONTAL_FACING, (Comparable)facing)).setValue((Property)FLIPPED, (Comparable)Boolean.valueOf(flipped))).setValue((Property)OPEN, (Comparable)Boolean.valueOf(true));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
        if (placementHelper.matchesItem(stack) && !player.isShiftKeyDown()) {
            return placementHelper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (BlockItem)stack.getItem(), player, hand, hitResult);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static boolean isArm(BlockState state) {
        return AllBlocks.ARM_EXTENDER.has(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{HorizontalKineticBlock.HORIZONTAL_FACING}).add(new Property[]{FLIPPED}).add(new Property[]{OPEN}));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighbourState, LevelAccessor world, BlockPos pos, BlockPos neighbourPos) {
        return state;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    @MethodsReturnNonnullByDefault
    public static class PlacementHelper
    extends ArmHelper<Direction> {
        private static final PlacementHelper instance = new PlacementHelper();

        public static PlacementHelper get() {
            return instance;
        }

        private PlacementHelper() {
            super(arg_0 -> AllBlocks.ARM_EXTENDER.has(arg_0), state -> ((Direction)state.getValue(HorizontalKineticBlock.HORIZONTAL_FACING)).getClockWise().getAxis(), HorizontalKineticBlock.HORIZONTAL_FACING);
        }

        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> AllBlocks.ARM_EXTENDER.isIn(arg_0);
        }
    }
}

