/*
 * Decompiled with CFR 0.152.
 */
package com.tiestoettoet.create_train_parts.content.trains.crossing;

import com.simibubi.create.api.contraption.ContraptionType;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.tiestoettoet.create_train_parts.AllBlocks;
import com.tiestoettoet.create_train_parts.AllContraptionTypes;
import com.tiestoettoet.create_train_parts.content.trains.crossing.ArmExtenderBlock;
import com.tiestoettoet.create_train_parts.content.trains.crossing.CrossingBlock;
import java.util.Queue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.apache.commons.lang3.tuple.Pair;

public class CrossingContraption
extends Contraption {
    protected Direction facing;

    public CrossingContraption() {
    }

    public CrossingContraption(Direction direction) {
        this.facing = direction;
    }

    public boolean assemble(Level world, BlockPos pos) throws AssemblyException {
        System.out.println("CrossingContraption.assemble() called at " + String.valueOf(pos));
        this.anchor = pos;
        boolean searchResult = this.searchMovedStructure(world, pos, null);
        System.out.println("searchMovedStructure result: " + searchResult + ", blocks found: " + this.blocks.size());
        if (!searchResult) {
            System.out.println("Assembly failed: searchMovedStructure returned false");
            return false;
        }
        if (this.facing != null) {
            this.expandBoundsAroundAxis(this.facing.getClockWise().getAxis());
        }
        if (this.blocks.isEmpty()) {
            System.out.println("Assembly failed: no blocks found");
            return false;
        }
        System.out.println("Assembly successful with " + this.blocks.size() + " blocks");
        return true;
    }

    public ContraptionType getType() {
        return (ContraptionType)AllContraptionTypes.CROSSING.value();
    }

    protected boolean isAnchoringBlockAt(BlockPos pos) {
        return pos.equals((Object)this.anchor);
    }

    public void addBlock(Level level, BlockPos pos, Pair<StructureTemplate.StructureBlockInfo, BlockEntity> capture) {
        System.out.println("Adding block to contraption at " + String.valueOf(pos) + ": " + ((StructureTemplate.StructureBlockInfo)capture.getLeft()).state().getBlock().getClass().getSimpleName());
        super.addBlock(level, pos, capture);
    }

    public CompoundTag writeNBT(HolderLookup.Provider registries, boolean spawnPacket) {
        CompoundTag tag = super.writeNBT(registries, spawnPacket);
        tag.putInt("Facing", this.facing.get3DDataValue());
        return tag;
    }

    public void readNBT(Level world, CompoundTag tag, boolean spawnData) {
        this.facing = Direction.from3DDataValue((int)tag.getInt("Facing"));
        super.readNBT(world, tag, spawnData);
    }

    public Direction getFacing() {
        return this.facing;
    }

    protected boolean moveBlock(Level world, Direction forcedDirection, Queue<BlockPos> frontier, Set<BlockPos> visited) throws AssemblyException {
        boolean flipped;
        BlockPos pos = frontier.peek();
        if (pos == null) {
            return super.moveBlock(world, forcedDirection, frontier, visited);
        }
        BlockState state = world.getBlockState(pos);
        System.out.println("Processing block at " + String.valueOf(pos) + ": " + state.getBlock().getClass().getSimpleName());
        if (AllBlocks.CROSSING.has(state)) {
            System.out.println("Found crossing block at " + String.valueOf(pos));
            flipped = (Boolean)state.getValue((Property)CrossingBlock.FLIPPED);
            Direction crossingFacing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            Direction armDirection = crossingFacing.getClockWise();
            BlockPos armPos = pos.relative(armDirection);
            int armCount = 0;
            while (world.getBlockState(armPos).getBlock() instanceof ArmExtenderBlock) {
                if (!visited.contains(armPos)) {
                    frontier.add(armPos);
                    System.out.println("Added arm extender " + ++armCount + " at " + String.valueOf(armPos));
                }
                armPos = armPos.relative(armDirection);
            }
            System.out.println("Total arms found: " + armCount);
        }
        if (state.getBlock() instanceof ArmExtenderBlock) {
            BlockPos prevArmPos;
            System.out.println("Found arm extender at " + String.valueOf(pos));
            flipped = (Boolean)state.getValue((Property)ArmExtenderBlock.FLIPPED);
            Direction armFacing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            Direction chainDirection = flipped ? armFacing.getCounterClockWise() : armFacing.getClockWise();
            BlockPos nextArmPos = pos.relative(chainDirection);
            if (!visited.contains(nextArmPos) && world.getBlockState(nextArmPos).getBlock() instanceof ArmExtenderBlock) {
                frontier.add(nextArmPos);
                System.out.println("Connected to next arm at " + String.valueOf(nextArmPos));
            }
            if (!visited.contains(prevArmPos = pos.relative(chainDirection.getOpposite())) && world.getBlockState(prevArmPos).getBlock() instanceof ArmExtenderBlock) {
                frontier.add(prevArmPos);
                System.out.println("Connected to previous arm at " + String.valueOf(prevArmPos));
            }
        }
        return super.moveBlock(world, forcedDirection, frontier, visited);
    }

    public boolean canBeStabilized(Direction facing, BlockPos localPos) {
        return false;
    }
}

