/*
 * Decompiled with CFR 0.152.
 */
package com.tiestoettoet.create_train_parts.foundation.block;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class WrenchableHorizontalDirectionalBlock
extends HorizontalDirectionalBlock
implements IWrenchable {
    public static final MapCodec<WrenchableHorizontalDirectionalBlock> CODEC = WrenchableHorizontalDirectionalBlock.simpleCodec(WrenchableHorizontalDirectionalBlock::new);

    public WrenchableHorizontalDirectionalBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
        super.createBlockStateDefinition(builder);
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        Direction facing = (Direction)originalState.getValue((Property)FACING);
        if (facing.getAxis() == targetedFace.getAxis()) {
            return originalState;
        }
        Direction newFacing = facing.getClockWise(targetedFace.getAxis());
        if (newFacing == Direction.UP || newFacing == Direction.DOWN) {
            return originalState;
        }
        return (BlockState)originalState.setValue((Property)FACING, (Comparable)newFacing);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        Direction newFacing = rot.rotate((Direction)state.getValue((Property)FACING));
        if (newFacing == Direction.UP || newFacing == Direction.DOWN) {
            return state;
        }
        return (BlockState)state.setValue((Property)FACING, (Comparable)newFacing);
    }

    @NotNull
    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

