/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.util;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.InputStream;

public class NettyByteBufInputStream
extends InputStream {
    private int ptr;
    private int end;
    private ByteBuf buf;

    public NettyByteBufInputStream(ByteBuf buf) {
        this.buf = buf;
        this.ptr = buf.readerIndex();
        this.end = this.ptr + buf.readableBytes();
    }

    @Override
    public int read() throws IOException {
        if (!this.buf.isReadable()) {
            return -1;
        }
        if (this.ptr < this.end) {
            int p = this.ptr++;
            return this.buf.getByte(p) & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this.buf.isReadable()) {
            return -1;
        }
        if (this.ptr < this.end) {
            len = Math.min(this.end - this.ptr, len);
            this.buf.getBytes(this.ptr, b, off, len);
            this.ptr += len;
            return len;
        }
        return -1;
    }

    @Override
    public int available() throws IOException {
        return this.end - this.ptr;
    }
}

