/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tom.cpm.client.CapeTransformUtil;
import com.tom.cpm.client.CustomPlayerModelsClient;
import com.tom.cpm.client.ModelTexture;
import com.tom.cpm.client.PlayerRenderStateAccess;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.TextureSheetType;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CapeLayer.class})
public abstract class CapeLayerMixin
extends RenderLayer<PlayerRenderState, PlayerModel> {
    @Shadow
    @Final
    private HumanoidModel<PlayerRenderState> model;

    public CapeLayerMixin(RenderLayerParent<PlayerRenderState, PlayerModel> renderLayerParent) {
        super(renderLayerParent);
    }

    @Inject(at={@At(value="HEAD")}, method={"render(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/renderer/entity/state/PlayerRenderState;FF)V"}, cancellable=true)
    public void onRender(PoseStack poseStack, MultiBufferSource bufferIn, int i, PlayerRenderState state, float f, float g, CallbackInfo cbi) {
        ModelDefinition def;
        com.tom.cpm.shared.config.Player<Player> pl = ((PlayerRenderStateAccess)state).cpm$getPlayer();
        if (pl != null && (def = pl.getModelDefinition()) != null && def.hasRoot(RootModelType.CAPE)) {
            ItemStack chestplate = state.chestItem;
            if (!state.isInvisible && state.showCape && chestplate.getItem() != Items.ELYTRA) {
                ResourceLocation defLoc = state.skin.capeTexture();
                if (defLoc == null) {
                    defLoc = CustomPlayerModelsClient.DEFAULT_CAPE;
                }
                ModelTexture mt = new ModelTexture(defLoc);
                CustomPlayerModelsClient.mc.getPlayerRenderManager().bindSubModel(this.getParentModel(), this.model, null);
                CustomPlayerModelsClient.mc.getPlayerRenderManager().bindSkin(this.model, mt, TextureSheetType.CAPE);
                if (mt.getTexture() != null) {
                    VertexConsumer buffer = bufferIn.getBuffer(mt.getRenderType());
                    this.model.setupAnim((HumanoidRenderState)state);
                    CapeTransformUtil.applyTransform(this.model);
                    CustomPlayerModelsClient.mc.getPlayerRenderManager().setModelPose(this.model);
                    this.model.renderToBuffer(poseStack, buffer, i, OverlayTexture.NO_OVERLAY);
                }
                CustomPlayerModelsClient.mc.getPlayerRenderManager().unbindModel(this.model);
            }
            cbi.cancel();
        }
    }
}

