/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.IKeybind;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.FlowLayout;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.config.ConfigChangeRequest;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.definition.SafetyException;
import com.tom.cpm.shared.editor.TestIngameManager;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.gui.FirstPersonHandPosGui;
import com.tom.cpm.shared.gui.Keybinds;
import com.tom.cpm.shared.gui.ModelPropertiesGui;
import com.tom.cpm.shared.gui.ModelsGui;
import com.tom.cpm.shared.gui.RecommendSafetySettingsPopup;
import com.tom.cpm.shared.gui.SettingsGui;
import com.tom.cpm.shared.gui.SocialGui;
import com.tom.cpm.shared.gui.gesture.BindingsInfoPopup;
import com.tom.cpm.shared.gui.gesture.GestureGuiButtons;
import com.tom.cpm.shared.gui.gesture.IGestureButton;
import com.tom.cpm.shared.gui.gesture.IGestureButtonContainer;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.network.ServerCaps;
import com.tom.cpm.shared.skin.TextureProvider;
import com.tom.cpm.shared.util.Log;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class GestureGui
extends Frame
implements IGestureButtonContainer {
    private Panel contentPanel;
    private int tickCounter;
    private ModelDefinition def;
    private ModelDefinition.ModelLoadingState state;
    private List<IGestureButton> buttons = new ArrayList<IGestureButton>();

    public GestureGui(IGui gui) {
        super(gui);
        gui.setCloseListener(r -> {
            ModConfig.getCommonConfig().save();
            r.run();
        });
        this.tickCounter = 3;
    }

    private ConfigEntry getEntryForModel(boolean make) {
        return AnimationEngine.getEntryForModel(this.def, make);
    }

    @Override
    public void updateKeybind(String keybind, String gesture, boolean mode) {
        ConfigEntry ce = this.getEntryForModel(true);
        if (gesture != null) {
            for (int j = 1; j <= 16; ++j) {
                String c = ce.getString("qa_" + j, null);
                if (c == null || !c.equals(gesture)) continue;
                ce.setString("qa_" + j, "");
            }
        }
        if (keybind != null) {
            ce.setString(keybind, gesture == null ? "" : gesture);
            ce.setString(keybind + "_mode", mode ? "hold" : "press");
        }
        this.buttons.forEach(IGestureButton::updateKeybinds);
    }

    @Override
    public void tick() {
        if (this.tickCounter > 0) {
            --this.tickCounter;
            if (TestIngameManager.isTesting() && this.gui.isShiftDown()) {
                MinecraftClientAccess.get().openGui(EditorGui::new);
                return;
            }
            if (TestIngameManager.isTesting() && this.gui.isCtrlDown()) {
                MinecraftClientAccess.get().openGui(FirstPersonHandPosGui::new);
                return;
            }
            List<ConfigChangeRequest<?, ?>> changes = MinecraftClientAccess.get().getNetHandler().getRecommendedSettingChanges();
            String server = MinecraftClientAccess.get().getConnectedServer();
            if (server != null && !changes.isEmpty()) {
                this.openPopup(new RecommendSafetySettingsPopup(this.gui, server, changes));
                this.tickCounter = 0;
            }
        }
    }

    @Override
    public void initFrame(int width, int height) {
        this.contentPanel = new Panel(this.gui);
        this.contentPanel.setBounds(new Box(0, 0, width, height));
        this.def = MinecraftClientAccess.get().getCurrentClientPlayer().getModelDefinition0();
        this.initContent(this.contentPanel);
        this.addElement(this.contentPanel);
    }

    private void initContent(Panel p) {
        String k2;
        int h;
        int width = p.getBounds().w;
        int height = p.getBounds().h;
        Log.debug(this.def);
        if (this.def != null) {
            this.state = this.def.getResolveState();
        }
        this.buttons.clear();
        MinecraftClientAccess.ServerStatus status = MinecraftClientAccess.get().getServerSideStatus();
        if (status == MinecraftClientAccess.ServerStatus.OFFLINE) {
            String str = "How did you get here?";
            Label lbl = new Label(this.gui, str);
            lbl.setBounds(new Box(width / 2 - this.gui.textWidth(str) / 2, height / 2 - 4, 0, 0));
            p.addElement(lbl);
            return;
        }
        ArrayList<CallSite> keys = new ArrayList<CallSite>();
        int i = 0;
        for (IKeybind kb : MinecraftClientAccess.get().getKeybinds()) {
            if (!kb.getName().startsWith("qa")) continue;
            ++i;
            String k3 = kb.getBoundKey();
            if (k3.isEmpty()) {
                k3 = this.gui.i18nFormat("label.cpm.key_unbound", new Object[0]);
            }
            keys.add((CallSite)((Object)(this.gui.i18nFormat("key.cpm.qa_" + i, new Object[0]) + ": " + k3)));
        }
        StringBuilder tt = new StringBuilder();
        tt.append(this.gui.i18nFormat("label.cpm.quick_key_info", new Object[0]));
        tt.append("\\");
        tt.append(this.gui.i18nFormat("tooltip.cpm.gestureQuickAccess", new Object[0]));
        tt.append("\\");
        tt.append(this.gui.i18nFormat("tooltip.cpm.gesture.valueReset", Keybinds.RESET_VALUE_LAYER.getSetKey(this.gui)));
        String bindingInfo = tt.toString();
        tt.append("\\");
        tt.append(this.gui.i18nFormat("tooltip.cpm.gesture.clickBindings", new Object[0]));
        String bindingTt = tt.toString();
        tt.setLength(0);
        tt.append(this.gui.i18nFormat("label.cpm.quick_key_short", new Object[0]) + ":");
        keys.forEach(k -> tt.append("\\" + k));
        String bindingKeys = tt.toString();
        Button bindingsButton = new Button(this.gui, this.gui.i18nFormat("button.cpm.bindingAndInfo", new Object[0]), () -> this.openPopup(new BindingsInfoPopup(this, this.gui.i18nFormat("button.cpm.bindingAndInfo", new Object[0]), bindingInfo, bindingKeys)));
        bindingsButton.setTooltip(new Tooltip(this, bindingTt));
        bindingsButton.setBounds(new Box(10, 10, 100, 20));
        p.addElement(bindingsButton);
        if (this.def != null && this.state == ModelDefinition.ModelLoadingState.LOADED && status != MinecraftClientAccess.ServerStatus.UNAVAILABLE) {
            List buttons = this.def.getAnimations().getNamedActions().stream().filter(d -> !d.isProperty() && d.canShow()).map(t -> GestureGuiButtons.make(this, t)).filter(e -> e != null).collect(Collectors.toList());
            Panel panel = new Panel(this.gui);
            if (buttons.isEmpty()) {
                String str = this.gui.i18nFormat("label.cpm.nothing_here", new Object[0]);
                Label lbl = new Label(this.gui, str);
                lbl.setBounds(new Box(width / 2 - this.gui.textWidth(str) / 2, height / 2 - 4, 0, 0));
                p.addElement(lbl);
                h = 10;
            } else {
                h = (buttons.size() / 4 + 1) * 40;
                for (int j = 0; j < buttons.size(); ++j) {
                    GuiElement b = (GuiElement)buttons.get(j);
                    panel.addElement(b);
                    b.setBounds(new Box(j % 4 * 90, j / 4 * 40, 80, 30));
                    this.buttons.add((IGestureButton)((Object)b));
                }
                if (h < height - 150) {
                    panel.setBounds(new Box(width / 2 - 180, height / 2 - h / 2, 360, h));
                    p.addElement(panel);
                } else {
                    panel.setBounds(new Box(0, 0, 360, h));
                    ScrollPanel scp = new ScrollPanel(this.gui);
                    h = height - 120;
                    scp.setBounds(new Box(width / 2 - 180, 60, 363, height - 150));
                    scp.setDisplay(panel);
                    p.addElement(scp);
                }
                this.buttons.forEach(IGestureButton::updateKeybinds);
            }
        } else if (this.def != null && (this.state == ModelDefinition.ModelLoadingState.ERRORRED || this.state == ModelDefinition.ModelLoadingState.SAFETY_BLOCKED)) {
            String txt = "";
            switch (this.state) {
                case ERRORRED: {
                    txt = this.gui.i18nFormat("label.cpm.errorLoadingModel", this.def.getError().toString());
                    break;
                }
                case SAFETY_BLOCKED: {
                    txt = this.gui.i18nFormat("label.cpm.safetyBlocked", new Object[0]);
                    break;
                }
            }
            if (this.def.getBlockReason() == SafetyException.BlockReason.UUID_LOCK) {
                txt = this.gui.i18nFormat("label.cpm.uuidBlocked", new Object[0]);
            }
            p.addElement(new Label(this.gui, txt).setBounds(new Box(width / 2 - this.gui.textWidth(txt) / 2, height / 2 - 4, 0, 0)));
            txt = this.gui.i18nFormat("label.cpm.checkErrorLog", new Object[0]);
            p.addElement(new Label(this.gui, txt).setBounds(new Box(width / 2 - this.gui.textWidth(txt) / 2, height / 2 - 4 + 10, 0, 0)));
            h = 20;
        } else if (status == MinecraftClientAccess.ServerStatus.UNAVAILABLE) {
            str = this.gui.i18nFormat("label.cpm.feature_unavailable", new Object[0]);
            lbl = new Label(this.gui, str);
            lbl.setBounds(new Box(width / 2 - this.gui.textWidth(str) / 2, height / 2 - 4, 0, 0));
            p.addElement(lbl);
            h = 10;
        } else {
            str = this.gui.i18nFormat("label.cpm.nothing_here", new Object[0]);
            lbl = new Label(this.gui, str);
            lbl.setBounds(new Box(width / 2 - this.gui.textWidth(str) / 2, height / 2 - 4, 0, 0));
            p.addElement(lbl);
            h = 10;
        }
        Panel btnPanel = new Panel(this.gui);
        btnPanel.setBounds(new Box(width / 2 - 180, height / 2 - h / 2 - 30, 360, 20));
        p.addElement(btnPanel);
        if (status != MinecraftClientAccess.ServerStatus.UNAVAILABLE) {
            Button btnRstG = new Button(this.gui, this.gui.i18nFormat("button.cpm.anim_reset_gesture", new Object[0]), this::clearGesture);
            btnRstG.setBounds(new Box(0, 0, 100, 20));
            btnPanel.addElement(btnRstG);
            Button btnRstP = new Button(this.gui, this.gui.i18nFormat("button.cpm.anim_reset_pose", new Object[0]), this::clearPose);
            btnRstP.setBounds(new Box(110, 0, 100, 20));
            btnPanel.addElement(btnRstP);
        }
        Checkbox chbxNames = new Checkbox(this.gui, this.gui.i18nFormat("button.cpm.render_name", new Object[0]));
        chbxNames.setBounds(new Box(220, 0, 70, 20));
        chbxNames.setSelected(Player.isEnableNames());
        chbxNames.setAction(() -> {
            boolean v = !chbxNames.isSelected();
            chbxNames.setSelected(v);
            Player.setEnableNames(v);
        });
        btnPanel.addElement(chbxNames);
        Panel btnPanel2 = new Panel(this.gui);
        btnPanel2.setBounds(new Box(width - 162, 0, 160, 0));
        p.addElement(btnPanel2);
        FlowLayout fl = new FlowLayout(btnPanel2, 0, 1);
        Button btnModelProperties = new Button(this.gui, this.gui.i18nFormat("button.cpm.modelProperties", new Object[0]), () -> MinecraftClientAccess.get().openGui(ModelPropertiesGui::new));
        btnModelProperties.setBounds(new Box(0, 0, 160, 20));
        if (status != MinecraftClientAccess.ServerStatus.INSTALLED || !MinecraftClientAccess.get().getNetHandler().hasServerCap(ServerCaps.GESTURES)) {
            btnModelProperties.setEnabled(false);
            btnModelProperties.setTooltip(new Tooltip(this, this.gui.i18nFormat("label.cpm.feature_unavailable", new Object[0])));
        }
        btnPanel2.addElement(btnModelProperties);
        Button btnSafety = new Button(this.gui, this.gui.i18nFormat("button.cpm.safetySettings", new Object[0]), () -> MinecraftClientAccess.get().openGui(SettingsGui::safetySettings));
        btnSafety.setBounds(new Box(0, 0, 160, 20));
        btnPanel2.addElement(btnSafety);
        Button btnSocial = new Button(this.gui, this.gui.i18nFormat("button.cpm.socialMenu", new Object[0]), () -> MinecraftClientAccess.get().openGui(SocialGui::new));
        btnSocial.setBounds(new Box(0, 0, 160, 20));
        btnPanel2.addElement(btnSocial);
        Button btnCleanCache = new Button(this.gui, this.gui.i18nFormat("button.cpm.reload_models", new Object[0]), MinecraftClientAccess.get().getDefinitionLoader()::clearCache);
        btnCleanCache.setBounds(new Box(0, 0, 160, 20));
        btnPanel2.addElement(btnCleanCache);
        IKeybind rtkb = null;
        for (IKeybind kb : MinecraftClientAccess.get().getKeybinds()) {
            if (!kb.getName().startsWith("renderToggle")) continue;
            rtkb = kb;
        }
        String string = k2 = rtkb == null ? "?" : rtkb.getBoundKey();
        if (k2.isEmpty()) {
            k2 = this.gui.i18nFormat("label.cpm.key_unbound", new Object[0]);
        }
        Checkbox chbxRender = new Checkbox(this.gui, this.gui.i18nFormat("button.cpm.render_models", k2));
        chbxRender.setBounds(new Box(0, 0, 160, 20));
        chbxRender.setSelected(Player.isEnableRendering());
        chbxRender.setAction(() -> {
            boolean v = !chbxRender.isSelected();
            chbxRender.setSelected(v);
            Player.setEnableRendering(v);
        });
        btnPanel2.addElement(chbxRender);
        fl.reflow();
        Box bp2 = btnPanel2.getBounds();
        btnPanel2.setBounds(new Box(bp2.x, height - bp2.h - 2, bp2.w, bp2.h));
        Panel btnPanel3 = new Panel(this.gui);
        btnPanel3.setBounds(new Box(0, height - 60, 160, 60));
        p.addElement(btnPanel3);
        Button btnSkinMenu = new Button(this.gui, this.gui.i18nFormat("button.cpm.models", new Object[0]), () -> MinecraftClientAccess.get().openGui(ModelsGui::new));
        btnSkinMenu.setBounds(new Box(0, 40, 160, 20));
        btnPanel3.addElement(btnSkinMenu);
        if (status != MinecraftClientAccess.ServerStatus.INSTALLED) {
            btnSkinMenu.setEnabled(false);
            btnSkinMenu.setTooltip(new Tooltip(this, this.gui.i18nFormat("label.cpm.feature_unavailable", new Object[0])));
        }
        if (TestIngameManager.isTesting()) {
            Button btnOpenEditor = new Button(this.gui, this.gui.i18nFormat("button.cpm.open_editor", new Object[0]), () -> MinecraftClientAccess.get().openGui(EditorGui::new));
            btnOpenEditor.setBounds(new Box(0, 20, 160, 20));
            btnPanel3.addElement(btnOpenEditor);
            Button btnOpenFP = new Button(this.gui, this.gui.i18nFormat("button.cpm.effect.setFpHandPos", new Object[0]), () -> MinecraftClientAccess.get().openGui(FirstPersonHandPosGui::new));
            btnOpenFP.setBounds(new Box(0, 0, 160, 20));
            btnPanel3.addElement(btnOpenFP);
        }
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        TextureProvider skin;
        super.draw(event, partialTicks);
        ModelDefinition def = MinecraftClientAccess.get().getCurrentClientPlayer().getModelDefinition0();
        if (def != this.def || def != null && def.getResolveState() != this.state) {
            this.contentPanel.getElements().clear();
            this.def = def;
            this.initContent(this.contentPanel);
        }
        if (MinecraftObjectHolder.DEBUGGING && this.gui.isAltDown() && def != null && (skin = def.getTexture(TextureSheetType.SKIN, true)) != null && skin.texture != null) {
            skin.bind();
            int size = Math.min(this.bounds.w, this.bounds.h);
            this.gui.drawText(514, 2, "Stitched: " + def.isStitchedTexture(), -1);
            this.gui.drawBox(0, 0, size, size, -5592406);
            this.gui.drawTexture(0, 0, size, size, 0.0f, 0.0f, 1.0f, 1.0f);
        }
    }

    @Override
    public IGui gui() {
        return this.gui;
    }

    private void clearGesture() {
        if (this.def != null) {
            MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().clearGesture(this.def);
        }
    }

    private void clearPose() {
        if (this.def != null) {
            MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().clearCustomPose(this.def);
        }
    }

    @Override
    public IGestureButtonContainer.BoundKeyInfo getBoundKey(String id) {
        ConfigEntry ce = this.getEntryForModel(false);
        for (IKeybind kb : MinecraftClientAccess.get().getKeybinds()) {
            String c;
            if (!kb.getName().startsWith("qa") || (c = ce.getString(kb.getName(), null)) == null || !c.equals(id)) continue;
            String kbn = kb.getName();
            String kbMode = ce.getString(kb.getName() + "_mode", "press");
            String k = kb.getBoundKey();
            if (k.isEmpty()) {
                k = null;
            }
            return new IGestureButtonContainer.BoundKeyInfo(kbn, kbMode, k);
        }
        return null;
    }

    @Override
    public void valueChanged() {
    }

    @Override
    public boolean canBindKeys() {
        return true;
    }
}

