/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts.anim.menu;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.parts.anim.AnimLoaderState;
import com.tom.cpm.shared.parts.anim.menu.CommandAction;
import com.tom.cpm.shared.parts.anim.menu.GestureButtonType;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractGestureButtonData {
    protected String name;
    protected ModelDefinition def;

    public static void parse(IOHelper block, AnimLoaderState state) throws IOException {
        GestureButtonType type = (GestureButtonType)block.readEnum(GestureButtonType.values());
        AbstractGestureButtonData dt = type.create();
        dt.def = state.getDefinition();
        dt.parseData(block, state);
        state.addGestureButton(dt);
    }

    protected void parseData(IOHelper block, AnimLoaderState state) throws IOException {
        this.name = block.readUTF();
    }

    public void write(IOHelper block) throws IOException {
        block.writeUTF(this.name);
    }

    public abstract GestureButtonType getType();

    public boolean isProperty() {
        return false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDef(ModelDefinition def) {
        this.def = def;
    }

    public String getName() {
        return this.name;
    }

    public Set<CommandAction> getCommandActions() {
        return Collections.emptySet();
    }

    public boolean canShow() {
        return true;
    }

    public String getKeybindId() {
        return null;
    }

    public void loadFrom(ConfigEntry ce) {
    }

    public void storeTo(ConfigEntry ce) {
    }

    public void onRegistered() {
    }

    public ModelDefinition getDefinition() {
        return this.def;
    }

    public void onKeybind(String arg, boolean press, boolean toggleMode) {
    }

    public static abstract class AbstractCommandTriggerableData
    extends AbstractGestureButtonData {
        public static final int LAYER_CTRL = 1;
        public static final int COMMAND_CTRL = 2;
        public static final int PROPERTY = 4;
        public static final int CONDITIONAL = 8;
        public static final int HIDDEN = 16;
        public boolean isProperty;
        public boolean command;
        public boolean layerCtrl;
        public boolean hidden;
        protected Set<CommandAction> commandActions = new HashSet<CommandAction>();

        @Override
        protected void parseData(IOHelper block, AnimLoaderState state) throws IOException {
            super.parseData(block, state);
            int flags = block.read();
            this.command = (flags & 2) != 0;
            this.layerCtrl = (flags & 1) != 0;
            this.isProperty = (flags & 4) != 0;
            this.hidden = (flags & 0x10) != 0;
        }

        @Override
        public void write(IOHelper block) throws IOException {
            super.write(block);
            int flags = 0;
            if (this.layerCtrl) {
                flags |= 1;
            }
            if (this.command) {
                flags |= 2;
            }
            if (this.isProperty) {
                flags |= 4;
            }
            if (this.hidden) {
                flags |= 0x10;
            }
            block.write(flags);
        }

        @Override
        public boolean isProperty() {
            return this.isProperty;
        }

        @Override
        public boolean canShow() {
            return !this.command && !this.hidden;
        }

        @Override
        public Set<CommandAction> getCommandActions() {
            return this.commandActions;
        }
    }
}

