/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.blaze3d.platform.TextureUtil;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.ImageIO;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import net.minecraft.class_1011;
import org.lwjgl.stb.STBIWriteCallback;
import org.lwjgl.stb.STBIWriteCallbackI;
import org.lwjgl.stb.STBImage;
import org.lwjgl.stb.STBImageWrite;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class NativeImageIO
implements ImageIO.IImageIO {
    @Override
    public Image read(File f) throws IOException {
        try (FileInputStream fi = new FileInputStream(f);){
            Image image = this.read(fi);
            return image;
        }
    }

    @Override
    public Image read(InputStream f) throws IOException {
        try (class_1011 ni = class_1011.method_4309((InputStream)f);){
            Image i = new Image(ni.method_4307(), ni.method_4323());
            for (int y = 0; y < ni.method_4323(); ++y) {
                for (int x = 0; x < ni.method_4307(); ++x) {
                    int rgb = ni.method_4315(x, y);
                    int a = rgb >> 24 & 0xFF;
                    int b = rgb >> 16 & 0xFF;
                    int g = rgb >> 8 & 0xFF;
                    int r = rgb & 0xFF;
                    i.setRGB(x, y, a << 24 | r << 16 | g << 8 | b);
                }
            }
            Image image = i;
            return image;
        }
    }

    @Override
    public void write(Image img, File f) throws IOException {
        try (class_1011 i = NativeImageIO.createFromBufferedImage(img);){
            i.method_4325(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Image img, OutputStream f) throws IOException {
        WriteCallback wc = new WriteCallback(Channels.newChannel(f));
        try (class_1011 ni = NativeImageIO.createFromBufferedImage(img);){
            if (!STBImageWrite.stbi_write_png_to_func((STBIWriteCallbackI)wc, (long)0L, (int)ni.method_4307(), (int)ni.method_4323(), (int)ni.method_4318().method_4335(), (ByteBuffer)MemoryUtil.memByteBuffer((long)ni.field_4988, (int)ni.field_4987), (int)0)) {
                throw new IOException("Could not write image: " + STBImage.stbi_failure_reason());
            }
        }
        finally {
            wc.free();
        }
        wc.throwIfException();
    }

    /*
     * Loose catch block
     */
    @Override
    public Vec2i getSize(InputStream din) throws IOException {
        Vec2i vec2i;
        MemoryStack memorystack;
        ByteBuffer byteBufferIn;
        block9: {
            byteBufferIn = null;
            memorystack = MemoryStack.stackPush();
            byteBufferIn = TextureUtil.readResource((InputStream)din);
            ((Buffer)byteBufferIn).rewind();
            IntBuffer intbuffer = memorystack.mallocInt(1);
            IntBuffer intbuffer1 = memorystack.mallocInt(1);
            IntBuffer intbuffer2 = memorystack.mallocInt(1);
            if (!STBImage.stbi_info_from_memory((ByteBuffer)byteBufferIn, (IntBuffer)intbuffer, (IntBuffer)intbuffer1, (IntBuffer)intbuffer2)) {
                throw new IOException("Could not load image: " + STBImage.stbi_failure_reason());
            }
            vec2i = new Vec2i(intbuffer.get(0), intbuffer1.get(0));
            if (memorystack == null) break block9;
            memorystack.close();
        }
        MemoryUtil.memFree((Buffer)byteBufferIn);
        return vec2i;
        {
            catch (Throwable throwable) {
                try {
                    if (memorystack != null) {
                        try {
                            memorystack.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    MemoryUtil.memFree(byteBufferIn);
                    throw throwable3;
                }
            }
        }
    }

    public static class_1011 createFromBufferedImage(Image texture) {
        class_1011 ni = new class_1011(texture.getWidth(), texture.getHeight(), false);
        for (int y = 0; y < texture.getHeight(); ++y) {
            for (int x = 0; x < texture.getWidth(); ++x) {
                int rgb = texture.getRGB(x, y);
                int a = rgb >> 24 & 0xFF;
                int r = rgb >> 16 & 0xFF;
                int g = rgb >> 8 & 0xFF;
                int b = rgb & 0xFF;
                ni.method_4305(x, y, a << 24 | b << 16 | g << 8 | r);
            }
        }
        return ni;
    }

    static class WriteCallback
    extends STBIWriteCallback {
        private final WritableByteChannel output;
        private IOException exception;

        private WriteCallback(WritableByteChannel p_i49388_1_) {
            this.output = p_i49388_1_;
        }

        public void invoke(long p_invoke_1_, long p_invoke_3_, int p_invoke_5_) {
            ByteBuffer bytebuffer = WriteCallback.getData((long)p_invoke_3_, (int)p_invoke_5_);
            try {
                this.output.write(bytebuffer);
            }
            catch (IOException ioexception) {
                this.exception = ioexception;
            }
        }

        public void throwIfException() throws IOException {
            if (this.exception != null) {
                throw this.exception;
            }
        }
    }
}

