/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.platform.GlStateManager;
import com.tom.cpl.math.Vec4f;
import com.tom.cpl.render.DirectBuffer;
import com.tom.cpl.render.VBuffers;
import com.tom.cpl.render.VertexBuffer;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.Platform;
import com.tom.cpm.shared.retro.RetroGLAccess;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class RetroGL
implements RetroGLAccess<class_2960> {
    private static final RenderStage lines = new RenderStage(true, false, false, () -> {
        GlStateManager.disableDepthTest();
        GlStateManager.disableTexture();
    }, () -> {
        GlStateManager.enableTexture();
        GlStateManager.enableDepthTest();
    }, 1, class_290.field_1576);
    private static final RenderStage color = new RenderStage(true, false, false, () -> GlStateManager.disableTexture(), () -> GlStateManager.enableTexture(), 7, class_290.field_1576);
    private static float lx;
    private static float ly;

    public RenderStage texture(class_2960 rl) {
        return new RenderStage(true, true, true, () -> RetroGL.bindTex(rl), () -> {}, 7, class_290.field_1577);
    }

    public RenderStage eyes(class_2960 rl) {
        return new RenderStage(true, true, true, () -> {
            lx = Platform.lastBrightnessX();
            ly = Platform.lastBrightnessY();
            GlStateManager.enableBlend();
            GlStateManager.disableAlphaTest();
            GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.depthMask((boolean)true);
            int i = 240;
            int j = i % 65536;
            int k = i / 65536;
            GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)j, (float)k);
            class_310.method_1551().field_1773.method_3201(true);
            RetroGL.bindTex(rl);
        }, () -> {
            class_310.method_1551().field_1773.method_3201(false);
            GLX.glMultiTexCoord2f((int)GLX.GL_TEXTURE1, (float)lx, (float)ly);
            GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.enableAlphaTest();
        }, 7, class_290.field_1577);
    }

    @Override
    public RenderStage linesNoDepth() {
        return lines;
    }

    @Override
    public RenderStage color() {
        return color;
    }

    private static void bindTex(class_2960 tex) {
        if (tex != null) {
            class_310.method_1551().method_1531().method_4618(tex);
        }
    }

    public static VertexBuffer buffer(VBuffers.NativeRenderType type) {
        RenderStage stage = (RenderStage)type.getNativeType();
        return new RetroBuffer(class_289.method_1348(), stage);
    }

    public static Vec4f getColor() {
        GlStateManager.class_1020 c = GlStateManager.COLOR;
        return new Vec4f(RetroGL.val(c.field_5057), RetroGL.val(c.field_5056), RetroGL.val(c.field_5055), RetroGL.val(c.field_5054));
    }

    private static float val(float color) {
        return color == -1.0f ? 1.0f : color;
    }

    @Override
    public class_2960 getDynTexture() {
        return MinecraftObject.DynTexture.getBoundLoc();
    }

    private static class RenderStage
    implements RetroGLAccess.RetroLayer {
        private boolean color;
        private boolean texture;
        private boolean normal;
        private Runnable begin;
        private Runnable end;
        private int glMode;
        private class_293 format;

        public RenderStage(boolean color, boolean texture, boolean normal, Runnable begin, Runnable end, int glMode, class_293 format) {
            this.color = color;
            this.texture = texture;
            this.normal = normal;
            this.begin = begin;
            this.end = end;
            this.glMode = glMode;
            this.format = format;
        }

        public void begin(class_287 buf) {
            this.begin.run();
            buf.method_1328(this.glMode, this.format);
        }

        public void end() {
            this.end.run();
        }
    }

    private static class RetroBuffer
    extends DirectBuffer<class_287> {
        private RenderStage stage;
        private class_289 tes;

        public RetroBuffer(class_289 tes, RenderStage stage) {
            super(tes.method_1349());
            this.tes = tes;
            this.stage = stage;
            stage.begin((class_287)this.buffer);
        }

        @Override
        protected void pushVertex(float x, float y, float z, float red, float green, float blue, float alpha, float u, float v, float nx, float ny, float nz) {
            ((class_287)this.buffer).method_1315((double)x, (double)y, (double)z);
            if (this.stage.texture) {
                ((class_287)this.buffer).method_1312((double)u, (double)v);
            }
            if (this.stage.color) {
                ((class_287)this.buffer).method_1336(red, green, blue, alpha);
            }
            if (this.stage.normal) {
                ((class_287)this.buffer).method_1318(nx, ny, nz);
            }
            ((class_287)this.buffer).method_1344();
        }

        @Override
        public void finish() {
            this.tes.method_1350();
            this.stage.end();
        }
    }
}

