/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.command;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.tom.cpl.command.AbstractCommandBuilder;
import com.tom.cpl.command.ArgType;
import com.tom.cpl.command.CommandCtx;
import com.tom.cpl.command.CommandHandler;
import com.tom.cpl.command.LiteralCommandBuilder;
import com.tom.cpl.command.RequiredCommandBuilder;
import com.tom.cpl.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public abstract class StringCommandHandler<S, CS, CE extends Exception>
implements CommandHandler<CS> {
    private final Consumer<CommandImpl> register;

    public StringCommandHandler(Consumer<CommandImpl> register, boolean client) {
        this.register = register;
        if (client) {
            this.registerClient();
        } else {
            this.registerCommon();
        }
    }

    @Override
    public void register(LiteralCommandBuilder builder, boolean isOp) {
        this.register.accept(new CommandImpl(builder, isOp));
    }

    public abstract CE generic(String var1, Object ... var2);

    public abstract CE wrongUsage(String var1, Object ... var2);

    public abstract Object getPlayerObj(S var1, CS var2, String var3) throws CE;

    public abstract CE checkExc(Exception var1);

    public abstract List<String> getOnlinePlayers(S var1);

    public static List<String> getListOfStringsMatchingLastWord(String[] inputArgs, Collection<?> possibleCompletions) {
        String s = inputArgs[inputArgs.length - 1];
        ArrayList list = Lists.newArrayList();
        if (!possibleCompletions.isEmpty()) {
            for (String s1 : Iterables.transform(possibleCompletions, (Function)Functions.toStringFunction())) {
                if (!StringCommandHandler.doesStringStartWith(s, s1)) continue;
                list.add(s1);
            }
        }
        return list;
    }

    public static boolean doesStringStartWith(String original, String region) {
        return region.regionMatches(true, 0, original, 0, original.length());
    }

    public class CommandImpl {
        private final LiteralCommandBuilder root;
        private final boolean isOp;

        public CommandImpl(LiteralCommandBuilder root, boolean isOp) {
            this.root = root;
            this.isOp = isOp;
        }

        public String getName() {
            return this.root.getName();
        }

        private StringCtx parseCommand(S server, CS sender, String[] args) throws Exception {
            StringCtx ctx = new StringCtx(sender);
            AbstractCommandBuilder e = this.root;
            LiteralCommandBuilder prev = null;
            block13: for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (e == prev) {
                    throw StringCommandHandler.this.wrongUsage("commands.generic.parameter.invalid", arg);
                }
                prev = e;
                for (AbstractCommandBuilder<?> next : e.getNext()) {
                    if (next instanceof LiteralCommandBuilder) {
                        LiteralCommandBuilder l = (LiteralCommandBuilder)next;
                        if (!arg.equals(l.getName())) continue;
                        e = next;
                        continue block13;
                    }
                    if (!(next instanceof RequiredCommandBuilder)) continue;
                    RequiredCommandBuilder r = (RequiredCommandBuilder)next;
                    switch (r.getType()) {
                        case PLAYER: {
                            try {
                                Object pl = StringCommandHandler.this.getPlayerObj(server, sender, arg);
                                e = next;
                                ctx.arg(r.getId(), pl);
                            }
                            catch (Exception exc) {
                                ctx.lastExc = StringCommandHandler.this.checkExc(exc);
                            }
                            break;
                        }
                        case BOOLEAN: {
                            if (arg.equalsIgnoreCase("true")) {
                                e = next;
                                ctx.arg(r.getId(), true);
                                break;
                            }
                            if (arg.equalsIgnoreCase("false")) {
                                e = next;
                                ctx.arg(r.getId(), false);
                                break;
                            }
                            ctx.lastExc = StringCommandHandler.this.wrongUsage("commands.generic.boolean.invalid", arg);
                            break;
                        }
                        case INT: {
                            Pair p;
                            try {
                                int v = Integer.parseInt(arg);
                                if (r.getSettings() != null) {
                                    p = (Pair)r.getSettings();
                                    if (v < (Integer)p.getKey()) {
                                        throw StringCommandHandler.this.wrongUsage("commands.generic.num.tooSmall", v);
                                    }
                                    if (v > (Integer)p.getValue()) {
                                        throw StringCommandHandler.this.wrongUsage("commands.generic.num.tooBig", v);
                                    }
                                }
                                ctx.arg(r.getId(), v);
                                e = next;
                            }
                            catch (NumberFormatException num) {
                                ctx.lastExc = StringCommandHandler.this.wrongUsage("commands.generic.num.invalid", arg);
                            }
                            break;
                        }
                        case FLOAT: {
                            Pair p;
                            try {
                                float v = Float.parseFloat(arg);
                                if (r.getSettings() != null) {
                                    p = (Pair)r.getSettings();
                                    if (v < ((Float)p.getKey()).floatValue()) {
                                        throw StringCommandHandler.this.wrongUsage("commands.generic.num.tooSmall", Float.valueOf(v));
                                    }
                                    if (v > ((Float)p.getValue()).floatValue()) {
                                        throw StringCommandHandler.this.wrongUsage("commands.generic.num.tooBig", Float.valueOf(v));
                                    }
                                }
                                ctx.arg(r.getId(), Float.valueOf(v));
                                e = next;
                            }
                            catch (NumberFormatException num) {
                                ctx.lastExc = StringCommandHandler.this.wrongUsage("commands.generic.num.invalid", arg);
                            }
                            break;
                        }
                        case STRING: {
                            StringBuilder b;
                            boolean normalString;
                            boolean bl = normalString = r.getSettings() == null || (Boolean)r.getSettings() == false;
                            if (!normalString) {
                                b = new StringBuilder(arg);
                                ++i;
                                while (i < args.length) {
                                    b.append(' ');
                                    b.append(args[i]);
                                    ++i;
                                }
                                e = next;
                                ctx.arg(r.getId(), b.toString());
                                break;
                            }
                            if (arg.startsWith("\"")) {
                                b = new StringBuilder(arg);
                                ++i;
                                while (i < args.length) {
                                    b.append(' ');
                                    b.append(args[i]);
                                    if (args[i].endsWith("\"")) break;
                                    ++i;
                                }
                                e = next;
                                ctx.arg(r.getId(), b.substring(1, b.length() - 1));
                                break;
                            }
                            e = next;
                            ctx.arg(r.getId(), arg);
                            break;
                        }
                        default: {
                            e = next;
                            ctx.arg(r.getId(), arg);
                        }
                    }
                    if (e != next) continue;
                    continue block13;
                }
            }
            ctx.node = e;
            return ctx;
        }

        public void execute(S server, CS sender, String[] args) throws Exception {
            StringCtx ctx = this.parseCommand(server, sender, args);
            if (ctx.node.getFunc() != null) {
                ctx.node.getFunc().accept(ctx);
                if (ctx.getFail() != null) {
                    throw StringCommandHandler.this.generic("commands." + this.getName() + ".genericFail", ctx.getFail().remap());
                }
            } else {
                if (ctx.lastExc != null) {
                    throw ctx.lastExc;
                }
                throw StringCommandHandler.this.wrongUsage("commands." + this.getName() + ".usage", new Object[0]);
            }
        }

        public List<String> getTabCompletions(S server, CS sender, String[] args) {
            StringCtx ctx;
            try {
                ctx = this.parseCommand(server, sender, Arrays.copyOf(args, Math.max(0, args.length - 1)));
            }
            catch (Exception e) {
                return Collections.emptyList();
            }
            ArrayList<Object> compl = new ArrayList<Object>();
            for (AbstractCommandBuilder<?> next : ctx.node.getNext()) {
                if (next instanceof LiteralCommandBuilder) {
                    compl.add(((LiteralCommandBuilder)next).getName());
                    continue;
                }
                if (!(next instanceof RequiredCommandBuilder)) continue;
                RequiredCommandBuilder r = (RequiredCommandBuilder)next;
                if (r.getPossibleValues() != null) {
                    List<String> s = r.getPossibleValues().apply(ctx);
                    for (String string : s) {
                        if (string.contains(" ")) {
                            compl.add("\"" + string + "\"");
                            continue;
                        }
                        compl.add(string);
                    }
                    break;
                }
                if (r.getType() == ArgType.PLAYER) {
                    compl.addAll(StringCommandHandler.this.getOnlinePlayers(server));
                    break;
                }
                if (r.getType() != ArgType.BOOLEAN) break;
                compl.add("true");
                compl.add("false");
                break;
            }
            return StringCommandHandler.getListOfStringsMatchingLastWord(args, compl);
        }

        public boolean isOp() {
            return this.isOp;
        }
    }

    private class StringCtx
    extends CommandCtx<CS> {
        private AbstractCommandBuilder<?> node;
        private CE lastExc;

        public StringCtx(CS sender) {
            super(sender, StringCommandHandler.this);
        }
    }
}

