/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.mojang.brigadier.CommandDispatcher;
import com.tom.cpm.common.Command;
import com.tom.cpm.common.ServerHandlerBase;
import com.tom.cpm.shared.network.NetH;
import com.tom.cpm.shared.network.NetHandler;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ServerHandler
extends ServerHandlerBase {
    public static NetHandler<ResourceLocation, ServerPlayer, ServerGamePacketListenerImpl> netHandler = ServerHandler.init();

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        netHandler.onJoin((ServerPlayer)evt.getEntity());
    }

    @SubscribeEvent
    public void onTrackingStart(PlayerEvent.StartTracking evt) {
        ServerGamePacketListenerImpl handler = ((ServerPlayer)evt.getEntity()).f_8906_;
        NetH h = (NetH)handler;
        if (h.cpm$hasMod() && evt.getTarget() instanceof Player) {
            netHandler.sendPlayerData((ServerPlayer)evt.getTarget(), (ServerPlayer)evt.getEntity());
        }
    }

    @SubscribeEvent
    public void registerCommands(RegisterCommandsEvent evt) {
        CommandDispatcher d = evt.getDispatcher();
        new Command((CommandDispatcher<CommandSourceStack>)d, false);
    }

    @SubscribeEvent
    public void onRespawn(PlayerEvent.PlayerRespawnEvent evt) {
        if (!evt.isEndConquered()) {
            netHandler.onRespawn((ServerPlayer)evt.getEntity());
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END) {
            netHandler.tick();
        }
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent evt) {
        if (evt.getEntity() instanceof ServerPlayer) {
            netHandler.onJump((ServerPlayer)evt.getEntity());
        }
    }

    static {
        netHandler.setGetOnlinePlayers(() -> ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_());
        netHandler.setExecutor(ServerLifecycleHooks::getCurrentServer);
        if (ModList.get().isLoaded("pehkui")) {
            // empty if block
        }
    }
}

