/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.model;

import com.tom.cpl.math.Rotation;
import com.tom.cpl.math.Vec3f;
import com.tom.cpm.shared.model.RenderedCube;

public class CopyTransform {
    private final RenderedCube from;
    private final RenderedCube to;
    private final boolean copyPX;
    private final boolean copyPY;
    private final boolean copyPZ;
    private final boolean copyRX;
    private final boolean copyRY;
    private final boolean copyRZ;
    private final boolean copySX;
    private final boolean copySY;
    private final boolean copySZ;
    private final boolean copyVis;
    private final boolean copyColor;
    private final boolean additive;
    private final float multiply;

    public CopyTransform(RenderedCube from, RenderedCube to, short copy, float multiply) {
        this.from = from;
        this.to = to;
        this.copyPX = (copy & 1) != 0;
        this.copyPY = (copy & 2) != 0;
        this.copyPZ = (copy & 4) != 0;
        this.copyRX = (copy & 8) != 0;
        this.copyRY = (copy & 0x10) != 0;
        this.copyRZ = (copy & 0x20) != 0;
        this.copySX = (copy & 0x40) != 0;
        this.copySY = (copy & 0x80) != 0;
        this.copySZ = (copy & 0x100) != 0;
        this.copyVis = (copy & 0x200) != 0;
        this.copyColor = (copy & 0x400) != 0;
        this.additive = (copy & 0x800) != 0;
        this.multiply = multiply;
    }

    public void apply() {
        Vec3f st;
        Rotation rt;
        Vec3f pt;
        Vec3f pf = this.from.getTransformPosition();
        Rotation rf = this.from.getTransformRotation();
        Vec3f sf = this.from.getRenderScale();
        if (this.additive) {
            pt = Vec3f.ZERO;
            rt = Rotation.ZERO;
            st = Vec3f.ZERO;
        } else {
            pt = this.to.getTransformPosition();
            rt = this.to.getTransformRotation();
            st = this.to.getRenderScale();
        }
        this.to.setPosition(this.additive, this.copyPX ? pf.x * this.multiply : pt.x, this.copyPY ? pf.y * this.multiply : pt.y, this.copyPZ ? pf.z * this.multiply : pt.z);
        this.to.setRotation(this.additive, this.copyRX ? rf.x * this.multiply : rt.x, this.copyRY ? rf.y * this.multiply : rt.y, this.copyRZ ? rf.z * this.multiply : rt.z);
        this.to.setRenderScale(this.additive, this.copySX ? sf.x * this.multiply : st.x, this.copySY ? sf.y * this.multiply : st.y, this.copySZ ? sf.z * this.multiply : st.z);
        if (this.copyVis) {
            this.to.setVisible(this.from.isVisible());
        }
        if (this.copyColor) {
            this.to.setColor(this.from.getRGB());
        }
    }
}

