/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui.elements;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;

public class ButtonIconToggle
extends Button {
    private String name;
    private int u;
    private int v;
    private boolean tintIcon;
    private boolean selected;

    public ButtonIconToggle(IGui gui, String name, int u, int v, Runnable action) {
        super(gui, "", action);
        this.name = name;
        this.u = u;
        this.v = v;
    }

    public ButtonIconToggle(IGui gui, String name, int u, int v, boolean tintIcon, Runnable action) {
        super(gui, "", action);
        this.name = name;
        this.u = u;
        this.v = v;
        this.tintIcon = tintIcon;
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        int bgColor = this.gui.getColors().button_fill;
        int color = this.gui.getColors().button_text_color;
        if (!this.enabled || this.selected) {
            color = this.gui.getColors().button_text_disabled;
            bgColor = this.gui.getColors().button_disabled;
        } else if (event.isHovered(this.bounds)) {
            color = this.gui.getColors().button_text_hover;
            bgColor = this.gui.getColors().button_hover;
        }
        if (event.isHovered(this.bounds) && this.tooltip != null) {
            this.tooltip.set();
        }
        this.gui.drawBox(this.bounds.x, this.bounds.y, this.bounds.w, this.bounds.h, this.gui.getColors().button_border);
        this.gui.drawBox(this.bounds.x + 1, this.bounds.y + 1, this.bounds.w - 2, this.bounds.h - 2, bgColor);
        if (this.tintIcon) {
            this.gui.drawTexture(this.bounds.x + 2, this.bounds.y + 2, this.bounds.w - 4, this.bounds.h - 4, this.u, this.v, this.name, color);
        } else {
            this.gui.drawTexture(this.bounds.x + 2, this.bounds.y + 2, this.bounds.w - 4, this.bounds.h - 4, this.u, this.v, this.name);
        }
    }

    public void setU(int u) {
        this.u = u;
    }

    public void setV(int v) {
        this.v = v;
    }

    public int getU() {
        return this.u;
    }

    public int getV() {
        return this.v;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }
}

