/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftProfileTextures;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.tom.cpl.block.entity.ActiveEffect;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.util.Hand;
import com.tom.cpl.util.HandAnimation;
import com.tom.cpm.client.FirstPersonDetector;
import com.tom.cpm.client.MannequinAccess;
import com.tom.cpm.client.Platform;
import com.tom.cpm.common.EntityTypeHandlerImpl;
import com.tom.cpm.common.PlayerInventory;
import com.tom.cpm.common.WorldImpl;
import com.tom.cpm.mixinplugin.FPMDetector;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.render.PlayerModelSetup;
import com.tom.cpm.shared.skin.PlayerTextureLoader;
import com.tom.cpm.shared.skin.TextureType;
import java.io.File;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import net.minecraft.class_10055;
import net.minecraft.class_1068;
import net.minecraft.class_11786;
import net.minecraft.class_11890;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1664;
import net.minecraft.class_1747;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_2190;
import net.minecraft.class_310;
import net.minecraft.class_4050;
import net.minecraft.class_591;
import net.minecraft.class_634;
import net.minecraft.class_640;
import net.minecraft.class_742;
import net.minecraft.class_7923;
import net.minecraft.class_9334;

public class PlayerProfile
extends Player<class_11890> {
    public static boolean inGui;
    public static BooleanSupplier inFirstPerson;
    private final GameProfile profile;
    private String skinType;

    public static GameProfile getPlayerProfile(class_11890 avatar) {
        MannequinAccess man;
        class_11786.class_11787 info;
        if (avatar == null) {
            return null;
        }
        if (avatar instanceof class_742) {
            class_640 info2;
            class_634 conn;
            class_742 player = (class_742)avatar;
            GameProfile profile = player.method_7334();
            if (profile.properties().isEmpty() && (conn = class_310.method_1551().method_1562()) != null && (info2 = conn.method_2871(profile.id())) != null) {
                profile = info2.method_2966();
            }
            return profile;
        }
        if (avatar instanceof MannequinAccess && (info = (man = (MannequinAccess)avatar).cpm$getInfo()) != null) {
            return info.method_73502();
        }
        return new GameProfile(avatar.method_5667(), avatar.method_5820());
    }

    public PlayerProfile(GameProfile profile) {
        this.profile = new GameProfile(profile.id(), profile.name(), new PropertyMap(PlayerProfile.cloneProperties(profile.properties())));
        if (profile.id() != null) {
            this.skinType = class_1068.method_4648((UUID)profile.id()).comp_1629().method_15434();
        }
    }

    @Override
    public SkinType getSkinType() {
        return SkinType.get(this.skinType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.profile == null ? 0 : this.profile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlayerProfile other = (PlayerProfile)obj;
        return !(this.profile == null ? other.profile != null : !this.profile.equals((Object)other.profile));
    }

    @Override
    public UUID getUUID() {
        return this.profile.id();
    }

    @Override
    public void updateFromPlayer(class_11890 player) {
        float f1;
        class_1799 is;
        class_4050 p = player.method_18376();
        this.animState.resetPlayer();
        switch (p) {
            case field_18077: {
                this.animState.elytraFlying = true;
                break;
            }
            case field_18078: {
                this.animState.sleeping = true;
                break;
            }
            case field_18080: {
                this.animState.tridentSpin = true;
                break;
            }
        }
        this.animState.sneaking = player.method_18276();
        this.animState.crawling = player.method_20448();
        this.animState.swimming = player.method_20232();
        if (!player.method_5805()) {
            this.animState.dying = true;
        }
        if (Platform.isSitting(player)) {
            this.animState.riding = true;
        }
        if (player.method_5624()) {
            this.animState.sprinting = true;
        }
        if (player.method_6115()) {
            this.animState.usingAnimation = HandAnimation.of(player.method_6030().method_7976());
        }
        if (player.method_5799()) {
            this.animState.retroSwimming = true;
        }
        this.animState.moveAmountX = (float)(player.method_23317() - player.field_6014);
        this.animState.moveAmountY = (float)(player.method_23318() - player.field_6036);
        this.animState.moveAmountZ = (float)(player.method_23321() - player.field_5969);
        this.animState.yaw = player.method_36454();
        this.animState.pitch = player.method_36455();
        this.animState.bodyYaw = player.field_6283;
        if (player.method_74091(class_1664.field_7563)) {
            this.animState.encodedState |= 1;
        }
        if (player.method_74091(class_1664.field_7564)) {
            this.animState.encodedState |= 2;
        }
        if (player.method_74091(class_1664.field_7566)) {
            this.animState.encodedState |= 4;
        }
        if (player.method_74091(class_1664.field_7565)) {
            this.animState.encodedState |= 8;
        }
        if (player.method_74091(class_1664.field_7568)) {
            this.animState.encodedState |= 0x10;
        }
        if (player.method_74091(class_1664.field_7570)) {
            this.animState.encodedState |= 0x20;
        }
        this.animState.hasSkullOnHead = (is = player.method_6118(class_1304.field_6169)).method_7909() instanceof class_1747 && ((class_1747)is.method_7909()).method_7711() instanceof class_2190;
        this.animState.wearingHelm = !is.method_7960();
        is = player.method_6118(class_1304.field_6174);
        this.animState.wearingElytra = is.method_58694(class_9334.field_54197) != null;
        this.animState.wearingBody = !is.method_7960();
        this.animState.wearingLegs = !player.method_6118(class_1304.field_6172).method_7960();
        this.animState.wearingBoots = !player.method_6118(class_1304.field_6166).method_7960();
        this.animState.mainHand = Hand.of(player.method_6068());
        this.animState.activeHand = Hand.of(this.animState.mainHand, player.method_6058());
        this.animState.swingingHand = Hand.of(this.animState.mainHand, player.field_6266);
        this.animState.hurtTime = player.field_6235;
        this.animState.isOnLadder = player.method_6101();
        this.animState.isBurning = player.method_5862();
        this.animState.isFreezing = player.method_32312() > 0;
        this.animState.inGui = inGui;
        this.animState.firstPersonMod = inFirstPerson.getAsBoolean();
        if (player instanceof class_742) {
            class_742 pl = (class_742)player;
            PlayerInventory.setInv(this.animState, pl.method_31548());
        }
        WorldImpl.setWorld(this.animState, (class_1297)player);
        if (player.method_5854() != null) {
            this.animState.vehicle = EntityTypeHandlerImpl.impl.wrap(player.method_5854().method_5864());
        }
        player.method_6026().forEach(e -> this.animState.allEffects.add(new ActiveEffect(class_7923.field_41174.method_10221((Object)((class_1291)e.method_5579().comp_349())).toString(), e.method_5578(), e.method_5584(), !e.method_5581())));
        if (player.method_6030().method_7909() instanceof class_1764) {
            float f = class_1764.method_7775((class_1799)player.method_6030(), (class_1309)player);
            f1 = MathHelper.clamp((float)player.method_6048(), 0.0f, f);
            this.animState.crossbowPullback = f1 / f;
        }
        if (player.method_6030().method_7909() instanceof class_1753) {
            float f = 20.0f;
            f1 = MathHelper.clamp((float)player.method_6048(), 0.0f, f);
            this.animState.bowPullback = f1 / f;
        }
    }

    @Override
    public void updateFromModel(Object model) {
        if (model instanceof class_591) {
            this.animState.vrState = null;
        }
    }

    public void updateFromState(class_10055 state) {
        this.animState.resetModel();
        this.animState.attackTime = state.field_63604;
        this.animState.swimAmount = state.field_53403;
        this.animState.leftArm = PlayerModelSetup.ArmPose.of(state.field_55306);
        this.animState.rightArm = PlayerModelSetup.ArmPose.of(state.field_55304);
        this.animState.parrotLeft = state.field_53526 != null;
        this.animState.parrotRight = state.field_53527 != null;
    }

    @Override
    protected PlayerTextureLoader initTextures() {
        File cache = class_310.method_1551().method_1582().field_45635.field_45640.toFile();
        return new PlayerTextureLoader(cache){

            @Override
            protected CompletableFuture<Void> load0() {
                return CompletableFuture.supplyAsync(() -> {
                    class_310 mc = class_310.method_1551();
                    MinecraftSessionService mss = mc.method_73361().comp_837();
                    Property pt = mss.getPackedTextures(PlayerProfile.this.profile);
                    if (pt == null) {
                        return MinecraftProfileTextures.EMPTY;
                    }
                    MinecraftProfileTextures mpts = mss.unpackTextures(pt);
                    return mpts;
                }, class_156.method_18349().method_64116("CPM:unpackSkinTextures")).thenAcceptAsync(mpts -> {
                    MinecraftProfileTexture skin = mpts.skin();
                    MinecraftProfileTexture cape = mpts.cape();
                    MinecraftProfileTexture elytra = mpts.elytra();
                    if (skin != null) {
                        PlayerProfile.this.skinType = skin.getMetadata("model");
                        this.defineTexture(TextureType.SKIN, skin.getUrl(), skin.getHash());
                    }
                    if (cape != null) {
                        this.defineTexture(TextureType.CAPE, cape.getUrl(), cape.getHash());
                    }
                    if (elytra != null) {
                        this.defineTexture(TextureType.ELYTRA, elytra.getUrl(), elytra.getHash());
                    }
                }, t -> class_310.method_1551().method_63588(t::run));
            }
        };
    }

    @Override
    public String getName() {
        return this.profile.name();
    }

    @Override
    public Object getGameProfile() {
        return this.profile;
    }

    static {
        inFirstPerson = () -> false;
        if (FPMDetector.doApply()) {
            FirstPersonDetector.init();
        }
    }
}

