/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.gui.popup;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.Slider;
import com.tom.cpl.gui.elements.Spinner;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.math.Box;
import java.util.ArrayList;
import java.util.List;
import java.util.function.IntConsumer;

public class ColorButton
extends Button {
    private static List<Integer> colorCache = new ArrayList<Integer>();
    private IntConsumer actionColor;
    private int color;

    public ColorButton(IGui gui, Frame frame, IntConsumer action) {
        super(gui, "", null);
        this.action = () -> frame.openPopup(new ColorPopup(frame));
        this.actionColor = action;
    }

    public ColorButton(IGui gui, String text, Frame frame, IntConsumer action) {
        super(gui, text, null);
        this.action = () -> frame.openPopup(new ColorPopup(frame));
        this.actionColor = action;
    }

    private ColorButton(IGui gui, Runnable action) {
        super(gui, "", null);
        this.action = action;
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        int bgColor = this.gui.getColors().button_fill;
        int color = this.gui.getColors().button_text_color;
        if (!this.enabled) {
            color = this.gui.getColors().button_text_disabled;
            bgColor = this.gui.getColors().button_disabled;
        } else if (event.isHovered(this.bounds)) {
            color = this.gui.getColors().button_text_hover;
            bgColor = this.gui.getColors().button_hover;
        }
        if (event.isHovered(this.bounds) && this.tooltip != null) {
            this.tooltip.set();
        }
        this.gui.drawBox(this.bounds.x, this.bounds.y, this.bounds.w, this.bounds.h, this.gui.getColors().button_border);
        this.gui.drawBox(this.bounds.x + 1, this.bounds.y + 1, this.bounds.w - 2, this.bounds.h - 2, bgColor);
        if (this.name == null || this.name.isEmpty()) {
            this.gui.drawBox(this.bounds.x + 3, this.bounds.y + 3, this.bounds.w - 6, this.bounds.h - 6, 0xFF000000 | this.color);
        } else {
            int w = this.gui.textWidth(this.name);
            this.gui.drawText(this.bounds.x + this.bounds.h - 8 + (this.bounds.w - this.bounds.h - 8) / 2 - w / 2, this.bounds.y + this.bounds.h / 2 - 4, this.name, color);
            this.gui.drawBox(this.bounds.x + 3, this.bounds.y + 3, this.bounds.h - 6, this.bounds.h - 6, this.gui.getColors().button_border);
            this.gui.drawBox(this.bounds.x + 4, this.bounds.y + 4, this.bounds.h - 8, this.bounds.h - 8, 0xFF000000 | this.color);
        }
    }

    public void setColor(int color) {
        this.color = color;
    }

    private static int rgb2hsv(int color) {
        int r = (color & 0xFF0000) >> 16;
        int g = (color & 0xFF00) >> 8;
        int b = color & 0xFF;
        float[] hsv = ColorButton.RGBtoHSB(r, g, b);
        return ((int)(hsv[0] * 255.0f) & 0xFF) << 16 | ((int)(hsv[1] * 255.0f) & 0xFF) << 8 | (int)(hsv[2] * 255.0f) & 0xFF;
    }

    private static int hsv2rgb(int hsv) {
        int h = (hsv & 0xFF0000) >> 16;
        int s = (hsv & 0xFF00) >> 8;
        int v = hsv & 0xFF;
        return ColorButton.HSBtoRGB((float)h / 255.0f, (float)s / 255.0f, (float)v / 255.0f);
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b << 0;
    }

    public static float[] RGBtoHSB(int r, int g, int b) {
        float hue;
        int cmin;
        int cmax;
        float[] hsbvals = new float[3];
        int n = cmax = r > g ? r : g;
        if (b > cmax) {
            cmax = b;
        }
        int n2 = cmin = r < g ? r : g;
        if (b < cmin) {
            cmin = b;
        }
        float brightness = (float)cmax / 255.0f;
        float saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsbvals[0] = hue;
        hsbvals[1] = saturation;
        hsbvals[2] = brightness;
        return hsbvals;
    }

    public class ColorPopup
    extends PopupPanel {
        private SliderGradient sliderR;
        private SliderGradient sliderG;
        private SliderGradient sliderB;
        private SliderGradient sliderH;
        private SliderGradient sliderS;
        private SliderGradient sliderV;
        private Spinner spinnerR;
        private Spinner spinnerG;
        private Spinner spinnerB;
        private Spinner spinnerH;
        private Spinner spinnerS;
        private Spinner spinnerV;
        private TextField hexField;

        public ColorPopup(Frame frm) {
            super(frm.getGui());
            boolean small = frm.getBounds().h < 320;
            this.sliderR = new SliderGradient(this.gui);
            this.sliderG = new SliderGradient(this.gui);
            this.sliderB = new SliderGradient(this.gui);
            this.sliderH = new SliderGradient(this.gui);
            this.sliderS = new SliderGradient(this.gui);
            this.sliderV = new SliderGradient(this.gui);
            this.spinnerR = new Spinner(this.gui);
            this.spinnerG = new Spinner(this.gui);
            this.spinnerB = new Spinner(this.gui);
            this.spinnerH = new Spinner(this.gui);
            this.spinnerS = new Spinner(this.gui);
            this.spinnerV = new Spinner(this.gui);
            this.hexField = new TextField(this.gui);
            int r = (ColorButton.this.color & 0xFF0000) >> 16;
            int g = (ColorButton.this.color & 0xFF00) >> 8;
            int b = ColorButton.this.color & 0xFF;
            this.spinnerR.setValue(r);
            this.spinnerG.setValue(g);
            this.spinnerB.setValue(b);
            this.updateColorRGB_spinner();
            this.sliderR.setBounds(new Box(5, small ? 30 : 120, 100, 20));
            this.sliderG.setBounds(new Box(5, small ? 60 : 150, 100, 20));
            this.sliderB.setBounds(new Box(5, small ? 90 : 180, 100, 20));
            this.sliderH.setBounds(new Box(5, 30, 100, 20));
            this.sliderS.setBounds(new Box(5, 60, 100, 20));
            this.sliderV.setBounds(new Box(5, 90, 100, 20));
            this.spinnerR.setBounds(new Box(110, small ? 30 : 120, 40, 20));
            this.spinnerG.setBounds(new Box(110, small ? 60 : 150, 40, 20));
            this.spinnerB.setBounds(new Box(110, small ? 90 : 180, 40, 20));
            this.spinnerH.setBounds(new Box(110, 30, 40, 20));
            this.spinnerS.setBounds(new Box(110, 60, 40, 20));
            this.spinnerV.setBounds(new Box(110, 90, 40, 20));
            this.hexField.setBounds(new Box(5, small ? 120 : 210, 100, 20));
            this.spinnerR.setDp(0);
            this.spinnerG.setDp(0);
            this.spinnerB.setDp(0);
            this.spinnerH.setDp(0);
            this.spinnerS.setDp(0);
            this.spinnerV.setDp(0);
            this.sliderR.setAction(this::updateColorRGB_slider);
            this.sliderG.setAction(this::updateColorRGB_slider);
            this.sliderB.setAction(this::updateColorRGB_slider);
            this.sliderH.setAction(this::updateColorHSV_slider);
            this.sliderS.setAction(this::updateColorHSV_slider);
            this.sliderV.setAction(this::updateColorHSV_slider);
            this.spinnerR.addChangeListener(this::updateColorRGB_spinner);
            this.spinnerG.addChangeListener(this::updateColorRGB_spinner);
            this.spinnerB.addChangeListener(this::updateColorRGB_spinner);
            this.spinnerH.addChangeListener(this::updateColorHSV_spinner);
            this.spinnerS.addChangeListener(this::updateColorHSV_spinner);
            this.spinnerV.addChangeListener(this::updateColorHSV_spinner);
            this.hexField.setEventListener(this::updateHexField);
            this.addElement(this.sliderR);
            this.addElement(this.sliderG);
            this.addElement(this.sliderB);
            this.addElement(this.spinnerR);
            this.addElement(this.spinnerG);
            this.addElement(this.spinnerB);
            if (!small) {
                this.addElement(this.sliderH);
                this.addElement(this.sliderS);
                this.addElement(this.sliderV);
                this.addElement(this.spinnerH);
                this.addElement(this.spinnerS);
                this.addElement(this.spinnerV);
            }
            this.addElement(this.hexField);
            Button ok = new Button(this.gui, this.gui.i18nFormat("button.cpm.set", new Object[0]), () -> {
                int color = this.getColor();
                colorCache.remove((Object)color);
                if (colorCache.size() >= 6) {
                    colorCache.remove(0);
                }
                colorCache.add(color);
                ColorButton.this.actionColor.accept(color);
                this.close();
            });
            ok.setBounds(new Box(5, small ? 175 : 265, 100, 16));
            this.addElement(ok);
            for (int i = 0; i < 6; ++i) {
                int c = i < colorCache.size() ? colorCache.get(colorCache.size() - i - 1) : -1;
                ColorButton btn = new ColorButton(this.gui, () -> this.loadColor(c));
                btn.setColor(c);
                btn.setBounds(new Box(5 + i * 25, small ? 150 : 240, 20, 16));
                this.addElement(btn);
            }
            this.setBounds(new Box(0, 0, 160, small ? 200 : 290));
            this.updateDisplayText();
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            super.draw(event, partialTicks);
            this.gui.drawBox(this.bounds.x + this.bounds.w - 35, this.bounds.y + 5, 30, 20, this.gui.getColors().color_picker_border);
            this.gui.drawBox(this.bounds.x + this.bounds.w - 34, this.bounds.y + 6, 28, 18, this.getColor() | 0xFF000000);
        }

        private void loadColor(int color) {
            int r = (color & 0xFF0000) >> 16;
            int g = (color & 0xFF00) >> 8;
            int b = color & 0xFF;
            this.spinnerR.setValue(r);
            this.spinnerG.setValue(g);
            this.spinnerB.setValue(b);
            this.sliderR.setValue((float)r / 255.0f);
            this.sliderG.setValue((float)g / 255.0f);
            this.sliderB.setValue((float)b / 255.0f);
            this.updateRGB();
            this.updateDisplayText();
            this.hexField.setText(String.format("%1$06X", color));
        }

        private int getColor() {
            return ((int)(this.sliderR.getValue() * 255.0f) & 0xFF) << 16 | ((int)(this.sliderG.getValue() * 255.0f) & 0xFF) << 8 | (int)(this.sliderB.getValue() * 255.0f) & 0xFF;
        }

        private float getV(Spinner s, float max) {
            float v = s.getValue();
            if (v < 0.0f) {
                s.setValue(0.0f);
            }
            if (v > max) {
                s.setValue(max);
            }
            return s.getValue();
        }

        private void updateColorRGB_spinner() {
            this.sliderR.setValue(this.getV(this.spinnerR, 255.0f) / 255.0f);
            this.sliderG.setValue(this.getV(this.spinnerG, 255.0f) / 255.0f);
            this.sliderB.setValue(this.getV(this.spinnerB, 255.0f) / 255.0f);
            this.hexField.setText(String.format("%1$06X", this.getColor()));
            this.updateRGB();
            this.updateDisplayText();
        }

        private void updateColorHSV_spinner() {
            this.sliderH.setValue(this.getV(this.spinnerH, 360.0f) / 360.0f);
            this.sliderS.setValue(this.getV(this.spinnerS, 100.0f) / 100.0f);
            this.sliderV.setValue(this.getV(this.spinnerV, 100.0f) / 100.0f);
            this.updateHSV();
            this.updateDisplayText();
        }

        private void updateRGB() {
            float[] hsv = ColorButton.RGBtoHSB((int)this.spinnerR.getValue(), (int)this.spinnerG.getValue(), (int)this.spinnerB.getValue());
            this.sliderH.setValue(hsv[0]);
            this.sliderS.setValue(hsv[1]);
            this.sliderV.setValue(hsv[2]);
            this.spinnerH.setValue(hsv[0] * 360.0f);
            this.spinnerS.setValue(hsv[1] * 100.0f);
            this.spinnerV.setValue(hsv[2] * 100.0f);
        }

        private void updateHSV() {
            int color = ColorButton.HSBtoRGB(this.sliderH.getValue(), this.sliderS.getValue(), this.sliderV.getValue());
            int r = (color & 0xFF0000) >> 16;
            int g = (color & 0xFF00) >> 8;
            int b = color & 0xFF;
            this.spinnerR.setValue(r);
            this.spinnerG.setValue(g);
            this.spinnerB.setValue(b);
            this.sliderR.setValue((float)r / 255.0f);
            this.sliderG.setValue((float)g / 255.0f);
            this.sliderB.setValue((float)b / 255.0f);
            this.hexField.setText(String.format("%1$06X", this.getColor()));
        }

        private void updateColorRGB_slider() {
            this.spinnerR.setValue(this.sliderR.getValue() * 255.0f);
            this.spinnerG.setValue(this.sliderG.getValue() * 255.0f);
            this.spinnerB.setValue(this.sliderB.getValue() * 255.0f);
            this.hexField.setText(String.format("%1$06X", this.getColor()));
            this.updateRGB();
            this.updateDisplayText();
        }

        private void updateColorHSV_slider() {
            this.spinnerH.setValue(this.sliderH.getValue() * 360.0f);
            this.spinnerS.setValue(this.sliderS.getValue() * 100.0f);
            this.spinnerV.setValue(this.sliderV.getValue() * 100.0f);
            this.updateHSV();
            this.updateDisplayText();
        }

        private void updateDisplayText() {
            this.sliderR.setText("R: " + (int)(this.sliderR.getValue() * 255.0f));
            this.sliderG.setText("G: " + (int)(this.sliderG.getValue() * 255.0f));
            this.sliderB.setText("B: " + (int)(this.sliderB.getValue() * 255.0f));
            this.sliderH.setText("H: " + (int)(this.sliderH.getValue() * 360.0f));
            this.sliderS.setText("S: " + (int)(this.sliderS.getValue() * 100.0f));
            this.sliderV.setText("V: " + (int)(this.sliderV.getValue() * 100.0f));
            int color = this.getColor();
            this.sliderR.setColor(color & 0xFFFF | 0xFF000000, color | 0xFF0000);
            this.sliderG.setColor(color & 0xFF00FF | 0xFF000000, color | 0xFF00);
            this.sliderB.setColor(color & 0xFFFF00 | 0xFF000000, color | 0xFF);
            int hsv = ColorButton.rgb2hsv(color);
            this.sliderH.setColor(0, hsv);
            this.sliderS.setColor(ColorButton.hsv2rgb(hsv & 0xFF00FF) | 0xFF000000, ColorButton.hsv2rgb(hsv | 0xFF00));
            this.sliderV.setColor(ColorButton.hsv2rgb(hsv & 0xFFFF00) | 0xFF000000, ColorButton.hsv2rgb(hsv | 0xFF));
        }

        private void updateHexField() {
            try {
                int color = Integer.parseInt(this.hexField.getText(), 16);
                int r = (color & 0xFF0000) >> 16;
                int g = (color & 0xFF00) >> 8;
                int b = color & 0xFF;
                this.spinnerR.setValue(r);
                this.spinnerG.setValue(g);
                this.spinnerB.setValue(b);
                this.sliderR.setValue((float)r / 255.0f);
                this.sliderG.setValue((float)g / 255.0f);
                this.sliderB.setValue((float)b / 255.0f);
                this.updateRGB();
                this.updateDisplayText();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        @Override
        public String getTitle() {
            return this.gui.i18nFormat("label.cpm.changeColor", new Object[0]);
        }
    }

    private static class SliderGradient
    extends Slider {
        private int left;
        private int right;

        public SliderGradient(IGui gui) {
            super(gui, "");
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            int textw = this.gui.textWidth(this.name);
            int color = this.gui.getColors().button_text_color;
            if (!this.enabled) {
                color = this.gui.getColors().button_text_disabled;
            } else if (event.isHovered(this.bounds)) {
                color = this.gui.getColors().button_text_hover;
            }
            this.gui.drawBox(this.bounds.x, this.bounds.y, this.bounds.w, this.bounds.h, this.gui.getColors().button_border);
            if (this.left == 0) {
                float w = (float)(this.bounds.w - 2) / 6.0f;
                int x = this.bounds.x + 1;
                int y = this.bounds.y + 1;
                int h = this.bounds.h - 2;
                int sv = this.right & 0xFFFF;
                for (int i = 0; i < 6; ++i) {
                    int left = 0xFF000000 | ColorButton.hsv2rgb(sv | 42 * i << 16);
                    int right = 0xFF000000 | ColorButton.hsv2rgb(sv | 42 * (i + 1) << 16);
                    this.gui.drawGradientBox((int)((float)x + (float)i * w), y, (int)Math.ceil(w), h, left, right, left, right);
                }
            } else {
                this.gui.drawGradientBox(this.bounds.x + 1, this.bounds.y + 1, this.bounds.w - 2, this.bounds.h - 2, this.left, this.right, this.left, this.right);
            }
            this.gui.drawBox((int)((float)(this.bounds.x + 1) + this.v * (float)(this.bounds.w - 5)), this.bounds.y + 1, 3, this.bounds.h - 2, this.gui.getColors().slider_bar);
            this.gui.drawText(this.bounds.x + this.bounds.w / 2 - textw / 2, this.bounds.y + this.bounds.h / 2 - 4, this.name, color);
        }

        private void setColor(int left, int right) {
            this.left = left;
            this.right = right | 0xFF000000;
        }
    }
}

