/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.network;

import com.tom.cpl.function.ToFloatFunction;
import com.tom.cpl.nbt.NBTTagCompound;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.animation.AnimationState;
import com.tom.cpm.shared.animation.IPose;
import com.tom.cpm.shared.animation.ServerAnimationState;
import com.tom.cpm.shared.animation.VanillaPose;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

public enum ModelEventType {
    FALLING(VanillaPose.FALLING, ModelEventType.floatType(a -> a.falling, (a, b) -> {
        a.falling = b.floatValue();
    })),
    CREATIVE_FLYING(VanillaPose.CREATIVE_FLYING, ModelEventType.booleanType(a -> a.creativeFlying, (a, b) -> {
        a.creativeFlying = b;
    })),
    JUMPING(VanillaPose.JUMPING, ModelEventType.eventType((a, b) -> {
        a.jumping = b;
    })),
    HEALTH(VanillaPose.HEALTH, ModelEventType.floatType(a -> a.health, (a, b) -> {
        a.health = b.floatValue();
    })),
    HUNGER(VanillaPose.HUNGER, ModelEventType.floatType(a -> a.hunger, (a, b) -> {
        a.hunger = b.floatValue();
    })),
    AIR(VanillaPose.AIR, ModelEventType.floatType(a -> a.air, (a, b) -> {
        a.air = b.floatValue();
    })),
    IN_MENU(VanillaPose.IN_MENU, ModelEventType.booleanType(a -> a.inMenu, (a, b) -> {
        a.inMenu = b;
    }));

    public static final ModelEventType[] VALUES;
    public static final ModelEventType[] SYNC_TYPES;
    private final String name = this.name().toLowerCase(Locale.ROOT);
    private final VanillaPose pose;
    private final ValueSync sync;

    private static ValueSync floatType(final ToFloatFunction<ServerAnimationState> get, final BiConsumer<ServerAnimationState, Float> set) {
        return new ValueSync(){

            @Override
            public void write(ModelEventType type, ServerAnimationState state, NBTTagCompound tag) {
                tag.setFloat(type.getName(), get.apply(state));
            }

            @Override
            public void read(ModelEventType type, AnimationState state, NBTTagCompound tag) {
                set.accept(state.serverState, Float.valueOf(tag.getFloat(type.getName())));
            }
        };
    }

    private static ValueSync booleanType(final Predicate<ServerAnimationState> get, final BiConsumer<ServerAnimationState, Boolean> set) {
        return new ValueSync(){

            @Override
            public void write(ModelEventType type, ServerAnimationState state, NBTTagCompound tag) {
                tag.setBoolean(type.getName(), get.test(state));
            }

            @Override
            public void read(ModelEventType type, AnimationState state, NBTTagCompound tag) {
                set.accept(state.serverState, tag.getBoolean(type.getName()));
            }
        };
    }

    private static ValueSync eventType(final BiConsumer<AnimationState, Long> set) {
        return new ValueSync(){

            @Override
            public void write(ModelEventType type, ServerAnimationState state, NBTTagCompound tag) {
                tag.setBoolean(type.getName(), true);
            }

            @Override
            public void read(ModelEventType type, AnimationState state, NBTTagCompound tag) {
                set.accept(state, tag.getBoolean(type.getName()) ? MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().getTime() : 0L);
            }

            @Override
            public void trigger(AnimationState state) {
                set.accept(state, MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().getTime());
            }

            @Override
            public boolean autoSync() {
                return false;
            }
        };
    }

    private ModelEventType(VanillaPose pose, ValueSync sync) {
        this.pose = pose;
        this.sync = sync;
    }

    public static <T extends Enum<T>> ModelEventType of(String value) {
        for (int i = 0; i < VALUES.length; ++i) {
            ModelEventType type = VALUES[i];
            if (!type.name.equalsIgnoreCase(value)) continue;
            return type;
        }
        return null;
    }

    public static ModelEventType getType(IPose value) {
        for (int i = 0; i < VALUES.length; ++i) {
            ModelEventType type = VALUES[i];
            if (type.pose != value) continue;
            return type;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void write(ServerAnimationState state, NBTTagCompound tag) {
        this.sync.write(this, state, tag);
    }

    public void read(AnimationState state, NBTTagCompound tag) {
        this.sync.read(this, state, tag);
    }

    public boolean autoSync() {
        return this.sync.autoSync();
    }

    public void trigger(AnimationState state) {
        this.sync.trigger(state);
    }

    static {
        VALUES = ModelEventType.values();
        SYNC_TYPES = (ModelEventType[])Arrays.stream(VALUES).filter(ModelEventType::autoSync).toArray(ModelEventType[]::new);
    }

    public static interface ValueSync {
        public void write(ModelEventType var1, ServerAnimationState var2, NBTTagCompound var3);

        public void read(ModelEventType var1, AnimationState var2, NBTTagCompound var3);

        default public boolean autoSync() {
            return true;
        }

        default public void trigger(AnimationState state) {
        }
    }
}

