/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tom.cpm.client.CustomPlayerModelsClient;
import com.tom.cpm.client.ModelTexture;
import com.tom.cpm.client.RefHolder;
import com.tom.cpm.shared.model.TextureSheetType;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.SkullBlockRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={SkullBlockRenderer.class})
public class SkullBlockRendererMixin {
    @Shadow
    @Final
    private Function<SkullBlock.Type, SkullModelBase> modelByType;

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/blockentity/SkullBlockRenderer;getRenderType(Lnet/minecraft/world/level/block/SkullBlock$Type;Lnet/minecraft/world/item/component/ResolvableProfile;)Lnet/minecraft/client/renderer/RenderType;")}, method={"render(Lnet/minecraft/world/level/block/entity/SkullBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IILnet/minecraft/world/phys/Vec3;)V"}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void onRender(SkullBlockEntity skullBlockEntity, float f, PoseStack poseStack, MultiBufferSource buffer, int i, int j, Vec3 vec3, CallbackInfo ci, float g, BlockState blockState, boolean bl, Direction direction, int k, float h, SkullBlock.Type skullType, SkullModelBase model) {
        RefHolder.CPM_MODELS = this.modelByType;
        ResolvableProfile gameProfile = skullBlockEntity.getOwnerProfile();
        if (skullType == SkullBlock.Types.PLAYER && gameProfile != null) {
            CustomPlayerModelsClient.INSTANCE.renderSkull((Model)model, gameProfile.gameProfile(), buffer);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getRenderType(Lnet/minecraft/world/level/block/SkullBlock$Type;Lnet/minecraft/world/item/component/ResolvableProfile;)Lnet/minecraft/client/renderer/RenderType;"}, cancellable=true)
    private static void onGetRenderType(SkullBlock.Type type, ResolvableProfile resolvableProfile, CallbackInfoReturnable<RenderType> cbi) {
        if (RefHolder.CPM_MODELS == null) {
            return;
        }
        SkullModelBase model = RefHolder.CPM_MODELS.apply(type);
        RefHolder.CPM_MODELS = null;
        if (type != SkullBlock.Types.PLAYER || resolvableProfile == null) {
            return;
        }
        ModelTexture mt = new ModelTexture(Minecraft.getInstance().getSkinManager().getInsecureSkin(resolvableProfile.gameProfile()).texture());
        CustomPlayerModelsClient.mc.getPlayerRenderManager().bindSkin(model, mt, TextureSheetType.SKIN);
        if (mt.getTexture() != null) {
            cbi.setReturnValue((Object)mt.getRenderType());
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"renderSkull(Lnet/minecraft/core/Direction;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/client/model/SkullModelBase;Lnet/minecraft/client/renderer/RenderType;)V"})
    private static void renderSkullPost(Direction direction, float yaw, float animationProgress, PoseStack matrices, MultiBufferSource vertexConsumers, int light, SkullModelBase model, RenderType renderLayer, CallbackInfo cbi) {
        CustomPlayerModelsClient.INSTANCE.renderSkullPost(vertexConsumers, (Model)model);
    }
}

