/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.parts;

import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.parts.IModelPart;
import com.tom.cpm.shared.parts.IResolvedModelPart;
import com.tom.cpm.shared.parts.ModelPartType;
import com.tom.cpm.shared.skin.TextureProvider;
import java.io.IOException;

public class ModelPartTexture
implements IModelPart,
IResolvedModelPart {
    private TextureProvider image;
    private TextureSheetType texType;

    public ModelPartTexture(IOHelper in, ModelDefinition def) throws IOException {
        this.texType = (TextureSheetType)in.readEnum(TextureSheetType.VALUES);
        this.image = new TextureProvider(in, def);
    }

    public ModelPartTexture(Editor editor, TextureSheetType tex) {
        this.texType = tex;
        this.image = editor.textures.get((Object)((Object)tex)).provider;
    }

    @Override
    public IResolvedModelPart resolve() throws IOException {
        return this;
    }

    @Override
    public void preApply(ModelDefinition def) {
        def.setTexture(this.texType, this.image);
    }

    @Override
    public void write(IOHelper dout) throws IOException {
        dout.writeEnum(this.texType);
        this.image.write(dout);
    }

    @Override
    public ModelPartType getType() {
        return ModelPartType.TEXTURE;
    }

    public String toString() {
        return "Texture: " + this.texType;
    }
}

