/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.mixin.render;

import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.tom.cpl.text.FormatText;
import com.tom.cpm.client.CPMOrderedSubmitNodeCollector;
import com.tom.cpm.client.CustomPlayerModelsClient;
import com.tom.cpm.client.LivingRendererAccess;
import com.tom.cpm.client.ModelTexture;
import com.tom.cpm.client.PlayerProfile;
import com.tom.cpm.client.PlayerRenderStateAccess;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.model.TextureSheetType;
import net.minecraft.client.entity.ClientMannequin;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.player.AvatarRenderer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Avatar;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AvatarRenderer.class})
public abstract class AvatarRendererMixin<AvatarlikeEntity extends Avatar>
extends LivingEntityRenderer<AvatarlikeEntity, AvatarRenderState, PlayerModel>
implements LivingRendererAccess {
    @Unique
    private static final ResourceLocation CPM$EMPTY_TEX = ResourceLocation.parse((String)"cpm:textures/template/empty.png");

    public AvatarRendererMixin(EntityRendererProvider.Context context, PlayerModel entityModel, float f) {
        super(context, (EntityModel)entityModel, f);
    }

    @Inject(at={@At(value="RETURN")}, method={"getTextureLocation(Lnet/minecraft/client/renderer/entity/state/AvatarRenderState;)Lnet/minecraft/resources/ResourceLocation;"}, cancellable=true)
    public void onGetEntityTexture(AvatarRenderState entity, CallbackInfoReturnable<ResourceLocation> cbi) {
        CustomPlayerModelsClient.mc.getPlayerRenderManager().bindSkin(this.getModel(), new ModelTexture(cbi), TextureSheetType.SKIN);
    }

    @Inject(at={@At(value="HEAD")}, method={"submitNameTag"}, cancellable=true)
    public void onSubmitNameTag(AvatarRenderState avatarRenderState, PoseStack poseStack, SubmitNodeCollector submitNodeCollector, CameraRenderState cameraRenderState, CallbackInfo cbi) {
        PlayerRenderStateAccess sa;
        if (!Player.isEnableNames()) {
            cbi.cancel();
            return;
        }
        if (Player.isEnableLoadingInfo() && (sa = (PlayerRenderStateAccess)avatarRenderState).cpm$getModelStatus() != null) {
            poseStack.pushPose();
            poseStack.translate(0.0, (double)1.3f, 0.0);
            poseStack.scale(0.5f, 0.5f, 0.5f);
            submitNodeCollector.submitNameTag(poseStack, avatarRenderState.nameTagAttachment, 0, sa.cpm$getModelStatus(), !avatarRenderState.isDiscrete, avatarRenderState.lightCoords, avatarRenderState.distanceToCameraSq, cameraRenderState);
            poseStack.popPose();
        }
    }

    @Override
    public void cpm$onGetRenderType(LivingEntityRenderState player, boolean pTranslucent, boolean pGlowing, CallbackInfoReturnable<RenderType> cbi) {
        if (CustomPlayerModelsClient.mc.getPlayerRenderManager().isBound(this.getModel())) {
            boolean r = CustomPlayerModelsClient.mc.getPlayerRenderManager().getHolderSafe(this.getModel(), null, h -> h.setInvisState(), false, false);
            if (pTranslucent) {
                return;
            }
            if (!pGlowing && !r) {
                return;
            }
            ResourceLocation tex = this.getTextureLocation((LivingEntityRenderState)((AvatarRenderState)player));
            CustomPlayerModelsClient.mc.getPlayerRenderManager().getHolderSafe(this.getModel(), null, h -> h.setInvis(pGlowing), false);
            cbi.setReturnValue((Object)(pGlowing ? RenderType.outline((ResourceLocation)tex) : RenderType.entityCutout((ResourceLocation)CPM$EMPTY_TEX)));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"extractRenderState"})
    public void onExtractRenderState(Avatar abstractClientPlayer, AvatarRenderState playerRenderState, float f, CallbackInfo cbi) {
        Object unique;
        PlayerRenderStateAccess sa = (PlayerRenderStateAccess)playerRenderState;
        GameProfile profile = PlayerProfile.getPlayerProfile(abstractClientPlayer);
        if (abstractClientPlayer instanceof AbstractClientPlayer) {
            unique = "player";
        } else if (abstractClientPlayer instanceof ClientMannequin) {
            unique = "man:" + abstractClientPlayer.getStringUUID();
        } else {
            return;
        }
        FormatText st = CustomPlayerModelsClient.INSTANCE.manager.getStatus(profile, (String)unique);
        sa.cpm$setModelStatus(st != null ? (Component)st.remap() : null);
        Player<Avatar> pl = CustomPlayerModelsClient.INSTANCE.manager.loadPlayerState(profile, abstractClientPlayer, (String)unique, AnimationEngine.AnimationMode.PLAYER);
        sa.cpm$setPlayer(pl);
        if (pl != null) {
            ((PlayerProfile)pl).updateFromState(playerRenderState);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"renderRightHand"})
    public void onRenderRightArmPre(PoseStack poseStack, SubmitNodeCollector vertexConsumers, int i, ResourceLocation resourceLocation, boolean sleeve, CallbackInfo cbi, @Local LocalRef<SubmitNodeCollector> snc) {
        snc.set((Object)new CPMOrderedSubmitNodeCollector.CPMSubmitNodeCollector(vertexConsumers));
        CustomPlayerModelsClient.INSTANCE.renderHand((PlayerModel)this.getModel());
    }

    @Inject(at={@At(value="HEAD")}, method={"renderLeftHand"})
    public void onRenderLeftArmPre(PoseStack poseStack, SubmitNodeCollector vertexConsumers, int i, ResourceLocation resourceLocation, boolean sleeve, CallbackInfo cbi, @Local LocalRef<SubmitNodeCollector> snc) {
        snc.set((Object)new CPMOrderedSubmitNodeCollector.CPMSubmitNodeCollector(vertexConsumers));
        CustomPlayerModelsClient.INSTANCE.renderHand((PlayerModel)this.getModel());
    }

    @Inject(at={@At(value="RETURN")}, method={"renderRightHand"})
    public void onRenderRightArmPost(PoseStack poseStack, SubmitNodeCollector vertexConsumers, int i, ResourceLocation resourceLocation, boolean sleeve, CallbackInfo cbi) {
        CustomPlayerModelsClient.INSTANCE.renderHandPost((HumanoidModel)this.getModel());
    }

    @Inject(at={@At(value="RETURN")}, method={"renderLeftHand"})
    public void onRenderLeftArmPost(PoseStack poseStack, SubmitNodeCollector vertexConsumers, int i, ResourceLocation resourceLocation, boolean sleeve, CallbackInfo cbi) {
        CustomPlayerModelsClient.INSTANCE.renderHandPost((HumanoidModel)this.getModel());
    }

    @ModifyArg(at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/RenderType;entityTranslucent(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/client/renderer/RenderType;"), method={"renderHand"})
    public ResourceLocation getSkinTex(ResourceLocation arg) {
        ModelTexture tex = new ModelTexture(arg);
        CustomPlayerModelsClient.mc.getPlayerRenderManager().bindSkin(this.getModel(), tex, TextureSheetType.SKIN);
        return tex.getTexture();
    }
}

