/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.mixin.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.tom.cpm.client.CapeTransformUtil;
import com.tom.cpm.client.CustomPlayerModelsClient;
import com.tom.cpm.client.ModelTexture;
import com.tom.cpm.client.PlayerRenderStateAccess;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.TextureSheetType;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CapeLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.AvatarRenderState;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.ClientAsset;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Avatar;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CapeLayer.class})
public abstract class CapeLayerMixin
extends RenderLayer<AvatarRenderState, PlayerModel> {
    @Shadow
    @Final
    private HumanoidModel<AvatarRenderState> model;

    public CapeLayerMixin(RenderLayerParent<AvatarRenderState, PlayerModel> p_117346_) {
        super(p_117346_);
    }

    @Shadow
    abstract boolean hasLayer(ItemStack var1, EquipmentClientInfo.LayerType var2);

    @Inject(at={@At(value="HEAD")}, method={"submit(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;ILnet/minecraft/client/renderer/entity/state/AvatarRenderState;FF)V"}, cancellable=true)
    private void submitCape(PoseStack poseStack, SubmitNodeCollector collector, int light, AvatarRenderState state, float p_433069_, float p_435707_, CallbackInfo cbi) {
        ModelDefinition def;
        Player<Avatar> pl = ((PlayerRenderStateAccess)state).cpm$getPlayer();
        if (pl != null && (def = pl.getModelDefinition()) != null && def.hasRoot(RootModelType.CAPE)) {
            if (!this.hasLayer(state.chestEquipment, EquipmentClientInfo.LayerType.WINGS)) {
                ClientAsset.Texture cape;
                poseStack.pushPose();
                if (this.hasLayer(state.chestEquipment, EquipmentClientInfo.LayerType.HUMANOID)) {
                    poseStack.translate(0.0f, -0.053125f, 0.06875f);
                }
                ResourceLocation defLoc = (cape = state.skin.cape()) != null ? cape.texturePath() : CustomPlayerModelsClient.DEFAULT_CAPE;
                ModelTexture mt = new ModelTexture(defLoc);
                CustomPlayerModelsClient.mc.getPlayerRenderManager().bindSubModel(this.getParentModel(), this.model, null);
                CustomPlayerModelsClient.mc.getPlayerRenderManager().bindSkin(this.model, mt, TextureSheetType.CAPE);
                if (mt.getTexture() != null) {
                    this.model.setupAnim((HumanoidRenderState)state);
                    CapeTransformUtil.applyTransform(this.model);
                    CustomPlayerModelsClient.mc.getPlayerRenderManager().setModelPose(this.model);
                    collector.submitModel(this.model, (Object)state, poseStack, mt.getRenderType(), light, OverlayTexture.NO_OVERLAY, state.outlineColor, null);
                }
                CustomPlayerModelsClient.mc.getPlayerRenderManager().unbindModel(this.model);
                poseStack.popPose();
            }
            cbi.cancel();
        }
    }
}

