/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm;

import com.mojang.brigadier.CommandDispatcher;
import com.tom.cpl.config.ModConfigFile;
import com.tom.cpl.text.TextStyle;
import com.tom.cpm.CommonBase;
import com.tom.cpm.MinecraftServerObject;
import com.tom.cpm.api.ICPMPlugin;
import com.tom.cpm.common.Command;
import com.tom.cpm.common.ServerHandler;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.PlatformFeature;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.util.IVersionCheck;
import com.tom.cpm.shared.util.VersionCheck;
import java.io.File;
import java.util.EnumSet;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public class CustomPlayerModels
extends CommonBase
implements ModInitializer {
    private static final EnumSet<PlatformFeature> features = EnumSet.of(PlatformFeature.EDITOR_HELD_ITEM, PlatformFeature.EDITOR_SUPPORTED);

    public void onInitialize() {
        this.cfg = new ModConfigFile(new File(FabricLoader.getInstance().getConfigDir().toFile(), "cpm.json"));
        MinecraftObjectHolder.setCommonObject(this);
        ServerLifecycleEvents.SERVER_STARTED.register(s -> MinecraftObjectHolder.setServerObject(new MinecraftServerObject(s)));
        ServerLifecycleEvents.SERVER_STOPPING.register(s -> {
            ModConfig.getWorldConfig().save();
            MinecraftObjectHolder.setServerObject(null);
        });
        ServerTickEvents.END_SERVER_TICK.register(s -> ServerHandler.netHandler.tick());
        CommandRegistrationCallback.EVENT.register((d, isD) -> new Command((CommandDispatcher<class_2168>)d, false));
        ServerPlayerEvents.AFTER_RESPAWN.register((o, n, end) -> {
            if (!end) {
                ServerHandler.netHandler.onRespawn(n);
            }
        });
        FabricLoader.getInstance().getEntrypointContainers("cpmapi", ICPMPlugin.class).forEach(entrypoint -> {
            ModMetadata metadata = entrypoint.getProvider().getMetadata();
            String modId = metadata.getId();
            try {
                ICPMPlugin plugin = (ICPMPlugin)entrypoint.getEntrypoint();
                api.register(plugin);
            }
            catch (Throwable e) {
                LOG.error("Mod {} provides a broken implementation of CPM api", (Object)modId, (Object)e);
            }
        });
        LOG.info("Customizable Player Models Initialized");
        LOG.info(api.getPluginStatus());
        this.apiInit();
    }

    @Override
    public EnumSet<PlatformFeature> getSupportedFeatures() {
        return features;
    }

    @Override
    public String getMCBrand() {
        String fVer = FabricLoader.getInstance().getModContainer("fabric").map(m -> m.getMetadata().getVersion().getFriendlyString()).orElse("?UNKNOWN?");
        String lVer = FabricLoader.getInstance().getModContainer("fabricloader").map(m -> m.getMetadata().getVersion().getFriendlyString()).orElse("?UNKNOWN?");
        return "(fabric/" + lVer + "/" + fVer + ")";
    }

    @Override
    public String getModVersion() {
        return FabricLoader.getInstance().getModContainer("cpm").map(m -> m.getMetadata().getVersion().getFriendlyString()).orElse("?UNKNOWN?");
    }

    @Override
    protected class_5250 styleText(class_5250 in, TextStyle style) {
        class_2583 s = class_2583.field_24360.method_10982(Boolean.valueOf(style.bold)).method_10978(Boolean.valueOf(style.italic));
        if (style.underline) {
            s = s.method_27706(class_124.field_1073);
        }
        if (style.strikethrough) {
            s = s.method_27706(class_124.field_1055);
        }
        return in.method_10862(s);
    }

    @Override
    public IVersionCheck getVersionCheck() {
        return VersionCheck.get(this.getMCVersion() + "-fabric", this.getModVersion());
    }
}

