/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.authlib.GameProfile;
import com.tom.cpl.block.BiomeHandler;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.IKeybind;
import com.tom.cpl.render.RenderTypeBuilder;
import com.tom.cpl.tag.AllTagManagers;
import com.tom.cpl.util.DynamicTexture;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.ImageIO;
import com.tom.cpm.client.CPMTagLoader;
import com.tom.cpm.client.CustomPlayerModelsClient;
import com.tom.cpm.client.CustomRenderTypes;
import com.tom.cpm.client.GuiImpl;
import com.tom.cpm.client.KeyBindings;
import com.tom.cpm.client.NativeImageIO;
import com.tom.cpm.client.Platform;
import com.tom.cpm.client.PlayerProfile;
import com.tom.cpm.client.PlayerRenderManager;
import com.tom.cpm.common.BiomeHandlerImpl;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.definition.ModelDefinitionLoader;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.model.render.RenderMode;
import com.tom.cpm.shared.network.NetH;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.util.MojangAPI;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1068;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4536;
import net.minecraft.class_526;
import net.minecraft.class_640;

public class MinecraftObject
implements MinecraftClientAccess {
    private final class_310 mc;
    private final ModelDefinitionLoader<GameProfile> loader;
    private final PlayerRenderManager prm;
    private final AllTagManagers tags;
    public RenderTypeBuilder<class_2960, class_1921> renderBuilder;

    public MinecraftObject(class_310 mc) {
        this.mc = mc;
        MinecraftObjectHolder.setClientObject(this);
        this.loader = new ModelDefinitionLoader<GameProfile>(PlayerProfile::new, GameProfile::getId, GameProfile::getName);
        this.prm = new PlayerRenderManager();
        this.renderBuilder = new RenderTypeBuilder();
        this.renderBuilder.register(RenderMode.DEFAULT, class_1921::method_23580, 0);
        this.renderBuilder.register(RenderMode.GLOW, CustomRenderTypes::glowingEyes, 1);
        this.renderBuilder.register(RenderMode.COLOR, CustomRenderTypes::entityColorTranslucent, 0);
        this.renderBuilder.register(RenderMode.COLOR_GLOW, CustomRenderTypes::glowingEyesColor, 1);
        this.renderBuilder.register(RenderMode.OUTLINE, CustomRenderTypes::linesNoDepth, 2);
        this.tags = new AllTagManagers(mc, CPMTagLoader::new);
    }

    @Override
    public PlayerRenderManager getPlayerRenderManager() {
        return this.prm;
    }

    @Override
    public DynamicTexture.ITexture createTexture() {
        return new DynTexture(this.mc);
    }

    @Override
    public void executeOnGameThread(Runnable r) {
        this.mc.execute(r);
    }

    @Override
    public void executeNextFrame(Runnable r) {
        this.mc.method_18858(r);
    }

    @Override
    public ModelDefinitionLoader<GameProfile> getDefinitionLoader() {
        return this.loader;
    }

    @Override
    public SkinType getSkinType() {
        return SkinType.get(class_1068.method_4647((UUID)this.mc.method_1548().method_1677().getId()));
    }

    @Override
    public void setEncodedGesture(int value) {
        Set s = this.mc.field_1690.field_1892;
        MinecraftObject.setEncPart(s, value, 0, class_1664.field_7563);
        MinecraftObject.setEncPart(s, value, 1, class_1664.field_7564);
        MinecraftObject.setEncPart(s, value, 2, class_1664.field_7566);
        MinecraftObject.setEncPart(s, value, 3, class_1664.field_7565);
        MinecraftObject.setEncPart(s, value, 4, class_1664.field_7568);
        MinecraftObject.setEncPart(s, value, 5, class_1664.field_7570);
        this.mc.field_1690.method_1643();
    }

    private static void setEncPart(Set<class_1664> s, int value, int off, class_1664 part) {
        if ((value & 1 << off) != 0) {
            s.add(part);
        } else {
            s.remove(part);
        }
    }

    @Override
    public boolean isInGame() {
        return this.mc.field_1724 != null;
    }

    @Override
    public Object getPlayerIDObject() {
        return this.mc.method_1548().method_1677();
    }

    @Override
    public Object getCurrentPlayerIDObject() {
        return PlayerProfile.getPlayerProfile((class_1657)this.mc.field_1724);
    }

    @Override
    public List<IKeybind> getKeybinds() {
        return KeyBindings.kbs;
    }

    @Override
    public MinecraftClientAccess.ServerStatus getServerSideStatus() {
        return this.mc.field_1724 != null ? (((NetH)this.mc.method_1562()).cpm$hasMod() ? MinecraftClientAccess.ServerStatus.INSTALLED : MinecraftClientAccess.ServerStatus.SKIN_LAYERS_ONLY) : MinecraftClientAccess.ServerStatus.OFFLINE;
    }

    @Override
    public File getGameDir() {
        return this.mc.field_1697;
    }

    @Override
    public void openGui(Function<IGui, Frame> creator) {
        this.mc.method_1507((class_437)new GuiImpl(creator, this.mc.field_1755));
    }

    @Override
    public Runnable openSingleplayer() {
        return () -> this.mc.method_1507((class_437)new class_526(this.mc.field_1755));
    }

    @Override
    public NetHandler<?, ?, ?> getNetHandler() {
        return CustomPlayerModelsClient.INSTANCE.netHandler;
    }

    @Override
    public ImageIO.IImageIO getImageIO() {
        return new NativeImageIO();
    }

    @Override
    public MojangAPI getMojangAPI() {
        return new MojangAPI(this.mc.method_1548().method_1677().getName(), this.mc.method_1548().method_1677().getId(), this.mc.method_1548().method_1674());
    }

    @Override
    public void clearSkinCache() {
        MojangAPI.clearYggdrasilCache(this.mc.method_1495());
        this.mc.method_1539().clear();
        this.mc.method_1539();
    }

    @Override
    public String getConnectedServer() {
        if (this.mc.method_1562() == null) {
            return null;
        }
        SocketAddress sa = Platform.getChannel(this.mc.method_1562().method_2872()).remoteAddress();
        if (sa instanceof InetSocketAddress) {
            return ((InetSocketAddress)sa).getHostString();
        }
        return null;
    }

    @Override
    public List<Object> getPlayers() {
        if (this.mc.method_1562() == null) {
            return Collections.emptyList();
        }
        return this.mc.method_1562().method_2880().stream().map(class_640::method_2966).collect(Collectors.toList());
    }

    @Override
    public Proxy getProxy() {
        return this.mc.method_1487();
    }

    @Override
    public RenderTypeBuilder<?, ?> getRenderBuilder() {
        return this.renderBuilder;
    }

    @Override
    public AllTagManagers getBuiltinTags() {
        return this.tags;
    }

    @Override
    public BiomeHandler<?> getBiomeHandler() {
        return BiomeHandlerImpl.clientImpl;
    }

    public static class DynTexture
    implements DynamicTexture.ITexture {
        private final class_1043 dynTex = new class_1043(1, 1, true);
        private final class_2960 loc;
        private final class_310 mc;
        private static class_2960 bound_loc;

        public DynTexture(class_310 mc) {
            this.mc = mc;
            this.loc = mc.method_1531().method_4617("cpm", this.dynTex);
        }

        @Override
        public void bind() {
            bound_loc = this.loc;
            if (this.mc.method_1531().method_4619(this.loc) == null) {
                this.mc.method_1531().method_4616(this.loc, (class_1044)this.dynTex);
            }
        }

        @Override
        public void load(Image texture) {
            class_1011 ni = NativeImageIO.createFromBufferedImage(texture);
            this.dynTex.method_4526(ni);
            class_4536.method_24958((int)this.dynTex.method_4624(), (int)ni.method_4307(), (int)ni.method_4323());
            this.dynTex.method_4524();
        }

        public static class_2960 getBoundLoc() {
            return bound_loc;
        }

        @Override
        public void free() {
            this.mc.method_1531().method_4615(this.loc);
        }

        public class_1043 getDynTex() {
            return this.dynTex;
        }
    }
}

