/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.util;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.math.Box;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.MarkdownParser;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class MarkdownRenderer
extends Panel {
    private Panel panel;
    private ScrollPanel scp;
    private Map<String, Integer> headerPositions = new HashMap<String, Integer>();
    private MarkdownParser content;
    private MarkdownResourceLoader loader;
    private Set<Runnable> cleanup = new HashSet<Runnable>();
    protected Map<String, CustomMdElementFactory> customElementFactories = new HashMap<String, CustomMdElementFactory>();

    public MarkdownRenderer(IGui gui, MarkdownResourceLoader loader, String in) {
        this(gui, loader, new MarkdownParser(in));
    }

    public MarkdownRenderer(IGui gui, MarkdownResourceLoader loader, MarkdownParser parsed) {
        super(gui);
        this.content = parsed;
        this.panel = new Panel(gui);
        this.loader = loader;
        this.setBackgroundColor(gui.getColors().panel_background);
        this.scp = new ScrollPanel(gui);
        this.addElement(this.scp);
        this.scp.setDisplay(this.panel);
    }

    public void refresh() {
        this.cleanup.forEach(Runnable::run);
        this.cleanup.clear();
        this.panel.getElements().clear();
        int h = this.content.toElements(this, this.bounds.w - 15, this.panel.getElements()::addAll, this.headerPositions);
        this.panel.setBounds(new Box(0, 0, this.bounds.w - 10, h));
    }

    public void setContent(MarkdownParser content) {
        this.scp.setScrollY(0);
        this.content = content;
        if (this.bounds != null) {
            this.refresh();
        }
    }

    public Panel getPanel() {
        return this.panel;
    }

    @Override
    public GuiElement setBounds(Box bounds) {
        this.scp.setBounds(new Box(5, 0, bounds.w - 5, bounds.h));
        super.setBounds(bounds);
        this.refresh();
        return this;
    }

    public MarkdownResourceLoader getLoader() {
        return this.loader;
    }

    public void browse(String url) {
        if (url.startsWith("#")) {
            String h = url.substring(1);
            if (this.headerPositions.containsKey(h)) {
                int l = this.headerPositions.get(h);
                this.scp.setScrollY(l);
            }
        } else {
            this.loader.browse(this, url);
        }
    }

    public void cleanup() {
        this.cleanup.forEach(Runnable::run);
        this.cleanup.clear();
    }

    public void registerCleanup(Runnable r) {
        this.cleanup.add(r);
    }

    public void registerCustomElement(String id, CustomMdElementFactory func) {
        this.customElementFactories.put(id, func);
    }

    public void setLoader(MarkdownResourceLoader loader) {
        this.loader = loader;
    }

    public static interface CustomMdElementFactory {
        public List<GuiElement> create(MarkdownRenderer var1, MarkdownParser.Cursor var2, String var3);
    }

    public static interface MarkdownResourceLoader {
        public CompletableFuture<Image> loadImage(String var1);

        public void browse(MarkdownRenderer var1, String var2);
    }
}

