/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.util;

import com.tom.cpl.util.Pair;
import com.tom.cpm.externals.org.apache.maven.artifact.versioning.ComparableVersion;
import com.tom.cpm.shared.MinecraftCommonAccess;
import com.tom.cpm.shared.MinecraftObjectHolder;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.definition.ModelDefinitionLoader;
import com.tom.cpm.shared.io.HTTPIO;
import com.tom.cpm.shared.util.IVersionCheck;
import com.tom.cpm.shared.util.Log;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class VersionCheck
implements Runnable,
IVersionCheck {
    private static final String PREV_TAG = "0.0.0";
    private String version;
    private String current;
    private Map<ComparableVersion, String> changes = new LinkedHashMap<ComparableVersion, String>();
    private Map<ComparableVersion, String> allChanges = new LinkedHashMap<ComparableVersion, String>();
    private boolean outdated;
    private static VersionCheck vc;
    private static IVersionCheck platform;
    private String homepage;
    private CompletableFuture<Void> finished = new CompletableFuture();

    public VersionCheck(String version, String current) {
        this.version = version;
        this.current = current;
    }

    @Override
    public void run() {
        if (!ModConfig.getCommonConfig().getBoolean("updateChecker", true)) {
            this.finished.complete(null);
            return;
        }
        try {
            ArrayList<Object> ordered;
            Log.info("[VersionChecker] Starting CPM version checker...");
            URL url = new URL("https://raw.githubusercontent.com/tom5454/CustomPlayerModels/master/version-check.json");
            HttpURLConnection httpCon = HTTPIO.createUrlConnection(url, true);
            String data = HTTPIO.getResponse(httpCon, url);
            Map json = (Map)MinecraftObjectHolder.gson.fromJson(data, Object.class);
            Map promos = (Map)json.get("promos");
            String lat = (String)promos.get(this.version + "-latest");
            ComparableVersion current = new ComparableVersion(this.current);
            ComparableVersion target = null;
            if (lat != null) {
                target = new ComparableVersion(lat);
                this.outdated = current.compareTo(target) < 0;
            }
            Log.info("[VersionChecker] Current: " + current + " Target: " + target + " " + (this.outdated ? "Outdated" : "Up-to-date"));
            Map tmp = (Map)json.get(this.version);
            if (tmp != null) {
                ordered = new ArrayList<Object>();
                for (String string : tmp.keySet()) {
                    ComparableVersion ver = new ComparableVersion(string);
                    if (ver.compareTo(current) <= 0 || target != null && ver.compareTo(target) >= 1) continue;
                    ordered.add(ver);
                }
                Collections.sort(ordered);
                for (ComparableVersion comparableVersion : ordered) {
                    this.changes.put(comparableVersion, (String)tmp.get(comparableVersion.toString()));
                }
            }
            ordered = new ArrayList();
            ComparableVersion oldFilter = null;
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add(this.version);
            while (tmp != null) {
                for (String string : tmp.keySet()) {
                    if (string.equals(PREV_TAG)) continue;
                    ComparableVersion ver = new ComparableVersion(string);
                    if (oldFilter != null && ver.compareTo(oldFilter) > 0 || !ordered.stream().map(Pair::getKey).noneMatch(ver::equals)) continue;
                    ordered.add(Pair.of(ver, tmp.get(ver.toString())));
                }
                String prev = (String)tmp.get(PREV_TAG);
                if (prev != null && prev.indexOf(58) != -1) {
                    String[] stringArray = prev.split(":");
                    prev = stringArray[0];
                    oldFilter = new ComparableVersion(stringArray[1]);
                } else {
                    oldFilter = ordered.stream().map(Pair::getKey).sorted().findFirst().orElse(oldFilter);
                }
                if (hashSet.add(prev)) {
                    tmp = (Map)json.get(prev);
                    continue;
                }
                tmp = null;
            }
            ordered.sort(Comparator.comparing(Pair::getKey));
            for (Pair pair : ordered) {
                this.allChanges.put((ComparableVersion)pair.getKey(), (String)pair.getValue());
            }
            this.homepage = this.version.indexOf(45) > 0 ? (String)json.get("homepage-" + this.version.substring(this.version.indexOf(45) + 1)) : (String)json.get("homepage");
            this.finished.complete(null);
        }
        catch (Exception e) {
            Log.warn("CPM version check failed", e);
            this.finished.completeExceptionally(e);
        }
    }

    public Map<ComparableVersion, String> getAllChanges() {
        return this.allChanges;
    }

    public Map<ComparableVersion, String> getChangesV() {
        return this.changes;
    }

    @Override
    public Map<String, String> getChanges() {
        return this.changes.entrySet().stream().map(e -> Pair.of(((ComparableVersion)e.getKey()).toString(), e.getValue())).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    @Override
    public boolean isOutdated() {
        return this.outdated;
    }

    public String getHomepage() {
        return this.homepage;
    }

    public static void main(String[] args) {
        VersionCheck vc = new VersionCheck("1.19", "0.4.3a");
        vc.run();
        System.out.println(vc.getAllChanges().keySet());
    }

    public static VersionCheck get(String mcVersion, String modVersion) {
        if (vc == null) {
            vc = new VersionCheck(mcVersion, modVersion);
            ModelDefinitionLoader.THREAD_POOL.execute(vc);
        }
        return vc;
    }

    public static VersionCheck get() {
        return VersionCheck.get(MinecraftCommonAccess.get().getMCVersion(), MinecraftCommonAccess.get().getModVersion());
    }

    public static <CV> IVersionCheck get(Supplier<Map<CV, String>> changes) {
        if (platform == null) {
            platform = new PlatformCheck<CV>(changes);
        }
        return platform;
    }

    public CompletableFuture<Void> getFinished() {
        return this.finished;
    }

    private static class PlatformCheck<CV>
    implements IVersionCheck {
        private final Supplier<Map<CV, String>> changes;
        private Map<CV, String> c;

        public PlatformCheck(Supplier<Map<CV, String>> changes) {
            this.changes = changes;
        }

        private Map<CV, String> getC() {
            if (this.c == null) {
                this.c = this.changes.get();
            }
            if (this.c == null) {
                return Collections.emptyMap();
            }
            return this.c;
        }

        @Override
        public boolean isOutdated() {
            return !this.getC().isEmpty();
        }

        @Override
        public Map<String, String> getChanges() {
            return this.getC().entrySet().stream().map(e -> Pair.of(e.getKey().toString(), e.getValue())).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
        }
    }
}

