/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.gui;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeybindHandler;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.ButtonIcon;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.MathHelper;
import com.tom.cpl.util.EmbeddedLocalization;
import com.tom.cpm.shared.editor.gui.popup.WikiBrowserPopup;
import com.tom.cpm.shared.gui.Keybinds;
import java.io.File;
import java.util.List;

public abstract class Frame
extends Panel {
    protected PopupPanels popup = new PopupPanels();
    protected Tooltip tooltipBox;
    private KeybindHandler keybindHandler;

    public Frame(IGui gui) {
        super(gui);
        this.keybindHandler = new KeybindHandler(gui);
    }

    @Override
    public void keyPressed(KeyboardEvent event) {
        if (this.tooltipBox != null && this.tooltipBox.getWikiPage() != null) {
            String w = this.tooltipBox.getWikiPage();
            this.keybindHandler.registerKeybindInPopups(Keybinds.OPEN_WIKI, () -> this.openPopup(new WikiBrowserPopup(this.gui, EmbeddedLocalization.getLocalizedWikiPage(this.gui, "https://github.com/tom5454/CustomPlayerModels/wiki/" + w))));
        }
        super.keyPressed(event);
        if (event.matches(this.gui.getKeyCodes().KEY_ESCAPE)) {
            this.onClosing();
            event.consume();
        }
        this.keybindHandler.keyEvent(event, false);
    }

    protected void onClosing() {
        this.gui.closeGui();
    }

    public final void init(int width, int height) {
        this.setBounds(new Box(0, 0, width, height));
        this.elements.clear();
        this.initFrame(width, height);
        this.elements.remove(this.popup);
        this.addElement(this.popup);
        this.popup.getElements().forEach(e -> {
            if (e instanceof PopupLayer) {
                ((PopupLayer)e).onInit();
            }
        });
    }

    public void draw(int mouseX, int mouseY, float partialTicks) {
        this.tooltipBox = null;
        this.draw(new MouseEvent(mouseX, mouseY, 0), partialTicks);
        if (this.tooltipBox != null) {
            Box b = this.tooltipBox.getBounds();
            int tx = Math.min(mouseX + b.w + 5, this.bounds.w - 1);
            int ty = Math.min(mouseY + b.h + 5, this.bounds.h - 1);
            this.tooltipBox.setBounds(new Box(tx - b.w, ty - b.h, b.w, b.h));
            this.tooltipBox.draw(new MouseEvent(Integer.MAX_VALUE, Integer.MAX_VALUE, 0), partialTicks);
        }
    }

    @Override
    public void draw(MouseEvent event, float partialTicks) {
        this.gui.pushMatrix();
        this.gui.setPosOffset(this.getBounds());
        this.gui.setupCut();
        Box bounds = this.getBounds();
        if (this.backgroundColor != 0) {
            this.gui.drawBox(0, 0, bounds.w, bounds.h, this.backgroundColor);
        }
        for (GuiElement guiElement : this.elements) {
            if (!guiElement.isVisible()) continue;
            if (guiElement == this.popup || this.popup.getElements().isEmpty()) {
                guiElement.draw(event.offset(bounds), partialTicks);
                continue;
            }
            guiElement.draw(event.offset(bounds).cancelled(), partialTicks);
        }
        this.gui.popMatrix();
        this.gui.setupCut();
    }

    public abstract void initFrame(int var1, int var2);

    public void openPopup(PopupPanel popup) {
        for (GuiElement e : this.popup.getElements()) {
            PopupLayer l;
            if (!(e instanceof PopupLayer) || (l = (PopupLayer)e).popup != popup) continue;
            this.popup.remove(l);
            this.popup.add(l);
            return;
        }
        this.popup.add(new PopupLayer(popup));
    }

    public Box getMinBounds() {
        return new Box(0, 0, 0, 0);
    }

    public void setTooltip(Tooltip tooltip) {
        this.tooltipBox = tooltip;
    }

    public void tick() {
    }

    public void logMessage(String msg) {
    }

    public boolean enableChat() {
        return false;
    }

    public void filesDropped(List<File> files) {
        this.popup.filesDropped(files);
    }

    public KeybindHandler getKeybindHandler() {
        return this.keybindHandler;
    }

    public void onCrashed(String msg, Throwable e) {
    }

    public boolean hasPopupOpen() {
        return !this.popup.getElements().isEmpty();
    }

    public class PopupLayer
    extends Panel {
        private Button close;
        private PopupPanel popup;
        private TitleBar title;
        private boolean closing;
        private boolean rendering;
        private int highlightPopup;

        public PopupLayer(PopupPanel panel) {
            super(Frame.this.gui);
            this.setBackgroundColor(this.gui.getColors().popup_background);
            this.popup = panel;
            if (panel.hasDecoration()) {
                this.close = new ButtonIcon(this.gui, "editor", 16, 0, true, this.popup::close);
                this.addElement(this.close);
                this.title = new TitleBar(this.gui, panel.getTitle());
                this.addElement(this.title);
                this.title.setBounds(new Box(1, 1, 0, 0));
            }
            this.addElement(panel);
            panel.setLayer(this);
            this.setPopupPosition();
        }

        public void onInit() {
            this.popup.onInit();
            this.setPopupPosition();
        }

        private void setPopupPosition() {
            Box pb = this.popup.getBounds();
            if (!this.popup.hasDecoration()) {
                this.setBounds(new Box(pb.x, pb.y, pb.w, pb.h));
                this.popup.setBounds(new Box(0, 0, pb.w, pb.h));
            } else {
                Box bounds = Frame.this.getBounds();
                this.setBounds(new Box(bounds.w / 2 - pb.w / 2 - 1, bounds.h / 2 - pb.h / 2 - 6, pb.w + 2, pb.h + 12));
                this.popup.setBounds(new Box(1, 12, pb.w, pb.h));
                this.close.setBounds(new Box(pb.w - 10, 0, 12, 12));
                this.title.setBounds(new Box(1, 1, pb.w - 12, 10));
            }
        }

        public void filesDropped(List<File> files) {
            this.popup.filesDropped(files);
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            this.rendering = true;
            this.gui.pushMatrix();
            this.gui.setPosOffset(this.bounds);
            this.gui.setupCut();
            this.gui.drawBox(0, 0, this.bounds.w, this.bounds.h, this.highlightPopup % 10 > 5 ? this.gui.getColors().popup_border_notify : this.gui.getColors().popup_border);
            this.gui.drawBox(1, 1, this.bounds.w - 2, this.bounds.h - 2, this.gui.getColors().popup_background);
            for (GuiElement guiElement : this.elements) {
                if (!guiElement.isVisible()) continue;
                guiElement.draw(event.offset(this.bounds), partialTicks);
            }
            this.gui.popMatrix();
            this.gui.setupCut();
            this.rendering = false;
            if (this.highlightPopup > 0) {
                --this.highlightPopup;
            }
        }

        @Override
        public void mouseClick(MouseEvent event) {
            super.mouseClick(event);
            if (!event.isConsumed() && !event.isInBounds(this.bounds)) {
                this.highlightPopup = 20;
            }
            event.consume();
        }

        @Override
        public void mouseDrag(MouseEvent event) {
            super.mouseDrag(event);
            event.consume();
        }

        @Override
        public void mouseRelease(MouseEvent event) {
            super.mouseRelease(event);
            event.consume();
        }

        @Override
        public void mouseWheel(MouseEvent event) {
            super.mouseWheel(event);
            event.consume();
        }

        @Override
        public void keyPressed(KeyboardEvent event) {
            super.keyPressed(event);
            if (event.matches(this.gui.getKeyCodes().KEY_ESCAPE)) {
                if (this.popup.onEscape()) {
                    event.consume();
                }
            } else {
                Frame.this.keybindHandler.keyEvent(event, true);
                event.consume();
            }
        }

        public void close() {
            if (this.rendering) {
                this.closing = true;
            } else {
                Frame.this.popup.remove(this);
                this.popup.onClosed();
            }
        }

        public boolean handleClosing() {
            if (this.closing) {
                this.popup.onClosed();
                return true;
            }
            return false;
        }

        public void updateTitle() {
            this.title.setText(this.popup.getTitle());
        }

        private class TitleBar
        extends Panel {
            private Label titleLbl;
            private boolean dragging;
            private int dragX;
            private int dragY;

            public TitleBar(IGui gui, String title) {
                super(gui);
                this.titleLbl = new Label(gui, title);
                this.titleLbl.setBounds(new Box(1, 1, 0, 0));
                this.addElement(this.titleLbl);
            }

            public void setText(String title) {
                this.titleLbl.setText(title);
            }

            @Override
            public void mouseClick(MouseEvent event) {
                if (event.btn == 0 && event.isInBounds(this.bounds)) {
                    this.dragging = true;
                    this.dragX = event.x;
                    this.dragY = event.y;
                    event.consume();
                }
            }

            @Override
            public void mouseDrag(MouseEvent event) {
                if (this.dragging) {
                    Box b = PopupLayer.this.getBounds();
                    int x = b.x + event.x - this.dragX;
                    int y = b.y + event.y - this.dragY;
                    x = MathHelper.clamp(x, 0, ((Frame)Frame.this).bounds.w - b.w);
                    y = MathHelper.clamp(y, 0, ((Frame)Frame.this).bounds.h - b.h);
                    PopupLayer.this.setBounds(new Box(x, y, b.w, b.h));
                    event.consume();
                }
            }

            @Override
            public void mouseRelease(MouseEvent event) {
                if (event.btn == 0 && this.dragging) {
                    this.dragging = false;
                    event.consume();
                }
            }
        }
    }

    private class PopupPanels
    extends Panel {
        public PopupPanels() {
            super(Frame.this.gui);
        }

        public void add(PopupLayer popupLayer) {
            this.addElement(popupLayer);
        }

        public void remove(PopupLayer popupLayer) {
            this.elements.remove(popupLayer);
        }

        @Override
        public Box getBounds() {
            return Frame.this.bounds;
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            if (this.elements.isEmpty()) {
                return;
            }
            this.gui.pushMatrix();
            this.gui.setPosOffset(this.getBounds());
            this.gui.setupCut();
            Box bounds = this.getBounds();
            GuiElement top = null;
            for (GuiElement guiElement : this.elements) {
                if (!guiElement.isVisible()) continue;
                top = guiElement;
            }
            for (GuiElement guiElement : this.elements) {
                if (!guiElement.isVisible()) continue;
                if (guiElement == top) {
                    guiElement.draw(event.offset(bounds), partialTicks);
                    continue;
                }
                guiElement.draw(event.offset(bounds).cancelled(), partialTicks);
            }
            this.elements.removeIf(e -> e instanceof PopupLayer && ((PopupLayer)e).handleClosing());
            this.gui.popMatrix();
            this.gui.setupCut();
        }

        public void filesDropped(List<File> files) {
            GuiElement top = null;
            for (GuiElement guiElement : this.elements) {
                if (!guiElement.isVisible()) continue;
                top = guiElement;
            }
            if (top != null && top instanceof PopupLayer) {
                ((PopupLayer)top).filesDropped(files);
            }
        }
    }
}

