/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm;

import com.tom.cpl.block.BlockStateHandler;
import com.tom.cpl.block.entity.EntityTypeHandler;
import com.tom.cpl.config.ModConfigFile;
import com.tom.cpl.item.ItemStackHandler;
import com.tom.cpl.text.TextRemapper;
import com.tom.cpl.text.TextStyle;
import com.tom.cpl.util.ILogger;
import com.tom.cpm.Log4JLogger;
import com.tom.cpm.api.CPMApiManager;
import com.tom.cpm.common.BlockStateHandlerImpl;
import com.tom.cpm.common.EntityTypeHandlerImpl;
import com.tom.cpm.common.ItemStackHandlerImpl;
import com.tom.cpm.shared.MinecraftCommonAccess;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.KeybindTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CommonBase
implements MinecraftCommonAccess {
    public static final Logger LOG = LogManager.getLogger((String)"CPM");
    public static final ILogger log = new Log4JLogger(LOG);
    public static CPMApiManager api;
    protected ModConfigFile cfg;

    public CommonBase() {
        api = new CPMApiManager();
    }

    protected void apiInit() {
        LOG.info("Customizable Player Models API initialized: " + api.getPluginStatus());
        api.buildCommon().player(PlayerEntity.class).init();
    }

    @Override
    public ModConfigFile getConfig() {
        return this.cfg;
    }

    @Override
    public ILogger getLogger() {
        return log;
    }

    public TextRemapper<ITextComponent> getTextRemapper() {
        return new TextRemapper<ITextComponent>(TranslationTextComponent::new, StringTextComponent::new, ITextComponent::func_150257_a, KeybindTextComponent::new, CommonBase::styleText);
    }

    private static ITextComponent styleText(ITextComponent in, TextStyle style) {
        return in.func_211710_a(s -> s.func_150227_a(Boolean.valueOf(style.bold)).func_150217_b(Boolean.valueOf(style.italic)).func_150228_d(Boolean.valueOf(style.underline)).func_150225_c(Boolean.valueOf(style.strikethrough)));
    }

    @Override
    public CPMApiManager getApi() {
        return api;
    }

    @Override
    public String getMCVersion() {
        return SharedConstants.func_215069_a().getName();
    }

    @Override
    public BlockStateHandler<?> getBlockStateHandler() {
        return BlockStateHandlerImpl.impl;
    }

    @Override
    public ItemStackHandler<?> getItemStackHandler() {
        return ItemStackHandlerImpl.impl;
    }

    @Override
    public EntityTypeHandler<?> getEntityTypeHandler() {
        return EntityTypeHandlerImpl.impl;
    }
}

