/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.blaze3d.platform.GlStateManager;
import com.tom.cpl.text.FormatText;
import com.tom.cpm.CustomPlayerModels;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.PlayerProfile;
import com.tom.cpm.common.PlayerAnimUpdater;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.model.RenderManager;
import com.tom.cpm.shared.model.TextureSheetType;
import com.tom.cpm.shared.network.NetHandler;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.ElytraModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CCustomPayloadPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;

public class ClientBase {
    public static final ResourceLocation DEFAULT_CAPE = new ResourceLocation("cpm:textures/template/cape.png");
    public static MinecraftObject mc;
    public Minecraft minecraft;
    public RenderManager<GameProfile, PlayerEntity, Model, Void> manager;
    public NetHandler<ResourceLocation, PlayerEntity, ClientPlayNetHandler> netHandler;

    public void init0() {
        this.minecraft = Minecraft.func_71410_x();
        mc = new MinecraftObject(this.minecraft);
    }

    public void init1() {
        this.manager = new RenderManager<GameProfile, PlayerEntity, Model, Void>(mc.getPlayerRenderManager(), mc.getDefinitionLoader(), PlayerProfile::getPlayerProfile);
        this.manager.setGPGetters(GameProfile::getProperties, Property::getValue);
        this.netHandler = new NetHandler(ResourceLocation::new);
        this.netHandler.setExecutor(() -> this.minecraft);
        this.netHandler.setSendPacketClient(d -> new PacketBuffer(Unpooled.wrappedBuffer((byte[])d)), (c, rl, pb) -> c.func_147297_a((IPacket)new CCustomPayloadPacket(rl, pb)));
        this.netHandler.setPlayerToLoader(PlayerEntity::func_146103_bH);
        this.netHandler.setGetPlayerById(id -> {
            Entity ent = Minecraft.func_71410_x().field_71441_e.func_73045_a(id);
            if (ent instanceof PlayerEntity) {
                return (PlayerEntity)ent;
            }
            return null;
        });
        this.netHandler.setGetClient(() -> this.minecraft.field_71439_g);
        this.netHandler.setGetNet(c -> ((ClientPlayerEntity)c).field_71174_a);
        this.netHandler.setDisplayText(f -> this.minecraft.field_71439_g.func_146105_b((ITextComponent)f.remap(), false));
        this.netHandler.setGetPlayerAnimGetters(new PlayerAnimUpdater());
    }

    public static void apiInit() {
        CustomPlayerModels.api.buildClient().voicePlayer(PlayerEntity.class, Entity::func_110124_au).renderApi(Model.class, GameProfile.class).localModelApi(GameProfile::new).init();
    }

    public void playerRenderPre(PlayerEntity player, PlayerModel model) {
        this.manager.bindPlayer(player, null, (Model)model);
        this.manager.bindSkin((Model)model, TextureSheetType.SKIN);
    }

    public void playerRenderPost(PlayerModel model) {
        this.manager.unbindClear((Model)model);
    }

    public void renderHand(PlayerModel model) {
        this.manager.bindHand((PlayerEntity)Minecraft.func_71410_x().field_71439_g, null, (Model)model);
        this.manager.bindSkin((Model)model, TextureSheetType.SKIN);
    }

    public void renderHandPost(BipedModel model) {
        this.manager.unbindClear((Model)model);
    }

    public void renderSkull(Model skullModel, GameProfile profile) {
        this.manager.bindSkull(profile, null, skullModel);
        this.manager.bindSkin(skullModel, TextureSheetType.SKIN);
    }

    public void renderSkullPost(Model model) {
        this.manager.unbindFlush(model);
    }

    public void renderElytra(BipedModel<LivingEntity> player, ElytraModel<LivingEntity> model) {
        this.manager.bindElytra((Model)player, (Model)model);
        this.manager.bindSkin((Model)model, TextureSheetType.ELYTRA);
    }

    public void renderArmor(BipedModel<LivingEntity> modelArmor, BipedModel<LivingEntity> modelLeggings, BipedModel<LivingEntity> player) {
        this.manager.bindArmor((Model)player, (Model)modelArmor, 1);
        this.manager.bindArmor((Model)player, (Model)modelLeggings, 2);
        this.manager.bindSkin((Model)modelArmor, TextureSheetType.ARMOR1);
        this.manager.bindSkin((Model)modelLeggings, TextureSheetType.ARMOR2);
    }

    public void updateJump() {
        if (this.minecraft.field_71439_g.field_70122_E && this.minecraft.field_71439_g.field_71158_b.field_78901_c) {
            this.manager.jump((PlayerEntity)this.minecraft.field_71439_g);
        }
    }

    public static void renderCape(AbstractClientPlayerEntity playerIn, float partialTicks, PlayerModel<AbstractClientPlayerEntity> model, ModelDefinition modelDefinition) {
        float f3;
        float f2;
        float f1;
        GlStateManager.pushMatrix();
        if (playerIn != null) {
            double d0 = MathHelper.func_219803_d((double)partialTicks, (double)playerIn.field_71091_bM, (double)playerIn.field_71094_bP) - MathHelper.func_219803_d((double)partialTicks, (double)playerIn.field_70169_q, (double)playerIn.field_70165_t);
            double d1 = MathHelper.func_219803_d((double)partialTicks, (double)playerIn.field_71096_bN, (double)playerIn.field_71095_bQ) - MathHelper.func_219803_d((double)partialTicks, (double)playerIn.field_70167_r, (double)playerIn.field_70163_u);
            double d2 = MathHelper.func_219803_d((double)partialTicks, (double)playerIn.field_71097_bO, (double)playerIn.field_71085_bR) - MathHelper.func_219803_d((double)partialTicks, (double)playerIn.field_70166_s, (double)playerIn.field_70161_v);
            float f = playerIn.field_70760_ar + (playerIn.field_70761_aq - playerIn.field_70760_ar);
            double d3 = MathHelper.func_76126_a((float)(f * ((float)Math.PI / 180)));
            double d4 = -MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
            f1 = (float)d1 * 10.0f;
            f1 = MathHelper.func_76131_a((float)f1, (float)-6.0f, (float)32.0f);
            f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
            f2 = MathHelper.func_76131_a((float)f2, (float)0.0f, (float)150.0f);
            f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
            f3 = MathHelper.func_76131_a((float)f3, (float)-20.0f, (float)20.0f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            float f4 = MathHelper.func_219799_g((float)partialTicks, (float)playerIn.field_71107_bF, (float)playerIn.field_71109_bG);
            f1 += MathHelper.func_76126_a((float)(MathHelper.func_219799_g((float)partialTicks, (float)playerIn.field_70141_P, (float)playerIn.field_70140_Q) * 6.0f)) * 32.0f * f4;
            if (playerIn.func_213287_bg()) {
                f1 += 25.0f;
            }
            if (playerIn.func_184582_a(EquipmentSlotType.CHEST).func_190926_b()) {
                if (playerIn.func_213287_bg()) {
                    model.field_178729_w.field_78798_e = 1.775f;
                    model.field_178729_w.field_78797_d = 2.35f;
                } else {
                    model.field_178729_w.field_78798_e = 2.0f;
                    model.field_178729_w.field_78797_d = 0.0f;
                }
            } else if (playerIn.func_213287_bg()) {
                model.field_178729_w.field_78798_e = 2.3f;
                model.field_178729_w.field_78797_d = 1.1f;
            } else {
                model.field_178729_w.field_78798_e = 2.9f;
                model.field_178729_w.field_78797_d = 0.14999998f;
            }
        } else {
            f1 = 0.0f;
            f2 = 0.0f;
            f3 = 0.0f;
        }
        model.field_178729_w.field_78795_f = (float)(-Math.toRadians(6.0f + f2 / 2.0f + f1));
        model.field_178729_w.field_78796_g = (float)Math.toRadians(180.0f - f3 / 2.0f);
        model.field_178729_w.field_78808_h = (float)Math.toRadians(f3 / 2.0f);
        mc.getPlayerRenderManager().setModelPose(model);
        model.field_178729_w.field_78795_f = 0.0f;
        model.field_178729_w.field_78796_g = 0.0f;
        model.field_178729_w.field_78808_h = 0.0f;
        model.func_178728_c(0.0625f);
        GlStateManager.popMatrix();
    }

    public <E extends Entity> void renderNameTag(PlayerNameTagRenderer<E> r, E entityIn, GameProfile gprofile, String unique, double x, double y, double z, double d0) {
        FormatText st;
        if (d0 < 1024.0 && (st = this.manager.getStatus(gprofile, unique)) != null) {
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.0f, (float)1.3f, (float)0.0f);
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            r.cpm$renderNameTag(entityIn, ((ITextComponent)st.remap()).func_150254_d(), x, y, z, d0);
            GlStateManager.popMatrix();
        }
    }

    public static interface PlayerNameTagRenderer<E extends Entity> {
        public void cpm$renderNameTag(E var1, String var2, double var3, double var5, double var7, double var9);

        public EntityRendererManager cpm$entityRenderDispatcher();
    }
}

