/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.tom.cpm.client.ClientBase;
import com.tom.cpm.client.GuiBase;
import com.tom.cpm.client.GuiImpl;
import com.tom.cpm.client.KeyBindings;
import com.tom.cpm.client.PlayerProfile;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.gui.GestureGui;
import com.tom.cpm.shared.gui.SettingsGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.CustomizeSkinScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;

public class CustomPlayerModelsClient
extends ClientBase {
    public static final CustomPlayerModelsClient INSTANCE = new CustomPlayerModelsClient();

    public void init() {
        this.init0();
        MinecraftForge.EVENT_BUS.register((Object)this);
        KeyBindings.init();
        this.init1();
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (mc, scr) -> new GuiImpl(SettingsGui::new, (Screen)scr));
    }

    @SubscribeEvent
    public void playerRenderPre(RenderPlayerEvent.Pre event) {
        this.playerRenderPre(event.getPlayer(), (PlayerModel)event.getRenderer().func_217764_d());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void playerRenderPreC(RenderPlayerEvent.Pre event) {
        if (event.isCanceled()) {
            this.playerRenderPost((PlayerModel)event.getRenderer().func_217764_d());
        }
    }

    @SubscribeEvent
    public void playerRenderPost(RenderPlayerEvent.Post event) {
        this.playerRenderPost((PlayerModel)event.getRenderer().func_217764_d());
    }

    @SubscribeEvent
    public void initGui(GuiScreenEvent.InitGuiEvent.Post evt) {
        if (evt.getGui() instanceof MainMenuScreen && ModConfig.getCommonConfig().getSetBoolean("titleScreenButton", true) || evt.getGui() instanceof CustomizeSkinScreen) {
            evt.addWidget((Widget)new Button(0, 0, () -> Minecraft.func_71410_x().func_147108_a((Screen)new GuiImpl(EditorGui::new, evt.getGui()))));
        }
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START) {
            mc.getPlayerRenderManager().getAnimationEngine().update(evt.renderTickTime);
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START && !this.minecraft.func_147113_T()) {
            mc.getPlayerRenderManager().getAnimationEngine().tick();
        }
        if (this.minecraft.field_71439_g == null || evt.phase == TickEvent.Phase.START) {
            return;
        }
        if (KeyBindings.gestureMenuBinding.func_151468_f()) {
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiImpl(GestureGui::new, null));
        }
        if (KeyBindings.renderToggleBinding.func_151468_f()) {
            Player.setEnableRendering(!Player.isEnableRendering());
        }
        mc.getPlayerRenderManager().getAnimationEngine().updateKeys(KeyBindings.quickAccess);
    }

    @SubscribeEvent
    public void openGui(GuiOpenEvent openGui) {
        if (openGui.getGui() == null && this.minecraft.field_71462_r instanceof GuiBase.Overlay) {
            openGui.setGui(((GuiBase.Overlay)this.minecraft.field_71462_r).getGui());
        }
        if (openGui.getGui() instanceof MainMenuScreen && EditorGui.doOpenEditor()) {
            openGui.setGui((Screen)new GuiImpl(EditorGui::new, openGui.getGui()));
        }
        if (openGui.getGui() instanceof GuiImpl) {
            ((GuiImpl)openGui.getGui()).onOpened();
        }
    }

    @SubscribeEvent
    public void drawGuiPre(GuiScreenEvent.DrawScreenEvent.Pre evt) {
        PlayerProfile.inGui = true;
    }

    @SubscribeEvent
    public void drawGuiPost(GuiScreenEvent.DrawScreenEvent.Post evt) {
        PlayerProfile.inGui = false;
    }

    @SubscribeEvent
    public void onLogout(ClientPlayerNetworkEvent.LoggedOutEvent evt) {
        mc.onLogOut();
    }

    public static class Button
    extends net.minecraft.client.gui.widget.button.Button {
        public Button(int x, int y, Runnable r) {
            super(x, y, 100, 20, I18n.func_135052_a((String)"button.cpm.open_editor", (Object[])new Object[0]), b -> r.run());
        }
    }
}

