/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.KeyCodes;
import com.tom.cpl.gui.KeyboardEvent;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.NativeGuiComponents;
import com.tom.cpl.gui.UIColors;
import com.tom.cpl.gui.elements.FileChooserPopup;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.item.Stack;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.text.IText;
import com.tom.cpm.client.ErrorChooser;
import com.tom.cpm.client.GLFWKeyCodes;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.Panel3dImpl;
import com.tom.cpm.client.Platform;
import com.tom.cpm.common.ItemStackHandlerImpl;
import com.tom.cpm.shared.MinecraftCommonAccess;
import com.tom.cpm.shared.gui.panel.Panel3d;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ChatVisibility;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.opengl.GL11;

public class GuiBase
extends Screen
implements IGui {
    protected static final KeyCodes CODES = new GLFWKeyCodes();
    protected static final NativeGuiComponents nativeComponents = new NativeGuiComponents();
    protected Frame gui;
    protected Screen parent;
    protected IGui.CtxStack stack;
    protected UIColors colors = new UIColors();
    protected Consumer<Runnable> closeListener;
    protected int keyModif;
    protected boolean noScissorTest;
    protected int vanillaScale = -1;

    public GuiBase(Function<IGui, Frame> creator, Screen parent) {
        super((ITextComponent)new StringTextComponent(""));
        this.parent = parent;
        try {
            this.gui = creator.apply(this);
        }
        catch (Throwable e) {
            this.onGuiException("Error creating gui", e, true);
        }
        this.noScissorTest = this.isCtrlDown();
    }

    private static <G extends Supplier<IGui>, N> NativeGuiComponents.NativeConstructor<G, N> local(Function<GuiBase, N> fac) {
        return f -> fac.apply((GuiBase)f.get());
    }

    public boolean isPauseScreen() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(int mouseX, int mouseY, float partialTicks) {
        block8: {
            this.renderBackground(0);
            try {
                GlStateManager.pushMatrix();
                GlStateManager.translated((double)0.0, (double)0.0, (double)500.0);
                GL11.glEnable((int)3089);
                this.stack = new IGui.CtxStack(this.width, this.height);
                this.gui.draw(mouseX, mouseY, partialTicks);
                if (this.noScissorTest) break block8;
            }
            catch (Throwable e) {
                block9: {
                    try {
                        this.onGuiException("Error drawing gui", e, true);
                        if (this.noScissorTest) break block9;
                    }
                    catch (Throwable throwable) {
                        if (!this.noScissorTest) {
                            GL11.glDisable((int)3089);
                        }
                        String modVer = MinecraftCommonAccess.get().getModVersion();
                        String s = "Minecraft " + SharedConstants.func_215069_a().getName() + " (" + this.minecraft.func_175600_c() + "/" + ClientBrandRetriever.getClientModName() + ("release".equalsIgnoreCase(this.minecraft.func_184123_d()) ? "" : "/" + this.minecraft.func_184123_d()) + ") " + modVer;
                        this.font.func_211126_b(s, (float)(this.width - this.font.func_78256_a(s) - 4), 2.0f, -16777216);
                        s = this.minecraft.field_71426_K;
                        if (this.noScissorTest) {
                            s = s + " No Scissor";
                        }
                        this.font.func_211126_b(s, (float)(this.width - this.font.func_78256_a(s) - 4), 11.0f, -16777216);
                        GlStateManager.popMatrix();
                        throw throwable;
                    }
                    GL11.glDisable((int)3089);
                }
                String modVer = MinecraftCommonAccess.get().getModVersion();
                String s = "Minecraft " + SharedConstants.func_215069_a().getName() + " (" + this.minecraft.func_175600_c() + "/" + ClientBrandRetriever.getClientModName() + ("release".equalsIgnoreCase(this.minecraft.func_184123_d()) ? "" : "/" + this.minecraft.func_184123_d()) + ") " + modVer;
                this.font.func_211126_b(s, (float)(this.width - this.font.func_78256_a(s) - 4), 2.0f, -16777216);
                s = this.minecraft.field_71426_K;
                if (this.noScissorTest) {
                    s = s + " No Scissor";
                }
                this.font.func_211126_b(s, (float)(this.width - this.font.func_78256_a(s) - 4), 11.0f, -16777216);
                GlStateManager.popMatrix();
            }
            GL11.glDisable((int)3089);
        }
        String modVer = MinecraftCommonAccess.get().getModVersion();
        String s = "Minecraft " + SharedConstants.func_215069_a().getName() + " (" + this.minecraft.func_175600_c() + "/" + ClientBrandRetriever.getClientModName() + ("release".equalsIgnoreCase(this.minecraft.func_184123_d()) ? "" : "/" + this.minecraft.func_184123_d()) + ") " + modVer;
        this.font.func_211126_b(s, (float)(this.width - this.font.func_78256_a(s) - 4), 2.0f, -16777216);
        s = this.minecraft.field_71426_K;
        if (this.noScissorTest) {
            s = s + " No Scissor";
        }
        this.font.func_211126_b(s, (float)(this.width - this.font.func_78256_a(s) - 4), 11.0f, -16777216);
        GlStateManager.popMatrix();
    }

    public void removed() {
        this.minecraft.field_195559_v.func_197967_a(false);
        if (this.vanillaScale >= 0 && this.vanillaScale != this.minecraft.field_71474_y.field_74335_Z) {
            this.minecraft.field_71474_y.field_74335_Z = this.vanillaScale;
            this.vanillaScale = -999;
            this.minecraft.func_213226_a();
        }
    }

    public void onClose() {
        Screen p = this.parent;
        this.parent = null;
        this.minecraft.func_147108_a(p);
    }

    @Override
    public void drawBox(int x, int y, int w, int h, int color) {
        GuiBase.fill((int)(x += this.getOffset().x), (int)(y += this.getOffset().y), (int)(x + w), (int)(y + h), (int)color);
    }

    @Override
    public void drawBox(float x, float y, float w, float h, int color) {
        float minX = x += (float)this.getOffset().x;
        float minY = y += (float)this.getOffset().y;
        float maxX = x + w;
        float maxY = y + h;
        if (minX < maxX) {
            float i = minX;
            minX = maxX;
            maxX = i;
        }
        if (minY < maxY) {
            float j = minY;
            minY = maxY;
            maxY = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.enableBlend();
        GlStateManager.disableTexture();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)minX, (double)maxY, 0.0).func_181666_a(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_181662_b((double)maxX, (double)maxY, 0.0).func_181666_a(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_181662_b((double)maxX, (double)minY, 0.0).func_181666_a(f, f1, f2, f3).func_181675_d();
        bufferbuilder.func_181662_b((double)minX, (double)minY, 0.0).func_181666_a(f, f1, f2, f3).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.enableTexture();
        GlStateManager.disableBlend();
    }

    protected void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        try {
            this.gui.init(this.width, this.height);
        }
        catch (Throwable e) {
            this.onGuiException("Error in init gui", e, true);
        }
    }

    @Override
    public void drawText(int x, int y, String text, int color) {
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)50.0f);
        this.font.func_211126_b(text, (float)(x += this.getOffset().x), (float)(y += this.getOffset().y), color);
        GlStateManager.popMatrix();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        try {
            this.keyModif = modifiers;
            KeyboardEvent evt = new KeyboardEvent(keyCode, scanCode, '\uffff', GLFW.glfwGetKeyName((int)keyCode, (int)scanCode));
            this.gui.keyPressed(evt);
            if (!evt.isConsumed() && this.gui.enableChat() && this.gui.enableChat() && this.minecraft.field_71439_g != null && this.minecraft.field_71474_y.field_74310_D.func_197976_a(keyCode, scanCode) && this.minecraft.field_71474_y.field_74343_n != ChatVisibility.HIDDEN) {
                Minecraft.func_71410_x().func_212871_a_(() -> {
                    int scale = this.vanillaScale;
                    this.vanillaScale = -1;
                    this.minecraft.func_147108_a((Screen)new Overlay());
                    this.vanillaScale = scale;
                });
                return true;
            }
            return true;
        }
        catch (Throwable e) {
            this.onGuiException("Error processing key event", e, false);
            return true;
        }
    }

    public boolean charTyped(char codePoint, int modifiers) {
        try {
            this.keyModif = modifiers;
            KeyboardEvent evt = new KeyboardEvent(-1, -1, codePoint, null);
            this.gui.keyPressed(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing key event", e, false);
            return true;
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        try {
            MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, button);
            this.gui.mouseClick(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
            return true;
        }
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        try {
            MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, button);
            this.gui.mouseDrag(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
            return true;
        }
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        try {
            MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, button);
            this.gui.mouseRelease(evt);
            return evt.isConsumed();
        }
        catch (Throwable e) {
            this.onGuiException("Error processing mouse event", e, false);
            return true;
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        if (delta != 0.0) {
            try {
                MouseEvent evt = new MouseEvent((int)mouseX, (int)mouseY, (int)delta);
                this.gui.mouseWheel(evt);
                return evt.isConsumed();
            }
            catch (Throwable e) {
                this.onGuiException("Error processing mouse event", e, false);
                return true;
            }
        }
        return false;
    }

    @Override
    public void displayError(String e) {
        Screen p = this.parent;
        this.parent = null;
        Minecraft.func_71410_x().func_147108_a((Screen)new CrashScreen(e, p));
    }

    @Override
    public void closeGui() {
        if (this.closeListener != null) {
            this.closeListener.accept(this::onClose);
        } else {
            this.onClose();
        }
    }

    @Override
    public void drawTexture(int x, int y, int w, int h, int u, int v, String texture) {
        this.minecraft.func_110434_K().func_110577_a(new ResourceLocation("cpm", "textures/gui/" + texture + ".png"));
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        this.blit(x += this.getOffset().x, y += this.getOffset().y, u, v, w, h);
        GlStateManager.disableBlend();
    }

    @Override
    public void drawTexture(int x, int y, int w, int h, int u, int v, String texture, int color) {
        this.minecraft.func_110434_K().func_110577_a(new ResourceLocation("cpm", "textures/gui/" + texture + ".png"));
        x += this.getOffset().x;
        y += this.getOffset().y;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GlStateManager.color4f((float)r, (float)g, (float)b, (float)a);
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        this.blit(x, y, u, v, w, h);
        GlStateManager.disableBlend();
    }

    @Override
    public void drawTexture(int x, int y, int width, int height, float u1, float v1, float u2, float v2) {
        x += this.getOffset().x;
        y += this.getOffset().y;
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(MinecraftObject.DynTexture.getBoundLoc());
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float bo = this.blitOffset;
        bufferbuilder.func_181662_b((double)x, (double)(y + height), (double)bo).func_187315_a((double)u1, (double)v2).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), (double)bo).func_187315_a((double)u2, (double)v2).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, (double)bo).func_187315_a((double)u2, (double)v1).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)y, (double)bo).func_187315_a((double)u1, (double)v1).func_181675_d();
        GlStateManager.enableAlphaTest();
        tessellator.func_78381_a();
        GlStateManager.disableBlend();
    }

    @Override
    public String i18nFormat(String key, Object ... obj) {
        return I18n.func_135052_a((String)key, (Object[])obj);
    }

    @Override
    public void setupCut() {
        if (!this.noScissorTest) {
            int dw = this.minecraft.field_195558_d.func_198109_k();
            int dh = this.minecraft.field_195558_d.func_198091_l();
            float multiplierX = (float)dw / (float)this.width;
            float multiplierY = (float)dh / (float)this.height;
            Box box = this.getContext().cutBox;
            GL11.glScissor((int)((int)((float)box.x * multiplierX)), (int)(dh - (int)((float)(box.y + box.h) * multiplierY)), (int)((int)((float)box.w * multiplierX)), (int)((int)((float)box.h * multiplierY)));
        }
    }

    @Override
    public int textWidth(String text) {
        return this.font.func_78256_a(text);
    }

    private TextField.ITextField createTextField() {
        return new TxtField();
    }

    @Override
    public UIColors getColors() {
        return this.colors;
    }

    @Override
    public void setCloseListener(Consumer<Runnable> listener) {
        this.closeListener = listener;
    }

    @Override
    public boolean isShiftDown() {
        return GuiBase.hasShiftDown();
    }

    @Override
    public boolean isCtrlDown() {
        return GuiBase.hasControlDown();
    }

    @Override
    public boolean isAltDown() {
        return GuiBase.hasAltDown();
    }

    @Override
    public KeyCodes getKeyCodes() {
        return CODES;
    }

    @Override
    public void drawGradientBox(int x, int y, int w, int h, int topLeft, int topRight, int bottomLeft, int bottomRight) {
        int left = x += this.getOffset().x;
        int top = y += this.getOffset().y;
        int right = x + w;
        int bottom = y + h;
        float atr = (float)(topRight >> 24 & 0xFF) / 255.0f;
        float rtr = (float)(topRight >> 16 & 0xFF) / 255.0f;
        float gtr = (float)(topRight >> 8 & 0xFF) / 255.0f;
        float btr = (float)(topRight & 0xFF) / 255.0f;
        float atl = (float)(topLeft >> 24 & 0xFF) / 255.0f;
        float rtl = (float)(topLeft >> 16 & 0xFF) / 255.0f;
        float gtl = (float)(topLeft >> 8 & 0xFF) / 255.0f;
        float btl = (float)(topLeft & 0xFF) / 255.0f;
        float abl = (float)(bottomLeft >> 24 & 0xFF) / 255.0f;
        float rbl = (float)(bottomLeft >> 16 & 0xFF) / 255.0f;
        float gbl = (float)(bottomLeft >> 8 & 0xFF) / 255.0f;
        float bbl = (float)(bottomLeft & 0xFF) / 255.0f;
        float abr = (float)(bottomRight >> 24 & 0xFF) / 255.0f;
        float rbr = (float)(bottomRight >> 16 & 0xFF) / 255.0f;
        float gbr = (float)(bottomRight >> 8 & 0xFF) / 255.0f;
        float bbr = (float)(bottomRight & 0xFF) / 255.0f;
        GlStateManager.disableTexture();
        GlStateManager.enableBlend();
        GlStateManager.disableAlphaTest();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)right, (double)top, (double)this.blitOffset).func_181666_a(rtr, gtr, btr, atr).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)top, (double)this.blitOffset).func_181666_a(rtl, gtl, btl, atl).func_181675_d();
        bufferbuilder.func_181662_b((double)left, (double)bottom, (double)this.blitOffset).func_181666_a(rbl, gbl, bbl, abl).func_181675_d();
        bufferbuilder.func_181662_b((double)right, (double)bottom, (double)this.blitOffset).func_181666_a(rbr, gbr, bbr, abr).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.shadeModel((int)7424);
        GlStateManager.disableBlend();
        GlStateManager.enableAlphaTest();
        GlStateManager.enableTexture();
    }

    @Override
    public NativeGuiComponents getNative() {
        return nativeComponents;
    }

    @Override
    public void setClipboardText(String text) {
        this.minecraft.field_195559_v.func_197960_a(text);
    }

    @Override
    public Frame getFrame() {
        return this.gui;
    }

    @Override
    public String getClipboardText() {
        return this.minecraft.field_195559_v.func_197965_a();
    }

    @Override
    public void setScale(int value) {
        if (this.vanillaScale == -999) {
            return;
        }
        if (value != this.minecraft.field_71474_y.field_74335_Z) {
            if (this.vanillaScale == -1) {
                this.vanillaScale = this.minecraft.field_71474_y.field_74335_Z;
            }
            if (value == -1) {
                if (this.minecraft.field_71474_y.field_74335_Z != this.vanillaScale) {
                    this.minecraft.field_71474_y.field_74335_Z = this.vanillaScale;
                    this.vanillaScale = -1;
                    this.minecraft.func_213226_a();
                }
            } else {
                this.minecraft.field_71474_y.field_74335_Z = value;
                this.minecraft.func_213226_a();
            }
        }
    }

    @Override
    public int getScale() {
        return this.minecraft.field_71474_y.field_74335_Z;
    }

    @Override
    public int getMaxScale() {
        return this.minecraft.field_195558_d.func_216521_a(0, this.minecraft.func_211821_e()) + 1;
    }

    @Override
    public IGui.CtxStack getStack() {
        return this.stack;
    }

    public void tick() {
        try {
            this.gui.tick();
        }
        catch (Throwable e) {
            this.onGuiException("Error in tick gui", e, true);
        }
    }

    @Override
    public void drawFormattedText(float x, float y, IText text, int color, float scale) {
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)(x += (float)this.getOffset().x), (float)(y += (float)this.getOffset().y), (float)50.0f);
        GlStateManager.scalef((float)scale, (float)scale, (float)scale);
        this.font.func_211126_b(((ITextComponent)text.remap()).func_150254_d(), 0.0f, 0.0f, color);
        GlStateManager.popMatrix();
    }

    @Override
    public int textWidthFormatted(IText text) {
        return this.font.func_78256_a(((ITextComponent)text.remap()).getString());
    }

    @Override
    public void openURL0(String url) {
        Util.func_110647_a().func_195640_a(url);
    }

    public void onOpened() {
        this.vanillaScale = -1;
    }

    @Override
    public void drawStack(int x, int y, Stack stack) {
        ItemStack s = (ItemStack)ItemStackHandlerImpl.impl.unwrap(stack);
        GlStateManager.enableDepthTest();
        RenderHelper.func_74520_c();
        this.itemRenderer.func_184391_a((LivingEntity)this.minecraft.field_71439_g, s, x += this.getOffset().x, y += this.getOffset().y);
        this.itemRenderer.func_180453_a(this.font, s, x, y, null);
        GlStateManager.disableDepthTest();
    }

    @Override
    public void drawStackTooltip(int mx, int my, Stack stack) {
        ItemStack s = (ItemStack)ItemStackHandlerImpl.impl.unwrap(stack);
        this.renderTooltip(s, mx, my);
    }

    static {
        nativeComponents.register(TextField.class, GuiBase.local(GuiBase::createTextField));
        nativeComponents.register(FileChooserPopup.class, ErrorChooser::new);
        nativeComponents.register(Panel3d.class, Panel3dImpl::new);
    }

    public class Overlay
    extends ChatScreen {
        public Overlay() {
            super("");
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.0f, (float)0.0f, (float)-100.0f);
            GuiBase.this.render(Integer.MIN_VALUE, Integer.MIN_VALUE, partialTicks);
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.0f, (float)0.0f, (float)900.0f);
            super.render(mouseX, mouseY, partialTicks);
            GlStateManager.popMatrix();
        }

        public Screen getGui() {
            return GuiBase.this;
        }
    }

    private class TxtField
    implements TextField.ITextField,
    Consumer<String> {
        private TextFieldWidget field;
        private Runnable eventListener;
        private Vec2i currentOff = new Vec2i(0, 0);
        private Box bounds = new Box(0, 0, 0, 0);
        private boolean settingText;
        private boolean updateField;
        private boolean enabled;

        public TxtField() {
            this.field = new TextFieldWidget(GuiBase.this.font, 0, 0, 0, 0, I18n.func_135052_a((String)"narrator.cpm.field", (Object[])new Object[0]));
            this.field.func_146203_f(0x100000);
            this.field.func_146185_a(false);
            this.field.func_146189_e(true);
            this.field.func_146193_g(GuiBase.this.colors.label_text_color);
            this.field.func_212954_a((Consumer)this);
            this.enabled = true;
        }

        @Override
        public void draw(int mouseX, int mouseY, float partialTicks, Box bounds) {
            Vec2i off = GuiBase.this.getOffset();
            this.field.x = bounds.x + off.x + 4;
            this.field.y = bounds.y + off.y + 6;
            this.currentOff.x = off.x;
            this.currentOff.y = off.y;
            this.bounds.x = bounds.x;
            this.bounds.y = bounds.y;
            this.bounds.w = bounds.w;
            this.bounds.h = bounds.h;
            this.field.setWidth(bounds.w - 5);
            Platform.setHeight((Widget)this.field, bounds.h - 12);
            if (this.updateField) {
                this.settingText = true;
                this.field.func_146202_e();
                this.settingText = false;
                this.updateField = false;
            }
            this.field.render(mouseX, mouseY, partialTicks);
        }

        @Override
        public void keyPressed(KeyboardEvent evt) {
            if (evt.isConsumed()) {
                return;
            }
            if (evt.keyCode == -1) {
                if (this.field.charTyped(evt.charTyped, GuiBase.this.keyModif)) {
                    evt.consume();
                }
            } else if (this.field.keyPressed(evt.keyCode, evt.scancode, GuiBase.this.keyModif) || this.field.func_212955_f()) {
                evt.consume();
            }
        }

        @Override
        public void mouseClick(MouseEvent evt) {
            if (evt.isConsumed()) {
                this.field.mouseClicked(-2.147483648E9, -2.147483648E9, evt.btn);
                return;
            }
            this.field.x = this.bounds.x + this.currentOff.x;
            this.field.y = this.bounds.y + this.currentOff.y;
            this.field.setWidth(this.bounds.w);
            Platform.setHeight((Widget)this.field, this.bounds.h);
            if (this.field.mouseClicked((double)(evt.x + this.currentOff.x), (double)(evt.y + this.currentOff.y), evt.btn)) {
                evt.consume();
            }
        }

        @Override
        public String getText() {
            return this.field.func_146179_b();
        }

        @Override
        public void setText(String txt) {
            this.settingText = true;
            this.field.func_146180_a(txt);
            this.settingText = false;
            this.updateField = true;
        }

        @Override
        public void setEventListener(Runnable eventListener) {
            this.eventListener = eventListener;
        }

        @Override
        public void accept(String value) {
            if (this.eventListener != null && !this.settingText && this.enabled) {
                this.eventListener.run();
            }
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.field.func_146184_c(enabled);
            this.enabled = enabled;
        }

        @Override
        public boolean isFocused() {
            return this.field.isFocused();
        }

        @Override
        public void setFocused(boolean focused) {
            this.field.func_146195_b(focused);
        }

        @Override
        public int getCursorPos() {
            return this.field.func_146198_h();
        }

        @Override
        public void setCursorPos(int pos) {
            this.field.func_212422_f(pos);
        }

        @Override
        public void setSelectionPos(int pos) {
            this.field.func_146199_i(pos);
        }

        @Override
        public int getSelectionPos() {
            return this.field.field_146223_s;
        }
    }

    private static class CrashScreen
    extends Screen {
        private String error;
        private Screen parent;

        public CrashScreen(String error, Screen p) {
            super((ITextComponent)new StringTextComponent("Error"));
            this.error = error;
            this.parent = p;
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            this.renderBackground();
            String[] txt = IGui.wordWrap(I18n.func_135052_a((String)"error.cpm.crash", (Object[])new Object[]{this.error}), this.width - 200, arg_0 -> ((FontRenderer)this.font).func_78256_a(arg_0)).split("\\\\");
            for (int i = 0; i < txt.length; ++i) {
                this.drawCenteredString(this.font, txt[i], this.width / 2, 15 + i * 10, 0xFFFFFF);
            }
            super.render(mouseX, mouseY, partialTicks);
        }

        protected void init() {
            super.init();
            this.addButton((Widget)new Button(this.width / 2 - 100, 140, 200, 20, I18n.func_135052_a((String)"gui.back", (Object[])new Object[0]), p_213034_1_ -> this.minecraft.func_147108_a((Screen)null)));
        }

        public void onClose() {
            if (this.parent != null) {
                Screen p = this.parent;
                this.parent = null;
                this.minecraft.func_147108_a(p);
            }
        }
    }
}

