/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.tom.cpl.math.MatrixStack;
import com.tom.cpl.math.Vec4f;
import com.tom.cpl.render.VBuffers;
import com.tom.cpm.client.RetroGL;
import com.tom.cpm.shared.model.PlayerModelParts;
import com.tom.cpm.shared.model.RootModelType;
import com.tom.cpm.shared.model.render.ModelRenderManager;
import com.tom.cpm.shared.model.render.VanillaModelPart;
import com.tom.cpm.shared.retro.RedirectHolderRetro;
import java.util.function.Supplier;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.ElytraModel;
import net.minecraft.client.renderer.entity.model.HumanoidHeadModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.entity.LivingEntity;

public class PlayerRenderManager
extends ModelRenderManager<Void, Void, RendererModel, Model> {
    public static final float scale = 0.0625f;

    public PlayerRenderManager() {
        this.setFactory(new ModelRenderManager.RedirectHolderFactory<Void, Void, RendererModel>(){

            @Override
            public <M> ModelRenderManager.RedirectHolder<?, Void, Void, RendererModel> create(M model, String arg) {
                if ("api".equals(arg) && model instanceof BipedModel) {
                    return new RedirectHolderApi(PlayerRenderManager.this, (BipedModel<LivingEntity>)((BipedModel)model));
                }
                if (model instanceof PlayerModel) {
                    return new RedirectHolderPlayer(PlayerRenderManager.this, (PlayerModel<LivingEntity>)((PlayerModel)model));
                }
                if (model instanceof HumanoidHeadModel) {
                    return new RedirectHolderSkull(PlayerRenderManager.this, (HumanoidHeadModel)model);
                }
                if (model instanceof ElytraModel) {
                    return new RedirectHolderElytra(PlayerRenderManager.this, (ElytraModel<LivingEntity>)((ElytraModel)model));
                }
                if (model instanceof BipedModel && "armor1".equals(arg)) {
                    return new RedirectHolderArmor1(PlayerRenderManager.this, (BipedModel<LivingEntity>)((BipedModel)model));
                }
                if (model instanceof BipedModel && "armor2".equals(arg)) {
                    return new RedirectHolderArmor2(PlayerRenderManager.this, (BipedModel<LivingEntity>)((BipedModel)model));
                }
                return null;
            }
        });
        this.setRedirectFactory(new ModelRenderManager.RedirectRendererFactory<Model, Void, RendererModel>(){

            @Override
            public ModelRenderManager.RedirectRenderer<RendererModel> create(Model model, ModelRenderManager.RedirectHolder<Model, ?, Void, RendererModel> access, Supplier<RendererModel> modelPart, VanillaModelPart part) {
                return new RedirectModelRenderer((RDH)access, modelPart, part);
            }
        });
        this.setVis(m -> m.field_78806_j, (m, v) -> {
            m.field_78806_j = v;
        });
        this.setModelPosGetters(m -> m.field_78800_c, m -> m.field_78797_d, m -> m.field_78798_e);
        this.setModelRotGetters(m -> m.field_78795_f, m -> m.field_78796_g, m -> m.field_78808_h);
        this.setModelSetters((m, x, y, z) -> {
            m.field_78800_c = x;
            m.field_78797_d = y;
            m.field_78798_e = z;
        }, (m, x, y, z) -> {
            m.field_78795_f = x;
            m.field_78796_g = y;
            m.field_78808_h = z;
        });
        this.setRenderPart(new RendererModel(new Model()));
    }

    public static void multiplyStacks(MatrixStack.Entry e) {
        e.getMatrix().multiplyNative(GlStateManager::multMatrix);
    }

    public static class RedirectModelRenderer
    extends RendererModel
    implements ModelRenderManager.RedirectRenderer<RendererModel> {
        protected final RDH holder;
        protected final VanillaModelPart part;
        protected final Supplier<RendererModel> parentProvider;
        protected RendererModel parent;
        protected VBuffers buffers;

        public RedirectModelRenderer(RDH holder, Supplier<RendererModel> parent, VanillaModelPart part) {
            super((Model)holder.model);
            this.part = part;
            this.holder = holder;
            this.parentProvider = parent;
        }

        @Override
        public VBuffers getVBuffers() {
            return this.buffers;
        }

        @Override
        public RendererModel swapIn() {
            if (this.parent != null) {
                return this;
            }
            this.parent = this.parentProvider.get();
            this.holder.copyModel(this.parent, this);
            return this;
        }

        @Override
        public RendererModel swapOut() {
            if (this.parent == null) {
                return this.parentProvider.get();
            }
            RendererModel p = this.parent;
            this.parent = null;
            return p;
        }

        @Override
        public ModelRenderManager.RedirectHolder<?, ?, ?, RendererModel> getHolder() {
            return this.holder;
        }

        @Override
        public RendererModel getParent() {
            return this.parent;
        }

        @Override
        public VanillaModelPart getPart() {
            return this.part;
        }

        @Override
        public Vec4f getColor() {
            return RetroGL.getColor();
        }

        public void func_78794_c(float scale) {
            MatrixStack.Entry e = this.getPartTransform();
            if (e != null) {
                PlayerRenderManager.multiplyStacks(e);
            } else {
                super.func_78794_c(scale);
            }
        }

        public void func_78785_a(float scale) {
            this.buffers = new VBuffers(RetroGL::buffer);
            this.render();
            this.buffers.finishAll();
        }

        @Override
        public void renderParent() {
            this.parent.func_78785_a(0.0625f);
        }
    }

    private static class RedirectHolderArmor2
    extends RDH {
        public RedirectHolderArmor2(PlayerRenderManager mngr, BipedModel<LivingEntity> model) {
            super(mngr, (Model)model);
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_78115_e, v -> {
                model.field_78115_e = v;
            }, RootModelType.ARMOR_LEGGINGS_BODY));
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_178721_j, v -> {
                model.field_178721_j = v;
            }, RootModelType.ARMOR_RIGHT_LEG));
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_178722_k, v -> {
                model.field_178722_k = v;
            }, RootModelType.ARMOR_LEFT_LEG));
        }
    }

    private static class RedirectHolderArmor1
    extends RDH {
        public RedirectHolderArmor1(PlayerRenderManager mngr, BipedModel<LivingEntity> model) {
            super(mngr, (Model)model);
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_78116_c, v -> {
                model.field_78116_c = v;
            }, RootModelType.ARMOR_HELMET));
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_78115_e, v -> {
                model.field_78115_e = v;
            }, RootModelType.ARMOR_BODY));
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_178723_h, v -> {
                model.field_178723_h = v;
            }, RootModelType.ARMOR_RIGHT_ARM));
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_178724_i, v -> {
                model.field_178724_i = v;
            }, RootModelType.ARMOR_LEFT_ARM));
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_178721_j, v -> {
                model.field_178721_j = v;
            }, RootModelType.ARMOR_RIGHT_FOOT));
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_178722_k, v -> {
                model.field_178722_k = v;
            }, RootModelType.ARMOR_LEFT_FOOT));
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_178720_f, v -> {
                model.field_178720_f = v;
            }, null));
        }
    }

    private static class RedirectHolderElytra
    extends RDH {
        public RedirectHolderElytra(PlayerRenderManager mngr, ElytraModel<LivingEntity> model) {
            super(mngr, (Model)model);
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_187060_a, v -> {
                model.field_187060_a = v;
            }, RootModelType.ELYTRA_RIGHT));
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_187061_b, v -> {
                model.field_187061_b = v;
            }, RootModelType.ELYTRA_LEFT));
        }
    }

    private static class RedirectHolderSkull
    extends RDH {
        public RedirectHolderSkull(PlayerRenderManager mngr, HumanoidHeadModel model) {
            super(mngr, (Model)model);
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_217105_a, v -> {
                model.field_217105_a = v;
            }, PlayerModelParts.HEAD));
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_178717_b, v -> {
                model.field_178717_b = v;
            }, null));
        }
    }

    private static class RedirectHolderApi
    extends RDH {
        private ModelRenderManager.RedirectRenderer<RendererModel> head = this.registerHead(new ModelRenderManager.Field<RendererModel>(() -> model.field_78116_c, v -> {
            model.field_78116_c = v;
        }, PlayerModelParts.HEAD));

        public RedirectHolderApi(PlayerRenderManager mngr, BipedModel<LivingEntity> model) {
            super(mngr, (Model)model);
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_78115_e, v -> {
                model.field_78115_e = v;
            }, PlayerModelParts.BODY));
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_178723_h, v -> {
                model.field_178723_h = v;
            }, PlayerModelParts.RIGHT_ARM));
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_178724_i, v -> {
                model.field_178724_i = v;
            }, PlayerModelParts.LEFT_ARM));
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_178721_j, v -> {
                model.field_178721_j = v;
            }, PlayerModelParts.RIGHT_LEG));
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_178722_k, v -> {
                model.field_178722_k = v;
            }, PlayerModelParts.LEFT_LEG));
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_178720_f, v -> {
                model.field_178720_f = v;
            }, null)).setCopyFrom(this.head);
            if (model instanceof PlayerModel) {
                PlayerModel pm = (PlayerModel)model;
                this.register(new ModelRenderManager.Field<RendererModel>(() -> pm.field_178734_a, v -> {
                    pm.field_178734_a = v;
                }, null));
                this.register(new ModelRenderManager.Field<RendererModel>(() -> pm.field_178732_b, v -> {
                    pm.field_178732_b = v;
                }, null));
                this.register(new ModelRenderManager.Field<RendererModel>(() -> pm.field_178733_c, v -> {
                    pm.field_178733_c = v;
                }, null));
                this.register(new ModelRenderManager.Field<RendererModel>(() -> pm.field_178731_d, v -> {
                    pm.field_178731_d = v;
                }, null));
                this.register(new ModelRenderManager.Field<RendererModel>(() -> pm.field_178730_v, v -> {
                    pm.field_178730_v = v;
                }, null));
                this.register(new ModelRenderManager.Field<RendererModel>(() -> pm.field_178729_w, v -> {
                    pm.field_178729_w = v;
                }, RootModelType.CAPE));
            }
        }

        @Override
        protected boolean isDirectMode() {
            return true;
        }
    }

    private static class RedirectHolderPlayer
    extends RDH {
        private ModelRenderManager.RedirectRenderer<RendererModel> head = this.registerHead(new ModelRenderManager.Field<RendererModel>(() -> model.field_78116_c, v -> {
            model.field_78116_c = v;
        }, PlayerModelParts.HEAD));

        public RedirectHolderPlayer(PlayerRenderManager mngr, PlayerModel<LivingEntity> model) {
            super(mngr, (Model)model);
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_78115_e, v -> {
                model.field_78115_e = v;
            }, PlayerModelParts.BODY));
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_178723_h, v -> {
                model.field_178723_h = v;
            }, PlayerModelParts.RIGHT_ARM));
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_178724_i, v -> {
                model.field_178724_i = v;
            }, PlayerModelParts.LEFT_ARM));
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_178721_j, v -> {
                model.field_178721_j = v;
            }, PlayerModelParts.RIGHT_LEG));
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_178722_k, v -> {
                model.field_178722_k = v;
            }, PlayerModelParts.LEFT_LEG));
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_178720_f, v -> {
                model.field_178720_f = v;
            }, null)).setCopyFrom(this.head);
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_178734_a, v -> {
                model.field_178734_a = v;
            }, null));
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_178732_b, v -> {
                model.field_178732_b = v;
            }, null));
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_178733_c, v -> {
                model.field_178733_c = v;
            }, null));
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_178731_d, v -> {
                model.field_178731_d = v;
            }, null));
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_178730_v, v -> {
                model.field_178730_v = v;
            }, null));
            this.register(new ModelRenderManager.Field<RendererModel>(() -> model.field_178729_w, v -> {
                model.field_178729_w = v;
            }, RootModelType.CAPE));
        }
    }

    public static abstract class RDH
    extends RedirectHolderRetro<Model, RendererModel> {
        public RDH(ModelRenderManager<Void, Void, RendererModel, Model> mngr, Model model) {
            super(mngr, model);
        }
    }
}

