/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.common;

import com.mojang.brigadier.CommandDispatcher;
import com.tom.cpm.common.Command;
import com.tom.cpm.common.ServerHandlerBase;
import com.tom.cpm.shared.network.NetH;
import com.tom.cpm.shared.network.NetHandler;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.play.ServerPlayNetHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class ServerHandler
extends ServerHandlerBase {
    public static NetHandler<ResourceLocation, ServerPlayerEntity, ServerPlayNetHandler> netHandler = ServerHandler.init();

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        netHandler.onJoin((ServerPlayerEntity)evt.getPlayer());
    }

    @SubscribeEvent
    public void onTrackingStart(PlayerEvent.StartTracking evt) {
        ServerPlayNetHandler handler = ((ServerPlayerEntity)evt.getPlayer()).field_71135_a;
        NetH h = (NetH)handler;
        if (h.cpm$hasMod() && evt.getTarget() instanceof PlayerEntity) {
            netHandler.sendPlayerData((ServerPlayerEntity)evt.getTarget(), (ServerPlayerEntity)evt.getPlayer());
        }
    }

    public static void registerCommands(CommandDispatcher<CommandSource> d) {
        new Command(d, false);
    }

    @SubscribeEvent
    public void onRespawn(PlayerEvent.PlayerRespawnEvent evt) {
        if (!evt.isEndConquered()) {
            netHandler.onRespawn((ServerPlayerEntity)evt.getPlayer());
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent evt) {
        if (evt.phase == TickEvent.Phase.END) {
            netHandler.tick();
        }
    }

    @SubscribeEvent
    public void onJump(LivingEvent.LivingJumpEvent evt) {
        if (evt.getEntityLiving() instanceof ServerPlayerEntity) {
            netHandler.onJump((ServerPlayerEntity)evt.getEntityLiving());
        }
    }

    static {
        netHandler.setExecutor(ServerLifecycleHooks::getCurrentServer);
        netHandler.setGetOnlinePlayers(() -> ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v());
    }
}

