/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui.panel;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.FlowLayout;
import com.tom.cpl.gui.util.HorizontalLayout;
import com.tom.cpl.gui.util.TabbedPanelManager;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.config.SocialConfig;
import com.tom.cpm.shared.gui.ViewportCamera;
import com.tom.cpm.shared.gui.panel.ListPanel;
import com.tom.cpm.shared.gui.panel.SocialPlayerPanel;
import com.tom.cpm.shared.skin.TextureProvider;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class SocialPanel
extends Panel {
    private final Frame frm;
    private TabbedPanelManager tabs;
    public HorizontalLayout topPanel;
    private UUID selUUID;
    private ScrollPanel scrollPlayer;
    private ViewportCamera cam;
    private ListPanel<PlayerInServer> playerList;
    private int listWidth;
    private int scrollWidth;
    private List<TextureProvider> vanillaSkins = new ArrayList<TextureProvider>();

    public SocialPanel(Frame frm, int width, int height, ViewportCamera cam, UUID selected, boolean isInServer) {
        super(frm.getGui());
        this.frm = frm;
        this.cam = cam;
        this.setBounds(new Box(0, 0, width, height));
        this.tabs = new TabbedPanelManager(this.gui);
        this.tabs.setBounds(new Box(0, 20, width, height - 20));
        this.addElement(this.tabs);
        Panel topPanel = new Panel(this.gui);
        topPanel.setBounds(new Box(0, 0, width, 20));
        topPanel.setBackgroundColor(this.gui.getColors().menu_bar_background);
        this.addElement(topPanel);
        this.topPanel = new HorizontalLayout(topPanel);
        if (isInServer) {
            Panel inServer = new Panel(this.gui);
            this.addTab("inServer", inServer, 0);
            List<Player<?>> loadedPlayers = MinecraftClientAccess.get().getDefinitionLoader().getPlayers();
            Set pls = loadedPlayers.stream().map(x$0 -> new PlayerInServer((Player)x$0)).collect(Collectors.toSet());
            MinecraftClientAccess.get().getPlayers().stream().map(x$0 -> new PlayerInServer(x$0)).forEach(pls::add);
            List players = pls.stream().filter(rec$ -> ((PlayerInServer)rec$).isOtherPlayer()).distinct().sorted(Comparator.comparing(PlayerInServer::toString)).collect(Collectors.toList());
            this.listWidth = width / 4;
            this.scrollWidth = width - this.listWidth;
            this.scrollPlayer = new ScrollPanel(this.gui);
            this.scrollPlayer.setBounds(new Box(this.listWidth, 0, this.scrollWidth, height - 20));
            this.scrollPlayer.setVisible(false);
            this.playerList = new ListPanel(this.gui, players, width, height - 20);
            this.playerList.setSelect(this::setPlayerPanel);
            this.playerList.setGetTooltip(rec$ -> ((PlayerInServer)rec$).getTooltip());
            this.playerList.setBounds(new Box(0, 0, width, height - 20));
            this.playerList.setWidth(width);
            this.playerList.setBackgroundColor(this.gui.getColors().popup_background & 0x80FFFFFF);
            inServer.addElement(this.playerList);
            if (selected != null) {
                this.selUUID = selected;
                players.stream().filter(p -> p.getUUID().equals(this.selUUID)).findFirst().ifPresent(this::setPlayerPanel);
            }
            inServer.addElement(this.scrollPlayer);
        }
        Panel friends = new Panel(this.gui);
        this.addTab("friends", friends, 0);
        this.initList(friends, ModConfig.getCommonConfig().getEntry("friendList"));
        Panel blocked = new Panel(this.gui);
        this.addTab("blocked", blocked, 0);
        this.initList(blocked, ModConfig.getCommonConfig().getEntry("blockedList"));
    }

    private void setPlayerPanel(PlayerInServer p) {
        if (p != null) {
            this.playerList.setWidth(this.listWidth);
            this.selUUID = p.getUUID();
            if (this.scrollPlayer.getDisplay() != null) {
                ((SocialPlayerPanel)this.scrollPlayer.getDisplay()).cleanup();
            }
            this.scrollPlayer.setDisplay(new SocialPlayerPanel(this.frm, p.getPlayer(), this.cam, this.scrollWidth, this.bounds.h - 20, () -> this.setPlayerPanel(p)));
            MinecraftClientAccess.get().getNetHandler().requestPlayerData(this.selUUID);
        } else {
            this.selUUID = null;
            this.playerList.setWidth(this.bounds.w);
        }
        this.scrollPlayer.setVisible(p != null);
    }

    private void initList(Panel panel, ConfigEntry ce) {
        int w = panel.getBounds().w;
        int h = panel.getBounds().h;
        panel.setBackgroundColor(this.gui.getColors().popup_background & 0x80FFFFFF);
        Panel listPanel = new Panel(this.gui);
        listPanel.setBackgroundColor(this.gui.getColors().menu_bar_background);
        List players = ce.keySet().stream().map(u -> new Pl((String)u, ce)).sorted(Comparator.comparing(Pl::getName)).collect(Collectors.toList());
        int lw = w / 4;
        int spw = w - lw - 10;
        ScrollPanel scpS = new ScrollPanel(this.gui);
        scpS.setBounds(new Box(lw + 10, 0, spw, h));
        scpS.setVisible(false);
        ListPanel playerList = new ListPanel(this.gui, players, w, h);
        playerList.setSelect(p -> {
            if (p != null) {
                playerList.setWidth(lw);
                scpS.setDisplay(new PlayerInfoPanel((Pl)p, spw - 5, h));
            } else {
                playerList.setWidth(w - 10);
            }
            scpS.setVisible(p != null);
        });
        playerList.setBounds(new Box(0, 0, w, h));
        panel.addElement(playerList);
        panel.addElement(scpS);
    }

    public void addTab(String name, Panel panel, int topPadding) {
        panel.setBounds(new Box(0, topPadding, this.bounds.w, this.bounds.h - 20 - topPadding));
        this.topPanel.add(this.tabs.createTab(this.gui.i18nFormat("tab.cpm.social." + name, new Object[0]), panel));
    }

    public UUID getSelectedUUID() {
        return this.selUUID;
    }

    public void cleanup() {
        if (this.scrollPlayer.getDisplay() != null) {
            ((SocialPlayerPanel)this.scrollPlayer.getDisplay()).cleanup();
        }
        this.vanillaSkins.forEach(TextureProvider::free);
        this.vanillaSkins.clear();
    }

    private class PlayerInfoPanel
    extends Panel {
        public PlayerInfoPanel(Pl pl, int w, int h) {
            super(SocialPanel.this.getGui());
            this.setBounds(new Box(0, 0, w, h));
            FlowLayout layout = new FlowLayout(this, 5, 1);
            Panel padding = new Panel(this.gui);
            padding.setBounds(new Box(0, 0, w, 5));
            this.addElement(padding);
            this.addElement(new Label(this.gui, this.gui.i18nFormat("label.cpm.sSettingsFor", pl.getName())).setBounds(new Box(5, 0, w, 10)));
            Button friend = new Button(this.gui, this.gui.i18nFormat(SocialConfig.isFriend(pl.getUUID()) ? "button.cpm.removeFriend" : "button.cpm.addFriend", new Object[0]), null);
            friend.setBounds(new Box(5, 0, w - 5, 20));
            friend.setAction(() -> {
                if (SocialConfig.isFriend(pl.getUUID())) {
                    SocialConfig.removeFriend(pl.getUUID());
                } else {
                    SocialConfig.addFriend(pl.getUUID(), pl.getName());
                }
                friend.setText(this.gui.i18nFormat(SocialConfig.isFriend(pl.getUUID()) ? "button.cpm.removeFriend" : "button.cpm.addFriend", new Object[0]));
                MinecraftClientAccess.get().getDefinitionLoader().settingsChanged(UUID.fromString(pl.getUUID()));
                ModConfig.getCommonConfig().save();
            });
            this.addElement(friend);
            Button block = new Button(this.gui, this.gui.i18nFormat(SocialConfig.isBlocked(pl.getUUID()) ? "button.cpm.removeBlock" : "button.cpm.addBlock", new Object[0]), null);
            block.setBounds(new Box(5, 0, w - 5, 20));
            block.setAction(() -> {
                if (SocialConfig.isBlocked(pl.getUUID())) {
                    SocialConfig.removeBlock(pl.getUUID());
                } else {
                    SocialConfig.blockPlayer(pl.getUUID(), pl.getName());
                }
                block.setText(this.gui.i18nFormat(SocialConfig.isBlocked(pl.getUUID()) ? "button.cpm.removeBlock" : "button.cpm.addBlock", new Object[0]));
                MinecraftClientAccess.get().getDefinitionLoader().settingsChanged(UUID.fromString(pl.getUUID()));
                ModConfig.getCommonConfig().save();
            });
            this.addElement(block);
            Button playerSettings = new Button(this.gui, this.gui.i18nFormat("button.cpm.playerSettings", new Object[0]), () -> SocialPanel.this.frm.openPopup(new SocialPlayerPanel.SafetyPopup(this, pl.getUUID(), pl.getName(), () -> {}, SocialPanel.this.frm)));
            playerSettings.setBounds(new Box(5, 0, w - 5, 20));
            this.addElement(playerSettings);
            layout.reflow();
        }
    }

    private class Pl {
        private String uuid;
        private String name;

        public Pl(String uuid, ConfigEntry ce) {
            this.uuid = uuid;
            this.name = ce.getEntry(uuid).getString("name", uuid);
        }

        public String getName() {
            return this.name;
        }

        public String getUUID() {
            return this.uuid;
        }

        public String toString() {
            return this.name;
        }
    }

    private class PlayerInServer {
        private Object gp;
        private UUID uuid;
        private String unique;

        private PlayerInServer(Object gp) {
            this.gp = gp;
            this.uuid = MinecraftClientAccess.get().getDefinitionLoader().getGP_UUID(gp);
            if (this.uuid == null) {
                this.uuid = UUID.randomUUID();
            }
            this.unique = "player";
        }

        private PlayerInServer(Player<?> pl) {
            this(pl.getGameProfile());
            this.unique = pl.unique;
        }

        public Player<?> getPlayer() {
            return MinecraftClientAccess.get().getDefinitionLoader().loadPlayer(this.gp, this.unique);
        }

        public UUID getUUID() {
            return this.uuid;
        }

        private boolean isOtherPlayer() {
            return !this.getUUID().equals(MinecraftClientAccess.get().getCurrentClientPlayer().getUUID());
        }

        public String toString() {
            String name = this.getName();
            if (name.length() > 16) {
                name = SocialPanel.this.gui.i18nFormat("label.cpm.shortName", name.substring(0, 15));
            }
            return name;
        }

        private String getName() {
            String name = MinecraftClientAccess.get().getDefinitionLoader().getGP_Name(this.gp);
            if (name == null) {
                return SocialPanel.this.gui.i18nFormat("label.cpm.unknown", new Object[0]);
            }
            return name;
        }

        private Tooltip getTooltip() {
            String type = "player";
            if (this.unique != null) {
                if (this.unique.equals("skull") || this.unique.startsWith("skull_tex:")) {
                    type = "skull";
                } else if (this.unique.startsWith("model:")) {
                    type = "model";
                } else if (this.unique.startsWith("man:")) {
                    type = "mannequin";
                }
            }
            return new Tooltip(SocialPanel.this.frm, SocialPanel.this.gui.i18nFormat("tooltip.cpm.playerUUID", this.getName(), this.getUUID().toString(), SocialPanel.this.gui.i18nFormat("label.cpm.modelLoadingType." + type, new Object[0])));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.unique == null ? 0 : this.unique.hashCode());
            result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PlayerInServer other = (PlayerInServer)obj;
            if (this.unique == null ? other.unique != null : !this.unique.equals(other.unique)) {
                return false;
            }
            return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
        }
    }
}

