/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.paste;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.UI;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.FuturePopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpl.util.LocalizedIOException;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.paste.PasteClient;
import java.util.Comparator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class PastePopup
extends PopupPanel {
    private static PasteClient client = new PasteClient(MinecraftClientAccess.get().getMojangAPI(), "https://paste.tom5454.com", "https://cf-paste.tom5454.com");
    private final Frame frm;
    private Panel panel;
    private ScrollPanel scp;
    private Label statusLbl;

    public PastePopup(Frame frame) {
        super(frame.getGui());
        this.frm = frame;
        this.setBounds(new Box(0, 0, 400, 325));
        this.scp = new ScrollPanel(this.gui);
        this.scp.setBounds(new Box(5, 30, 390, 270));
        this.addElement(this.scp);
        this.panel = new Panel(this.gui);
        this.panel.setBackgroundColor(this.gui.getColors().button_border);
        this.scp.setDisplay(this.panel);
        this.panel.setBounds(new Box(0, 0, this.scp.getBounds().w, 16));
        this.statusLbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.loading", new Object[0]));
        this.statusLbl.setBounds(new Box(100, 305, 200, 10));
        this.addElement(this.statusLbl);
        Button btnOpenBrowser = new Button(this.gui, this.gui.i18nFormat("button.cpm.paste.openBrowser", new Object[0]), () -> PastePopup.runRequest((UI)this.gui, PasteClient::createBrowserLoginURL, (T id) -> this.gui.openURL(client.getUrl() + "/login.html?id=" + id), () -> {}, "openBrowser"));
        btnOpenBrowser.setBounds(new Box(275, 5, 120, 20));
        this.addElement(btnOpenBrowser);
    }

    public void open() {
        this.frm.openPopup(this);
        this.refreshGui();
    }

    private static void handleException(UI gui, Runnable retry, Runnable close, Throwable e) {
        if (e instanceof CompletionException) {
            e = ((CompletionException)e).getCause();
        }
        if (e instanceof InterruptedException) {
            return;
        }
        if (e instanceof LocalizedIOException) {
            gui.displayConfirm(gui.i18nFormat("label.cpm.error", new Object[0]), gui.i18nFormat("label.cpm.paste.error", ((LocalizedIOException)e).getLocalizedText().toString(gui)), retry, () -> {
                if (!client.isConnected()) {
                    close.run();
                }
            }, gui.i18nFormat("button.cpm.retry", new Object[0]));
        } else {
            gui.displayConfirm(gui.i18nFormat("label.cpm.error", new Object[0]), gui.i18nFormat("error.cpm.paste.unknownNetworkError", e.toString()), retry, () -> {
                if (!client.isConnected()) {
                    close.run();
                }
            }, gui.i18nFormat("button.cpm.retry", new Object[0]));
        }
    }

    private void refreshGui() {
        this.runRequest(client::listFiles, (T entries) -> {
            this.panel.getElements().clear();
            this.panel.setBounds(new Box(0, 0, this.bounds.w - 10, entries.size() * 32));
            entries.sort(Comparator.comparing(p -> p.time));
            for (int i = 0; i < entries.size(); ++i) {
                PasteClient.Paste e = (PasteClient.Paste)entries.get(i);
                this.panel.addElement(new PastePanel(e, i * 32, this.scp.getBounds().w, i));
            }
            int mx = client.getMaxSize() / 1024;
            String maxSize = mx > 1024 ? mx / 1024 + " MB" : mx + " kB";
            this.statusLbl.setText(this.gui.i18nFormat("label.cpm.paste.status", entries.size(), client.getMaxPastes(), maxSize));
        }, "listing");
    }

    public static <T> void runRequest(UI frm, Function<PasteClient, CompletableFuture<T>> task, Consumer<T> finish, Runnable close, String name) {
        if (!client.isConnected()) {
            PastePopup.runRequest0(frm, PasteClient::connect, v -> PastePopup.runRequest0(frm, task, finish, close, name), close, "connecting.message");
        } else {
            PastePopup.runRequest0(frm, task, finish, close, name);
        }
    }

    public static void runRequest(UI frm, Function<PasteClient, CompletableFuture<Void>> task, Runnable finish, Runnable close, String name) {
        PastePopup.runRequest(frm, task, (T v) -> finish.run(), close, name);
    }

    private static <T> void runRequest0(UI gui, Function<PasteClient, CompletableFuture<T>> task, Consumer<T> finish, Runnable close, String name) {
        CompletableFuture cf = task.apply(client);
        gui.displayPopup(frm -> new FuturePopup((Frame)frm, gui.i18nFormat("label.cpm.paste.connecting.title", new Object[0]), gui.i18nFormat("label.cpm.paste." + name, new Object[0]), cf));
        ((CompletableFuture)cf.thenAcceptAsync((Consumer)finish, gui::executeLater)).exceptionally(e -> {
            gui.executeLater(() -> PastePopup.handleException(gui, () -> PastePopup.runRequest(gui, task, finish, close, name), close, e));
            return null;
        });
    }

    private <T> void runRequest(Supplier<CompletableFuture<T>> task, Consumer<T> finish, String name) {
        PastePopup.runRequest((UI)this.gui, (PasteClient _c) -> (CompletableFuture)task.get(), finish, this::close, name);
    }

    private void runRequest(Supplier<CompletableFuture<Void>> task, Runnable finish, String name) {
        PastePopup.runRequest((UI)this.gui, (PasteClient _c) -> (CompletableFuture)task.get(), finish, this::close, name);
    }

    @Override
    public String getTitle() {
        return this.gui.i18nFormat("button.cpm.edit.pastes", new Object[0]);
    }

    private /* synthetic */ void lambda$new$5() {
        PastePopup.runRequest((UI)this.gui, PasteClient::logout, (T __) -> this.close(), () -> {}, "logout");
    }

    private class PastePanel
    extends Panel {
        private Tooltip tooltip;

        public PastePanel(PasteClient.Paste entry, int y, int w, int i) {
            super(PastePopup.this.getGui());
            this.addElement(new Label(this.gui, entry.name).setBounds(new Box(5, 4, 200, 10)));
            this.tooltip = new Tooltip(PastePopup.this.frm, this.gui.i18nFormat("tooltip.cpm.paste.paste", String.format("%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS", entry.time), entry.id));
            Button btn = new Button(this.gui, this.gui.i18nFormat("button.cpm.delete", new Object[0]), ConfirmPopup.confirmHandler(PastePopup.this.frm, this.gui.i18nFormat("label.cpm.confirm", new Object[0]), this.gui.i18nFormat("label.cpm.confirmDel", new Object[0]), () -> PastePopup.this.runRequest(() -> client.deleteFile(entry.id), () -> PastePopup.this.refreshGui(), "deleting")));
            btn.setBounds(new Box(w - 55, 5, 45, 20));
            this.addElement(btn);
            this.setBounds(new Box(0, y, w, 31));
            if (i % 2 == 1) {
                this.setBackgroundColor(this.gui.getColors().menu_bar_background);
            }
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            super.draw(event, partialTicks);
            if (event.isHovered(this.bounds)) {
                this.tooltip.set();
            }
        }
    }
}

