/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.brigadier.CommandDispatcher;
import com.tom.cpl.tag.AllTagManagers;
import com.tom.cpm.client.CPMTagLoader;
import com.tom.cpm.client.ClientBase;
import com.tom.cpm.client.GuiImpl;
import com.tom.cpm.client.KeyBindings;
import com.tom.cpm.client.PlayerProfile;
import com.tom.cpm.client.PlayerRenderStateAccess;
import com.tom.cpm.common.Command;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.gui.GestureGui;
import com.tom.cpm.shared.gui.SettingsGui;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.options.SkinCustomizationScreen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class CustomPlayerModelsClient
extends ClientBase {
    public static final CustomPlayerModelsClient INSTANCE = new CustomPlayerModelsClient();

    public void preInit(FMLJavaModLoadingContext ctx) {
        this.init0();
        ctx.getModEventBus().addListener(KeyBindings::init);
        ctx.getModEventBus().addListener(INSTANCE::registerReloadListeners);
        ctx.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, scr) -> new GuiImpl(SettingsGui::new, (Screen)scr)));
    }

    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.init1();
    }

    @SubscribeEvent
    public void playerRenderPre(RenderPlayerEvent.Pre event) {
        PlayerRenderStateAccess sa = (PlayerRenderStateAccess)event.getState();
        if (sa.cpm$getPlayer() != null) {
            CustomPlayerModelsClient.INSTANCE.manager.bindPlayerState(sa.cpm$getPlayer(), event.getMultiBufferSource(), event.getRenderer().getModel(), null);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void playerRenderPreC(RenderPlayerEvent.Pre event) {
        if (event.isCanceled()) {
            this.playerRenderPost(event.getMultiBufferSource(), (PlayerModel)event.getRenderer().getModel());
        }
    }

    @SubscribeEvent
    public void playerRenderPost(RenderPlayerEvent.Post event) {
        this.playerRenderPost(event.getMultiBufferSource(), (PlayerModel)event.getRenderer().getModel());
    }

    @SubscribeEvent
    public void initGui(ScreenEvent.Init.Post evt) {
        if (evt.getScreen() instanceof TitleScreen && ModConfig.getCommonConfig().getSetBoolean("titleScreenButton", true) || evt.getScreen() instanceof SkinCustomizationScreen) {
            Screen screen = evt.getScreen();
            Button btn = Button.builder((Component)Component.translatable((String)"button.cpm.open_editor"), b -> Minecraft.getInstance().setScreen((Screen)new GuiImpl(EditorGui::new, screen))).bounds(0, 0, 100, 20).build();
            evt.addListener((GuiEventListener)btn);
            evt.getScreen().children().add(btn);
        }
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START) {
            mc.getPlayerRenderManager().getAnimationEngine().update(evt.getTimer().getGameTimeDeltaPartialTick(true));
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START && !Minecraft.getInstance().isPaused()) {
            mc.getPlayerRenderManager().getAnimationEngine().tick();
        }
        if (Minecraft.getInstance().player == null || evt.phase == TickEvent.Phase.START) {
            return;
        }
        if (KeyBindings.gestureMenuBinding.consumeClick()) {
            Minecraft.getInstance().setScreen((Screen)new GuiImpl(GestureGui::new, null));
        }
        if (KeyBindings.renderToggleBinding.consumeClick()) {
            Player.setEnableRendering(!Player.isEnableRendering());
        }
        mc.getPlayerRenderManager().getAnimationEngine().updateKeys(KeyBindings.quickAccess);
    }

    @SubscribeEvent
    public void openGui(ScreenEvent.Opening openGui) {
        if (openGui.getScreen() instanceof TitleScreen && EditorGui.doOpenEditor()) {
            openGui.setNewScreen((Screen)new GuiImpl(EditorGui::new, openGui.getScreen()));
        }
    }

    @SubscribeEvent
    public void drawGuiPre(ScreenEvent.Render.Pre evt) {
        PlayerProfile.inGui = true;
    }

    @SubscribeEvent
    public void drawGuiPost(ScreenEvent.Render.Post evt) {
        PlayerProfile.inGui = false;
    }

    @SubscribeEvent
    public void onLogout(ClientPlayerNetworkEvent.LoggingOut evt) {
        mc.onLogOut();
    }

    @SubscribeEvent
    public void registerClientCommands(RegisterClientCommandsEvent event) {
        new Command((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), true);
    }

    private void registerReloadListeners(RegisterClientReloadListenersEvent event) {
        mc.setTags(new AllTagManagers(arg_0 -> ((RegisterClientReloadListenersEvent)event).registerReloadListener(arg_0), CPMTagLoader::new));
    }
}

