/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpl.render;

import com.tom.cpl.render.VertexBuffer;

public class DualBuffer
implements VertexBuffer {
    private VertexBuffer first;
    private VertexBuffer second;

    public DualBuffer(VertexBuffer first, VertexBuffer second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public VertexBuffer pos(float x, float y, float z) {
        this.first.pos(x, y, z);
        this.second.pos(x, y, z);
        return this;
    }

    @Override
    public VertexBuffer tex(float u, float v) {
        this.first.tex(u, v);
        this.second.tex(u, v);
        return this;
    }

    @Override
    public VertexBuffer color(float red, float green, float blue, float alpha) {
        this.first.color(red, green, blue, alpha);
        this.second.color(red, green, blue, alpha);
        return this;
    }

    @Override
    public VertexBuffer normal(float x, float y, float z) {
        this.first.normal(x, y, z);
        this.second.normal(x, y, z);
        return this;
    }

    @Override
    public void endVertex() {
        this.first.endVertex();
        this.second.endVertex();
    }

    @Override
    public void finish() {
        this.first.finish();
        this.second.finish();
    }
}

