/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.tom.cpl.text.FormatText;
import com.tom.cpm.CustomPlayerModels;
import com.tom.cpm.client.MinecraftObject;
import com.tom.cpm.client.ModelTexture;
import com.tom.cpm.client.Platform;
import com.tom.cpm.client.PlayerProfile;
import com.tom.cpm.common.ByteArrayPayload;
import com.tom.cpm.common.NetworkInit;
import com.tom.cpm.common.PlayerAnimUpdater;
import com.tom.cpm.mixinplugin.IrisDetector;
import com.tom.cpm.mixinplugin.OFDetector;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.model.RenderManager;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.util.Log;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ElytraModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public abstract class ClientBase {
    public static final ResourceLocation DEFAULT_CAPE = new ResourceLocation("cpm:textures/template/cape.png");
    public static boolean optifineLoaded;
    public static boolean irisLoaded;
    public static boolean vrLoaded;
    public static MinecraftObject mc;
    protected Minecraft minecraft;
    public RenderManager<GameProfile, Player, Model, MultiBufferSource> manager;
    public NetHandler<ResourceLocation, Player, ClientPacketListener> netHandler;

    public void init0() {
        this.minecraft = Minecraft.getInstance();
        mc = new MinecraftObject(this.minecraft);
        optifineLoaded = OFDetector.doApply();
        vrLoaded = Platform.isModLoaded("vivecraft");
        irisLoaded = IrisDetector.doApply();
        if (optifineLoaded) {
            Log.info("Optifine detected, enabling optifine compatibility");
        }
        if (vrLoaded) {
            Log.info("ViveCraft detected, enabling ViveCraft compatibility");
        }
        if (irisLoaded) {
            Log.info("Iris detected, enabling iris compatibility");
        }
    }

    public void init1() {
        this.manager = new RenderManager<GameProfile, Player, Model, MultiBufferSource>(mc.getPlayerRenderManager(), mc.getDefinitionLoader(), PlayerProfile::getPlayerProfile);
        this.manager.setGPGetters(GameProfile::getProperties, Property::value);
        this.netHandler = new NetHandler(ResourceLocation::new);
        this.netHandler.setExecutor(() -> this.minecraft);
        this.netHandler.setSendPacketClient(Function.identity(), (c, rl, pb) -> c.send((Packet)new ServerboundCustomPayloadPacket((CustomPacketPayload)new ByteArrayPayload((ResourceLocation)rl, (byte[])pb))));
        this.netHandler.setPlayerToLoader(Player::getGameProfile);
        this.netHandler.setGetPlayerById(id -> {
            Entity ent = Minecraft.getInstance().level.getEntity(id);
            if (ent instanceof Player) {
                return (Player)ent;
            }
            return null;
        });
        this.netHandler.setGetClient(() -> this.minecraft.player);
        this.netHandler.setGetNet(c -> ((LocalPlayer)c).connection);
        this.netHandler.setDisplayText(t -> this.minecraft.player.displayClientMessage((Component)t.remap(), false));
        this.netHandler.setGetPlayerAnimGetters(new PlayerAnimUpdater());
        NetworkInit.initNetworking(this.netHandler, (Executor)this.minecraft);
    }

    public static void apiInit() {
        CustomPlayerModels.api.buildClient().voicePlayer(Player.class, Entity::getUUID).renderApi(Model.class, ResourceLocation.class, RenderType.class, MultiBufferSource.class, GameProfile.class, ModelTexture::new).localModelApi(GameProfile::new).init();
    }

    public static void renderCape(PoseStack matrixStack, VertexConsumer buffer, int packedLightIn, AbstractClientPlayer abstractClientPlayerEntity, float partialTicks, PlayerModel<AbstractClientPlayer> model, ModelDefinition modelDefinition) {
        float s;
        float r;
        float q;
        matrixStack.pushPose();
        if (abstractClientPlayerEntity != null) {
            double d = Mth.lerp((double)partialTicks, (double)abstractClientPlayerEntity.xCloakO, (double)abstractClientPlayerEntity.xCloak) - Mth.lerp((double)partialTicks, (double)abstractClientPlayerEntity.xo, (double)abstractClientPlayerEntity.getX());
            double e = Mth.lerp((double)partialTicks, (double)abstractClientPlayerEntity.yCloakO, (double)abstractClientPlayerEntity.yCloak) - Mth.lerp((double)partialTicks, (double)abstractClientPlayerEntity.yo, (double)abstractClientPlayerEntity.getY());
            double m = Mth.lerp((double)partialTicks, (double)abstractClientPlayerEntity.zCloakO, (double)abstractClientPlayerEntity.zCloak) - Mth.lerp((double)partialTicks, (double)abstractClientPlayerEntity.zo, (double)abstractClientPlayerEntity.getZ());
            float n = abstractClientPlayerEntity.yBodyRotO + (abstractClientPlayerEntity.yBodyRot - abstractClientPlayerEntity.yBodyRotO);
            double o = Mth.sin((float)(n * ((float)Math.PI / 180)));
            double p = -Mth.cos((float)(n * ((float)Math.PI / 180)));
            q = (float)e * 10.0f;
            q = Mth.clamp((float)q, (float)-6.0f, (float)32.0f);
            r = (float)(d * o + m * p) * 100.0f;
            r = Mth.clamp((float)r, (float)0.0f, (float)150.0f);
            s = (float)(d * p - m * o) * 100.0f;
            s = Mth.clamp((float)s, (float)-20.0f, (float)20.0f);
            if (r < 0.0f) {
                r = 0.0f;
            }
            float t = Mth.lerp((float)partialTicks, (float)abstractClientPlayerEntity.oBob, (float)abstractClientPlayerEntity.bob);
            q += Mth.sin((float)(Mth.lerp((float)partialTicks, (float)abstractClientPlayerEntity.walkDistO, (float)abstractClientPlayerEntity.walkDist) * 6.0f)) * 32.0f * t;
            if (abstractClientPlayerEntity.isCrouching()) {
                q += 50.0f;
            }
            if (abstractClientPlayerEntity.getItemBySlot(EquipmentSlot.CHEST).isEmpty()) {
                if (abstractClientPlayerEntity.isCrouching()) {
                    model.cloak.z = 1.775f;
                    model.cloak.y = 2.35f;
                } else {
                    model.cloak.z = 2.0f;
                    model.cloak.y = 0.0f;
                }
            } else if (abstractClientPlayerEntity.isCrouching()) {
                model.cloak.z = 2.3f;
                model.cloak.y = 1.1f;
            } else {
                model.cloak.z = 2.9f;
                model.cloak.y = 0.14999998f;
            }
        } else {
            r = 0.0f;
            q = 0.0f;
            s = 0.0f;
        }
        model.cloak.xRot = (float)(-Math.toRadians(6.0f + q / 2.0f + r));
        model.cloak.yRot = (float)Math.toRadians(180.0f - s / 2.0f);
        model.cloak.zRot = (float)Math.toRadians(s / 2.0f);
        mc.getPlayerRenderManager().setModelPose(model);
        model.cloak.xRot = 0.0f;
        model.cloak.yRot = 0.0f;
        model.cloak.zRot = 0.0f;
        model.renderCloak(matrixStack, buffer, packedLightIn, OverlayTexture.NO_OVERLAY);
        matrixStack.popPose();
    }

    public <E extends Entity> void renderNameTag(PlayerNameTagRenderer<E> r, E entityIn, GameProfile gprofile, String unique, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        FormatText st;
        double d0 = r.cpm$entityRenderDispatcher().distanceToSqr(entityIn);
        if (d0 < 100.0 && (st = this.manager.getStatus(gprofile, unique)) != null) {
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.0, (double)1.3f, 0.0);
            matrixStackIn.scale(0.5f, 0.5f, 0.5f);
            r.cpm$renderNameTag(entityIn, (Component)st.remap(), matrixStackIn, bufferIn, packedLightIn);
            matrixStackIn.popPose();
        }
    }

    public void playerRenderPre(Player player, MultiBufferSource buffer, PlayerModel model) {
        this.manager.bindPlayer(player, buffer, (Model)model);
    }

    public void playerRenderPost(MultiBufferSource buffer, PlayerModel model) {
        this.manager.unbindClear((Model)model);
    }

    public void renderHand(MultiBufferSource buffer, PlayerModel model) {
        this.manager.bindHand((Player)this.minecraft.player, buffer, (Model)model);
    }

    public void renderHandPost(MultiBufferSource buffer, HumanoidModel model) {
        this.manager.unbindClear((Model)model);
    }

    public void renderSkull(Model skullModel, GameProfile profile, MultiBufferSource buffer) {
        this.manager.bindSkull(profile, buffer, skullModel);
    }

    public void renderSkullPost(MultiBufferSource buffer, Model model) {
        this.manager.unbindFlush(model);
    }

    public void renderElytra(HumanoidModel<LivingEntity> player, ElytraModel<LivingEntity> model) {
        this.manager.bindElytra((Model)player, (Model)model);
    }

    public void renderArmor(HumanoidModel<LivingEntity> modelArmor, HumanoidModel<LivingEntity> modelLeggings, HumanoidModel<LivingEntity> player) {
        this.manager.bindArmor((Model)player, (Model)modelArmor, 1);
        this.manager.bindArmor((Model)player, (Model)modelLeggings, 2);
    }

    public void updateJump() {
        if (this.minecraft.player.onGround() && this.minecraft.player.input.jumping) {
            this.manager.jump((Player)this.minecraft.player);
        }
    }

    public void registerShaders(ShaderLoader loader) {
    }

    public static interface PlayerNameTagRenderer<E extends Entity> {
        public void cpm$renderNameTag(E var1, Component var2, PoseStack var3, MultiBufferSource var4, int var5);

        public EntityRenderDispatcher cpm$entityRenderDispatcher();
    }

    public static interface ShaderLoader {
        public void cpm$registerShader(String var1, VertexFormat var2, Consumer<ShaderInstance> var3);
    }
}

